/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.charttype.square;

import com.kingdee.bos.qing.core.charttype.square.AbstractChartPreprocessor;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.core.model.analysis.square.AbstractChart;
import com.kingdee.bos.qing.core.model.analysis.square.FieldSet;
import com.kingdee.bos.qing.core.model.analysis.square.RollFieldSet;
import com.kingdee.bos.qing.core.model.analysis.square.chart.Area;
import java.util.List;

class AreaPreprocessor
extends AbstractChartPreprocessor {
    AreaPreprocessor() {
    }

    @Override
    protected void preprocessChart(AbstractChart chart) {
        Area area = (Area)chart;
        AreaPreprocessor.washDimension(area.getXAxis(), 1);
        AreaPreprocessor.washDimension(area.getSeries(), 1);
        AreaPreprocessor.washMeasure(area.getYAxis(), area.getSeries().getFieldCount() > 0 ? 1 : 64);
        FieldSet xAxis = area.getXAxis();
        if (xAxis.getFieldCount() > 0) {
            AreaPreprocessor.makeDateFieldContinuous(xAxis.getField(0));
        }
        RollFieldSet rollFieldSet = area.getRoll();
        for (int i = 0; i < rollFieldSet.getFieldCount(); ++i) {
            AreaPreprocessor.makeDateFieldContinuous(rollFieldSet.getField(i));
        }
    }

    @Override
    protected FieldSet getBeRolledFieldSet(AbstractChart chart) {
        Area area = (Area)chart;
        return area.getXAxis();
    }

    @Override
    protected List<AnalyticalField> createBeRolledFieldSetFields(AnalyticalField insteadField, List<AnalyticalField> drillDownPathFields, AbstractChart chart) {
        if (AreaPreprocessor.checkContainsCubeInterlineCalculation(((Area)chart).getYAxis())) {
            drillDownPathFields.add(0, insteadField);
            return drillDownPathFields;
        }
        return super.createBeRolledFieldSetFields(insteadField, drillDownPathFields, chart);
    }
}

