/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.engine;

import com.kingdee.bos.qing.common.grammar.IExecuteContext;
import com.kingdee.bos.qing.core.engine.AbstractDataGetter;
import com.kingdee.bos.qing.core.engine.AbstractEngine;
import com.kingdee.bos.qing.core.engine.AbstractRuntimeFilter;
import com.kingdee.bos.qing.core.engine.CompositeKey;
import com.kingdee.bos.qing.core.engine.DataSourceGreenChannel;
import com.kingdee.bos.qing.core.engine.DetailCombinationRuntimePushdownFilter;
import com.kingdee.bos.qing.core.engine.ParentChildDimensionMember;
import com.kingdee.bos.qing.core.exception.AnalysisException;
import com.kingdee.bos.qing.core.exception.DataTraversalException;
import com.kingdee.bos.qing.core.exception.FormulaExecutingException;
import com.kingdee.bos.qing.core.exception.UserStoppedException;
import com.kingdee.bos.qing.core.model.analysis.IQingModel;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.datasource.exception.AbstractDataSourceException;
import com.kingdee.bos.qing.util.LogUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

abstract class AbstractMdEngine
extends AbstractEngine {
    private DataSourceGreenChannel _dataSourceGreenChannel;
    private List<Expand> _rowExpands;
    private List<Expand> _columnExpands;
    private List<PcdVirtualRoot> _rowPcdTrees;
    private List<PcdVirtualRoot> _columnPcdTrees;

    AbstractMdEngine() {
    }

    public void setDataSourceGreenChannel(DataSourceGreenChannel dsgc) {
        this._dataSourceGreenChannel = dsgc;
    }

    @Override
    protected void setAnalyticalModel(IQingModel model) {
        super.setAnalyticalModel(model);
        this._rowExpands = new ArrayList<Expand>();
        this._columnExpands = new ArrayList<Expand>();
        this.initTreeExpandState(this._rowExpands, this._columnExpands);
    }

    protected abstract List<AnalyticalField> getRowDimensions();

    protected abstract List<AnalyticalField> getColumnDimensions();

    protected abstract void initTreeExpandState(List<Expand> var1, List<Expand> var2);

    protected abstract Set<String> visualDimensionFilter(AnalyticalField var1);

    @Override
    public boolean searchPcdAsParent(int dimensionIdx, ParentChildDimensionMember member) {
        PcdNode node = this.searchTreeNode(dimensionIdx, member);
        return node != null && node.hasChildren();
    }

    private PcdNode searchTreeNode(int dimensionIdx, ParentChildDimensionMember member) {
        int rowDimensionCount = this._rowPcdTrees.size();
        if (dimensionIdx < rowDimensionCount) {
            PcdVirtualRoot virtualRoot = this._rowPcdTrees.get(dimensionIdx);
            return virtualRoot.searchDescendant(member);
        }
        int columnDimmensionCount = this._columnPcdTrees.size();
        if ((dimensionIdx -= rowDimensionCount) < columnDimmensionCount) {
            PcdVirtualRoot virtualRoot = this._columnPcdTrees.get(dimensionIdx);
            return virtualRoot.searchDescendant(member);
        }
        return null;
    }

    @Override
    protected void traversalData() throws AnalysisException {
        boolean allTreeCompleted;
        try {
            allTreeCompleted = this.confirmDimensionTree();
        }
        catch (AbstractDataSourceException ex) {
            throw new DataTraversalException((Exception)((Object)ex));
        }
        if (allTreeCompleted) {
            ArrayList<AbstractRuntimeFilter.IRuntimePushdownFilter> memberCombinationFilters = new ArrayList<AbstractRuntimeFilter.IRuntimePushdownFilter>();
            Set<List<String>> rowMemberCombination = this.compositeMembersAtRow(memberCombinationFilters);
            Set<List<String>> columnMemberCombination = this.compositeMembersAtColumn(memberCombinationFilters);
            super.traversalData(memberCombinationFilters);
            if (!rowMemberCombination.isEmpty() || !columnMemberCombination.isEmpty()) {
                if (columnMemberCombination.isEmpty()) {
                    this.makeSureNotSparse(rowMemberCombination);
                } else if (rowMemberCombination.isEmpty()) {
                    this.makeSureNotSparse(columnMemberCombination);
                } else {
                    this.makeSureNotSparse(rowMemberCombination, columnMemberCombination);
                }
            }
        }
    }

    private boolean confirmDimensionTree() throws AbstractDataSourceException, UserStoppedException {
        Set<String> appointedIdByFilters;
        DimensionTreeConfirmer dtc;
        PcdVirtualRoot virtualRoot;
        this._rowPcdTrees = new ArrayList<PcdVirtualRoot>();
        for (AnalyticalField field : this.getRowDimensions()) {
            virtualRoot = null;
            if (field.isParentChildDimension() && !(virtualRoot = (dtc = new DimensionTreeConfirmer(field, appointedIdByFilters = this.visualDimensionFilter(field))).confirm(this._dataSourceGreenChannel)).hasChildren()) {
                return false;
            }
            this._rowPcdTrees.add(virtualRoot);
        }
        this._columnPcdTrees = new ArrayList<PcdVirtualRoot>();
        for (AnalyticalField field : this.getColumnDimensions()) {
            virtualRoot = null;
            if (field.isParentChildDimension() && !(virtualRoot = (dtc = new DimensionTreeConfirmer(field, appointedIdByFilters = this.visualDimensionFilter(field))).confirm(this._dataSourceGreenChannel)).hasChildren()) {
                return false;
            }
            this._columnPcdTrees.add(virtualRoot);
        }
        return true;
    }

    private Set<List<String>> compositeMembersAtRow(List<AbstractRuntimeFilter.IRuntimePushdownFilter> appendToFilters) {
        return AbstractMdEngine.compositeMembers(this.getRowDimensions(), this._rowExpands, this._rowPcdTrees, appendToFilters);
    }

    private Set<List<String>> compositeMembersAtColumn(List<AbstractRuntimeFilter.IRuntimePushdownFilter> appendToFilters) {
        return AbstractMdEngine.compositeMembers(this.getColumnDimensions(), this._columnExpands, this._columnPcdTrees, appendToFilters);
    }

    private static Set<List<String>> compositeMembers(List<AnalyticalField> dims, List<Expand> expands, List<PcdVirtualRoot> trees, List<AbstractRuntimeFilter.IRuntimePushdownFilter> appendToFilters) {
        Set<List<String>> combination;
        if (dims.isEmpty()) {
            combination = new HashSet<List<String>>();
        } else {
            DimensionMemberCombination dmc = new DimensionMemberCombination();
            dmc.setDimensionCount(dims.size());
            dmc.composite(expands, trees);
            combination = dmc.getCombination();
            DetailCombinationRuntimePushdownFilter rtFilter = new DetailCombinationRuntimePushdownFilter(dims, combination);
            appendToFilters.add(rtFilter);
        }
        return combination;
    }

    private void makeSureNotSparse(Set<List<String>> rowMemberCombination, Set<List<String>> columnMemberCombination) {
        for (List<String> rowItem : rowMemberCombination) {
            int rowDimensionCount = rowItem.size();
            for (List<String> columnItem : columnMemberCombination) {
                PcdNode member;
                ParentChildDimensionMember searchingMember;
                String id;
                int i;
                CompositeKey dimKey = new CompositeKey();
                for (i = 0; i < rowDimensionCount; ++i) {
                    id = rowItem.get(i);
                    searchingMember = ParentChildDimensionMember.createSearchingKey(id);
                    member = this.searchTreeNode(i, searchingMember);
                    dimKey.addMember(member);
                }
                for (i = 0; i < columnItem.size(); ++i) {
                    id = columnItem.get(i);
                    searchingMember = ParentChildDimensionMember.createSearchingKey(id);
                    member = this.searchTreeNode(i + rowDimensionCount, searchingMember);
                    dimKey.addMember(member);
                }
                this.getCuboid().getCellAggregators(dimKey);
            }
        }
    }

    private void makeSureNotSparse(Set<List<String>> memberCombination) {
        for (List<String> item : memberCombination) {
            CompositeKey dimKey = new CompositeKey();
            for (int i = 0; i < item.size(); ++i) {
                String id = item.get(i);
                ParentChildDimensionMember searchingMember = ParentChildDimensionMember.createSearchingKey(id);
                PcdNode member = this.searchTreeNode(i, searchingMember);
                dimKey.addMember(member);
            }
            this.getCuboid().getCellAggregators(dimKey);
        }
    }

    public static class DimensionMemberCombination {
        private int _dimensions;
        private Set<List<String>> _items = new HashSet<List<String>>();

        public void setDimensionCount(int dimensions) {
            this._dimensions = dimensions;
        }

        public Set<List<String>> getCombination() {
            return this._items;
        }

        public void composite(List<Expand> allExpands, List<PcdVirtualRoot> trees) {
            LinkedList<Expand> remainExpands = new LinkedList<Expand>();
            for (Expand expand : allExpands) {
                remainExpands.add(expand);
            }
            ArrayList<String> pickedMembers = new ArrayList<String>();
            List<Expand> currentExpands = this.searchCurrentExpands(remainExpands, pickedMembers);
            this.composite(pickedMembers, currentExpands, remainExpands, trees);
        }

        private void composite(List<String> pickedMembers, List<Expand> currentExpands, List<Expand> remainExpands, List<PcdVirtualRoot> trees) {
            int currentDimensionIndex = pickedMembers.size();
            HashSet<String> currentVisibles = new HashSet<String>();
            PcdVirtualRoot virtualRoot = trees.get(currentDimensionIndex);
            Set<PcdNode> allRoot = virtualRoot.getChildren();
            for (PcdNode pcdNode : allRoot) {
                currentVisibles.add(pcdNode.getIdValue().toString());
            }
            if (!currentExpands.isEmpty()) {
                HashSet<String> expandedIds = new HashSet<String>();
                for (Expand expand : currentExpands) {
                    String id = expand.getMemberId(currentDimensionIndex);
                    expandedIds.add(id);
                }
                LinkedList<PcdNode> linkedList = new LinkedList<PcdNode>();
                linkedList.addAll(allRoot);
                while (!linkedList.isEmpty()) {
                    PcdNode eachNode = (PcdNode)linkedList.removeFirst();
                    if (!expandedIds.contains(eachNode.getIdValue()) || !eachNode.hasChildren()) continue;
                    Set<PcdNode> children = eachNode.getChildren();
                    Iterator iterator = children.iterator();
                    while (iterator.hasNext()) {
                        PcdNode child = (PcdNode)iterator.next();
                        currentVisibles.add(child.getIdValue().toString());
                    }
                    linkedList.addAll(children);
                }
            }
            for (String string : currentVisibles) {
                ArrayList<String> item = new ArrayList<String>();
                for (String picked : pickedMembers) {
                    item.add(picked);
                }
                item.add(string);
                if (currentDimensionIndex == this._dimensions - 1) {
                    this._items.add(item);
                    continue;
                }
                List<Expand> nextExpands = this.searchCurrentExpands(remainExpands, item);
                this.composite(item, nextExpands, remainExpands, trees);
            }
        }

        private List<Expand> searchCurrentExpands(List<Expand> remainExpands, List<String> pickedMembers) {
            int currentDimensionIndex = pickedMembers.size();
            ArrayList<Expand> currentExpands = new ArrayList<Expand>();
            Iterator<Expand> it = remainExpands.iterator();
            while (it.hasNext()) {
                Expand expand = it.next();
                if (expand.getMatchedDimensionCount() - 1 != currentDimensionIndex) continue;
                boolean matched = true;
                for (int i = 0; i < pickedMembers.size(); ++i) {
                    String id = pickedMembers.get(i);
                    if (id.equals(expand.getMemberId(i))) continue;
                    matched = false;
                    break;
                }
                if (!matched) continue;
                currentExpands.add(expand);
                it.remove();
            }
            return currentExpands;
        }
    }

    public static class Expand {
        private String[] _targets;

        public Expand(String[] targets) {
            this._targets = targets;
        }

        public int getMatchedDimensionCount() {
            return this._targets.length;
        }

        public String getMemberId(int dimensionIdx) {
            return this._targets[dimensionIdx];
        }
    }

    private static class PcdVirtualRoot
    extends PcdNode {
        private Map<Object, PcdNode> _descendants;

        public PcdVirtualRoot() {
            super(null);
        }

        public PcdNode searchDescendant(ParentChildDimensionMember member) {
            if (this._descendants == null) {
                this._descendants = new HashMap<Object, PcdNode>();
                LinkedList<PcdNode> queue = new LinkedList<PcdNode>();
                queue.addAll(this.getChildren());
                while (!queue.isEmpty()) {
                    PcdNode eachNode = (PcdNode)queue.removeFirst();
                    this._descendants.put(eachNode.getIdValue(), eachNode);
                    if (!eachNode.hasChildren()) continue;
                    queue.addAll(eachNode.getChildren());
                }
            }
            return this._descendants.get(member.getIdValue());
        }
    }

    private static class PcdNode
    extends ParentChildDimensionMember {
        private PcdNode _parentNode;
        private Set<PcdNode> _childrenNodes;

        public PcdNode(Object idFieldValue) {
            super(idFieldValue);
        }

        public void setParent(PcdNode parentNode) {
            this._parentNode = parentNode;
            this._parentNode.appendChild(this);
        }

        public PcdNode getParent() {
            return this._parentNode;
        }

        private void appendChild(PcdNode childNode) {
            if (this._childrenNodes == null) {
                this._childrenNodes = new HashSet<PcdNode>();
            }
            this._childrenNodes.add(childNode);
        }

        public boolean hasChildren() {
            return this._childrenNodes != null;
        }

        public Set<PcdNode> getChildren() {
            return this._childrenNodes;
        }
    }

    private static class DimensionTreeConfirmer
    extends DataSourceGreenChannel.AbstractValueCollecter {
        private String _idField;
        private String _parentIdField;
        private String _displayField;
        private Set<String> _appointedIdByFilters;
        private AbstractEngine.FormulaExecuteContext _formulaExecuteContext;
        private AbstractDataGetter _dataGetter;
        private Map<Object, PcdNode> _members;

        public DimensionTreeConfirmer(AnalyticalField field, Set<String> appointedIdByFilters) {
            this._idField = field.getParentChildDimensionIdField().getFullName();
            this._parentIdField = field.getParentChildDimensionParentIdField().getFullName();
            this._displayField = field.getMetaField().getFullName();
            this._appointedIdByFilters = appointedIdByFilters;
            this._formulaExecuteContext = new AbstractEngine.FormulaExecuteContext();
            this._dataGetter = AbstractDataGetter.create(field, (IExecuteContext)this._formulaExecuteContext);
            this._members = new HashMap<Object, PcdNode>();
        }

        public PcdVirtualRoot confirm(DataSourceGreenChannel dsgc) throws AbstractDataSourceException, UserStoppedException {
            HashSet<String> fields = new HashSet<String>();
            fields.add(this._idField);
            fields.add(this._parentIdField);
            fields.add(this._displayField);
            dsgc.getDistinctValue(fields, (DataSourceGreenChannel.AbstractValueCollecter)this);
            PcdVirtualRoot virtualRoot = this.buildTree();
            return virtualRoot;
        }

        @Override
        public void accept(Map<String, Object> row) {
            this._formulaExecuteContext.bindData(row);
            Object member = this.getData(this._dataGetter, row);
            ParentChildDimensionMember pcdMember = (ParentChildDimensionMember)member;
            if (this._appointedIdByFilters == null || this._appointedIdByFilters.contains(pcdMember.getIdValue())) {
                PcdNode node = new PcdNode(pcdMember.getIdValue());
                node.setValue(pcdMember.getParentIdValue(), pcdMember.getDisplayValue(), pcdMember.getSortAccordingValue());
                this._members.put(pcdMember.getIdValue(), node);
            }
        }

        private Object getData(AbstractDataGetter dataGetter, Map<String, ?> row) {
            try {
                Object data = dataGetter.getData(row);
                return data;
            }
            catch (FormulaExecutingException ex) {
                if (LogUtil.isDebugEnabled()) {
                    LogUtil.debug((String)"Execute formula error.", (Throwable)((Object)ex));
                }
                return null;
            }
        }

        private PcdVirtualRoot buildTree() {
            PcdVirtualRoot virtualRoot = new PcdVirtualRoot();
            for (Map.Entry<Object, PcdNode> item : this._members.entrySet()) {
                PcdNode member = item.getValue();
                Object parentId = member.getParentIdValue();
                PcdNode parentNode = null;
                if (parentId != null) {
                    parentNode = this._members.get(parentId);
                }
                if (parentNode == null) {
                    parentNode = virtualRoot;
                }
                member.setParent(parentNode);
            }
            return virtualRoot;
        }
    }
}

