/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.engine;

import com.kingdee.bos.qing.core.engine.AbstractRuntimeCubeFilter;
import com.kingdee.bos.qing.core.engine.AbstractRuntimeDsFilter;
import com.kingdee.bos.qing.core.engine.AggregatedValueRuntimeFilter;
import com.kingdee.bos.qing.core.engine.ContinuousDateRuntimeFilter;
import com.kingdee.bos.qing.core.engine.ContinuousRuntimeFilter;
import com.kingdee.bos.qing.core.engine.Cuboid;
import com.kingdee.bos.qing.core.engine.DiscreteRuntimeFilter;
import com.kingdee.bos.qing.core.engine.MemberRuntimeFilter;
import com.kingdee.bos.qing.core.engine.RuntimePushdownFilter;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.core.model.analysis.common.filter.AbstractAnalyticalFilter;
import com.kingdee.bos.qing.core.model.analysis.common.filter.ContinuousDateFilter;
import com.kingdee.bos.qing.core.model.analysis.common.filter.ContinuousFilter;
import com.kingdee.bos.qing.core.model.analysis.common.filter.DiscreteFilter;
import com.kingdee.bos.qing.core.model.meta.DataType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class AbstractRuntimeFilter {
    private AnalyticalField _field;
    private AbstractAnalyticalFilter _filter;

    protected AbstractRuntimeFilter(AnalyticalField field, AbstractAnalyticalFilter filter) {
        this._field = field;
        this._filter = filter;
    }

    protected final AnalyticalField getField() {
        return this._field;
    }

    protected AbstractAnalyticalFilter getFilter() {
        return this._filter;
    }

    public static List<IRuntimePushdownFilter> createRuntimePushdownFilters(IModelVisitor modelVisitor) {
        ArrayList<IRuntimePushdownFilter> rtFilters = new ArrayList<IRuntimePushdownFilter>();
        boolean isContainsCubeInterline = modelVisitor.isContainsCubeInterlineCalculation();
        int c = modelVisitor.getFilterCount();
        for (int i = 0; i < c; ++i) {
            boolean isForInterline;
            boolean isTarget;
            AnalyticalField field = modelVisitor.getFilterField(i);
            AbstractAnalyticalFilter filter = modelVisitor.getFilter(i);
            if (filter.isAllAccepted()) continue;
            boolean bl = isTarget = field.isDimension() && !field.getMetaField().isCalculation() && !filter.isForcedPullDownDisabled();
            if (!isTarget) continue;
            boolean bl2 = isForInterline = isContainsCubeInterline && AbstractRuntimeFilter.isForInterline(field, modelVisitor, null);
            if (isForInterline) continue;
            rtFilters.add(new RuntimePushdownFilter(field, filter));
        }
        return rtFilters;
    }

    public static List<AbstractRuntimeDsFilter> createRuntimeDsFilters(IModelVisitor modelVisitor) {
        ArrayList<AbstractRuntimeDsFilter> rtFilters = new ArrayList<AbstractRuntimeDsFilter>();
        boolean isContainsCubeInterline = modelVisitor.isContainsCubeInterlineCalculation();
        int c = modelVisitor.getFilterCount();
        for (int i = 0; i < c; ++i) {
            boolean isForInterline;
            boolean isTarget;
            AbstractAnalyticalFilter filter;
            AnalyticalField field = modelVisitor.getFilterField(i);
            if (field.getMetaField().isCalculation() && !field.getMetaField().isValidCalculation() || (filter = modelVisitor.getFilter(i)).isAllAccepted()) continue;
            boolean bl = isTarget = field.isDimension() && (field.getMetaField().isCalculation() || filter.isForcedPullDownDisabled());
            if (!isTarget) continue;
            boolean bl2 = isForInterline = isContainsCubeInterline && AbstractRuntimeFilter.isForInterline(field, modelVisitor, null);
            if (isForInterline) continue;
            if (filter instanceof DiscreteFilter) {
                if (!AbstractRuntimeFilter.checkDiscreteFilter(field)) continue;
                rtFilters.add(new DiscreteRuntimeFilter(field, (DiscreteFilter)filter));
                continue;
            }
            if (filter instanceof ContinuousFilter) {
                if (!AbstractRuntimeFilter.checkContinuousFilter(field)) continue;
                rtFilters.add(new ContinuousRuntimeFilter(field, (ContinuousFilter)filter));
                continue;
            }
            if (filter instanceof ContinuousDateFilter) {
                if (!AbstractRuntimeFilter.checkContinuousDateFilter(field)) continue;
                rtFilters.add(new ContinuousDateRuntimeFilter(field, (ContinuousDateFilter)filter));
                continue;
            }
            throw new RuntimeException("Modify here.");
        }
        return rtFilters;
    }

    public static List<AbstractRuntimeCubeFilter> createRuntimeCubeFilters(IModelVisitor modelVisitor, Cuboid cuboid) {
        ArrayList<AbstractRuntimeCubeFilter> rtFilters = new ArrayList<AbstractRuntimeCubeFilter>();
        boolean isContainsCubeInterline = modelVisitor.isContainsCubeInterlineCalculation();
        int c = modelVisitor.getFilterCount();
        for (int i = 0; i < c; ++i) {
            boolean isTarget;
            AbstractAnalyticalFilter filter;
            AnalyticalField field = modelVisitor.getFilterField(i);
            if (field.getMetaField().isCalculation() && !field.getMetaField().isValidCalculation() || (filter = modelVisitor.getFilter(i)).isAllAccepted()) continue;
            HashSet<AnalyticalField> cubeInterlineDims = new HashSet<AnalyticalField>(0);
            boolean isForInterline = isContainsCubeInterline && AbstractRuntimeFilter.isForInterline(field, modelVisitor, cubeInterlineDims);
            boolean bl = isTarget = field.isMeasure() || isForInterline;
            if (!isTarget) continue;
            if (filter instanceof DiscreteFilter) {
                if (!AbstractRuntimeFilter.checkDiscreteFilter(field)) continue;
                int dimIdx = AbstractRuntimeFilter.searchCubeInterlineDimensionIndex(cubeInterlineDims, cuboid);
                rtFilters.add(new MemberRuntimeFilter(field, (DiscreteFilter)filter, dimIdx));
                continue;
            }
            if (filter instanceof ContinuousFilter) {
                if (!AbstractRuntimeFilter.checkContinuousFilter(field)) continue;
                rtFilters.add(new AggregatedValueRuntimeFilter(field, (ContinuousFilter)filter));
                continue;
            }
            if (filter instanceof ContinuousDateFilter) {
                throw new UnsupportedOperationException("Cube filter unsupport the type of ContinuousDate.");
            }
            throw new RuntimeException("Modify here.");
        }
        return rtFilters;
    }

    private static int searchCubeInterlineDimensionIndex(Set<AnalyticalField> cubeInterlineDims, Cuboid cuboid) {
        int dimIdx = -1;
        List<AnalyticalField> dfs = cuboid.getDimensionFields();
        for (int k = 0; k < dfs.size(); ++k) {
            if (!cubeInterlineDims.contains(dfs.get(k))) continue;
            dimIdx = k;
            break;
        }
        return dimIdx;
    }

    public static RuntimePushdownFilter createDiscreteRuntimePushdownFilter(AnalyticalField field, DiscreteFilter filter) {
        return new RuntimePushdownFilter(field, filter);
    }

    private static boolean checkDiscreteFilter(AnalyticalField field) {
        return DataType.DATE != field.getDataType() || field.getPartValue() != null;
    }

    private static boolean checkContinuousFilter(AnalyticalField field) {
        return DataType.NUMBER == field.getMetaField().getDataType();
    }

    private static boolean checkContinuousDateFilter(AnalyticalField field) {
        return DataType.DATE == field.getMetaField().getDataType();
    }

    private static boolean isForInterline(AnalyticalField field, IModelVisitor modelVisitor, Set<AnalyticalField> interest) {
        boolean isForInterline;
        Set<AnalyticalField> cubeInterlineDims = modelVisitor.getCubeInterlineDimensions(field);
        boolean bl = isForInterline = !cubeInterlineDims.isEmpty();
        if (interest != null) {
            interest.addAll(cubeInterlineDims);
        }
        return isForInterline;
    }

    public static interface IRuntimePushdownFilter {
    }

    public static interface IModelVisitor {
        public int getFilterCount();

        public AnalyticalField getFilterField(int var1);

        public AbstractAnalyticalFilter getFilter(int var1);

        public boolean isContainsCubeInterlineCalculation();

        public Set<AnalyticalField> getCubeInterlineDimensions(AnalyticalField var1);
    }
}

