/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.engine;

import com.kingdee.bos.qing.core.engine.AbstractEngine;
import com.kingdee.bos.qing.core.engine.AbstractMdEngine;
import com.kingdee.bos.qing.core.engine.AbstractRuntimeFilter;
import com.kingdee.bos.qing.core.engine.EngineOfLonger;
import com.kingdee.bos.qing.core.model.analysis.AbstractQingModel;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.core.model.analysis.common.filter.AbstractAnalyticalFilter;
import com.kingdee.bos.qing.core.model.analysis.common.filter.DiscreteFilter;
import com.kingdee.bos.qing.core.model.analysis.longer.AnalyticalModel;
import com.kingdee.bos.qing.core.model.analysis.longer.FilterFieldSet;
import com.kingdee.bos.qing.core.model.analysis.longer.ModelAssistantStructure;
import com.kingdee.bos.qing.core.model.analysis.longer.preferences.ExhibitionStatus;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class MdEngineOfLonger
extends AbstractMdEngine {
    private AnalyticalModel _model;
    private ModelAssistantStructure _modelAssistantStructure;

    public void setAnalyticalModel(AnalyticalModel model) {
        this._model = model;
        super.setAnalyticalModel(model);
    }

    public void setModelAssistantStructure(ModelAssistantStructure modelAssistantStructure) {
        this._modelAssistantStructure = modelAssistantStructure;
    }

    public ModelAssistantStructure getModelAssistantStructure() {
        return this._modelAssistantStructure;
    }

    @Override
    protected AbstractRuntimeFilter.IModelVisitor createModelVisitorForRuntimeFilter(boolean isIgnoredCubeInterlineCalculation) {
        return new EngineOfLonger.ModelVisitorForRuntimeFilter(this._model, isIgnoredCubeInterlineCalculation);
    }

    @Override
    protected List<AnalyticalField> getFilterFields() {
        FilterFieldSet ffs = this._model.getFilterFieldSet();
        return ffs == null ? null : ffs.getFields();
    }

    @Override
    protected AbstractEngine.ISubtotalDependance createSubtotalDependance() {
        return new EngineOfLonger.SubtotalDependance(this._model, this._modelAssistantStructure);
    }

    @Override
    protected List<AnalyticalField> getRowDimensions() {
        return this._modelAssistantStructure.getRowDimensionFields();
    }

    @Override
    protected List<AnalyticalField> getColumnDimensions() {
        return this._modelAssistantStructure.getColumnDimensionFields();
    }

    @Override
    protected void initTreeExpandState(List<AbstractMdEngine.Expand> rowExpands, List<AbstractMdEngine.Expand> columnExpands) {
        List<ExhibitionStatus.TreeExpandState> all = this._model.getTreeExpandStates();
        for (ExhibitionStatus.TreeExpandState state : all) {
            if (!state.isExpanded()) continue;
            AbstractMdEngine.Expand expand = new AbstractMdEngine.Expand(state.getKeys());
            if (state.isHorizontal()) {
                columnExpands.add(expand);
                continue;
            }
            rowExpands.add(expand);
        }
    }

    @Override
    protected Set<String> visualDimensionFilter(AnalyticalField pcdField) {
        final ArrayList<DiscreteFilter> filters = new ArrayList<DiscreteFilter>();
        final String pcdIdMf = pcdField.getParentChildDimensionIdField().getFullName();
        this._model.visitFilters(new AbstractQingModel.IFilterVisitor(){

            @Override
            public void visit(AnalyticalField field, AbstractAnalyticalFilter filter) {
                if (field.isParentChildDimension() && filter instanceof DiscreteFilter && pcdIdMf.equals(field.getParentChildDimensionIdField().getFullName())) {
                    filters.add((DiscreteFilter)filter);
                }
            }
        });
        if (filters.isEmpty()) {
            return null;
        }
        return this.mergeFiltersSelectedIds(filters);
    }

    private Set<String> mergeFiltersSelectedIds(List<DiscreteFilter> filters) {
        Set<String> result = null;
        for (DiscreteFilter filter : filters) {
            if (filter.isAllAccepted()) continue;
            if (filter.isExclude()) {
                throw new RuntimeException("'Exclude' is not supported.");
            }
            Set<String> searcher = MdEngineOfLonger.createSearcher(filter.getSelecteds());
            if (result == null) {
                result = searcher;
                continue;
            }
            Iterator<String> it = result.iterator();
            while (it.hasNext()) {
                String value = it.next();
                if (searcher.contains(value)) continue;
                it.remove();
            }
        }
        return result;
    }

    private static Set<String> createSearcher(List<String> selecteds) {
        HashSet<String> searcher = new HashSet<String>();
        for (String value : selecteds) {
            searcher.add(value);
        }
        return searcher;
    }
}

