/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.engine;

import com.kingdee.bos.qing.core.engine.Aggregator;
import com.kingdee.bos.qing.core.engine.CompositeKey;
import com.kingdee.bos.qing.core.engine.Cuboid;
import com.kingdee.bos.qing.core.engine.EliminationProcessor;
import com.kingdee.bos.qing.core.model.analysis.common.Aggregation;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SubCuboidCalculater {
    public static final String ALL = "com.kingdee.bos.qing.All";
    private Cuboid _parentCuboid;
    private boolean[] _dimensionTag;
    private Cuboid _subCuboid;

    public void setParentCuboid(Cuboid parent) {
        this._parentCuboid = parent;
    }

    public void setDimensionTag(boolean[] tag) {
        this._dimensionTag = tag;
    }

    public void generateSubCuboid(EliminationProcessor eliminationProcessor) {
        List<AnalyticalField> dimensionFields = this._parentCuboid.getDimensionFields();
        List<AnalyticalField> measureFields = this._parentCuboid.getMeasureFields();
        int dimensionCount = dimensionFields.size();
        int measureCount = measureFields.size();
        ArrayList<Aggregation> aggregations = new ArrayList<Aggregation>(measureCount);
        for (int k = 0; k < measureCount; ++k) {
            AnalyticalField field = measureFields.get(k);
            if (field.getTotalUsing() == null) {
                aggregations.add(field.getAggregation());
                continue;
            }
            aggregations.add(field.getTotalUsing());
        }
        this._subCuboid = new Cuboid();
        this._subCuboid.setDimensionFields(dimensionFields);
        this._subCuboid.setMeasureFields(measureFields);
        this._subCuboid.setAppointedAggregations(aggregations);
        Iterator<CompositeKey> it = this._parentCuboid.createDimensionKeyIterator();
        while (it.hasNext()) {
            CompositeKey keyInParent = it.next();
            CompositeKey keyInSub = new CompositeKey();
            for (int i = 0; i < dimensionCount; ++i) {
                Object member = i >= this._dimensionTag.length || this._dimensionTag[i] ? keyInParent.getMember(i) : ALL;
                keyInSub.addMember(member);
            }
            Aggregator[] aggInParent = this._parentCuboid.getCellAggregators(keyInParent);
            Aggregator[] aggInSub = this._subCuboid.getCellAggregators(keyInSub);
            for (int k = 0; k < measureCount; ++k) {
                AnalyticalField field = measureFields.get(k);
                if (eliminationProcessor != null && eliminationProcessor.isDuplicated(k, keyInSub, keyInParent)) continue;
                if (field.getTotalUsing() == null) {
                    aggInSub[k].add(aggInParent[k]);
                    continue;
                }
                Aggregator aggregator = aggInParent[k];
                Object value = aggregator.getValue();
                aggInSub[k].append(value);
            }
        }
        if (eliminationProcessor != null) {
            eliminationProcessor.release();
        }
    }

    public Cuboid getSubCuboid() {
        return this._subCuboid;
    }
}

