/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.engine.func;

import com.kingdee.bos.qing.common.grammar.exception.ExecuteException;
import com.kingdee.bos.qing.common.grammar.exception.ParserException;
import com.kingdee.bos.qing.common.grammar.expr.IExpr;
import com.kingdee.bos.qing.core.engine.Aggregator;
import com.kingdee.bos.qing.core.engine.CompositeKey;
import com.kingdee.bos.qing.core.engine.Cuboid;
import com.kingdee.bos.qing.core.engine.func.AbstractInterlineFunction;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;

public class RunningSum
extends AbstractInterlineFunction {
    private MemberExistChecker _memberExistChecker = new MemberExistChecker();
    private Calendar _minDate;

    public RunningSum() {
        super("RunningSum");
    }

    public void setMinDate(Calendar minDate) {
        this._minDate = minDate;
    }

    protected final void checkSubExprsDataType(IExpr[] subExprs) throws ParserException {
        if (subExprs.length < 1 || subExprs.length > 2) {
            throw RunningSum.exUnmatchedParamCount((IExpr)this);
        }
        IExpr param = subExprs[0];
        if (param.getReturnDataType() != 2) {
            throw RunningSum.exUnmatchedDataType((IExpr)param);
        }
        if (subExprs.length == 2 && (param = subExprs[1]).getReturnDataType() != 1) {
            throw RunningSum.exUnmatchedDataType((IExpr)param);
        }
    }

    private IExpr getFirstParamExpr() {
        return this.getSubExprs()[0];
    }

    private IExpr getSecondParamExpr() {
        IExpr[] subExprs = this.getSubExprs();
        if (subExprs.length == 2) {
            return subExprs[1];
        }
        return null;
    }

    @Override
    protected AbstractInterlineFunction.IDateParser createDateParser(List<AnalyticalField> dimensionFields) {
        return new DateParser(dimensionFields);
    }

    @Override
    protected String getPretreatDateField(AbstractInterlineFunction.IDateParser parser) {
        return parser.getDateFieldFullName();
    }

    @Override
    public BigDecimal interlineExecuteImpl(AbstractInterlineFunction.IInterlineEnv interlineEnv, AbstractInterlineFunction.IDateParser dateParser) throws ExecuteException {
        this._memberExistChecker.bind(interlineEnv.getCuboid());
        AbstractInterlineFunction.LastPeriodDateParser.Interval interval = null;
        IExpr param2 = this.getSecondParamExpr();
        if (param2 != null) {
            Object param2Value = param2.execute(interlineEnv.createThisLineContext());
            interval = AbstractInterlineFunction.LastPeriodDateParser.Interval.parseString(param2Value);
        }
        ((AbstractInterlineFunction.LastPeriodDateParser)dateParser).setInterval(interval);
        ArrayList<HungryLine> stack = new ArrayList<HungryLine>();
        BigDecimal headRunningSum = this.forward(interlineEnv, dateParser, stack);
        BigDecimal runningSum = this.backward(headRunningSum, stack);
        return runningSum;
    }

    private BigDecimal forward(AbstractInterlineFunction.IInterlineEnv interlineEnv, AbstractInterlineFunction.IDateParser dateParser, List<HungryLine> stack) throws ExecuteException {
        Cuboid cuboid = interlineEnv.getCuboid();
        int currentMeasureIndex = interlineEnv.getCurrentMeasureIndex();
        IExpr param = this.getFirstParamExpr();
        HashSet<CompositeKey> routed = new HashSet<CompositeKey>();
        BigDecimal headRunningSum = BigDecimal.ZERO;
        AbstractInterlineFunction.IInterlineEnv thisLineEnv = interlineEnv;
        boolean isStopForward = false;
        while (!isStopForward) {
            CompositeKey thisDimKey = thisLineEnv.getThisLineDimension();
            routed.add(thisDimKey);
            Aggregator[] thisAggrs = cuboid.getNullableCellAggregators(thisDimKey);
            if (thisAggrs == null) {
                isStopForward = true;
                continue;
            }
            Aggregator.Agg currentThisLineAggr = (Aggregator.Agg)thisAggrs[currentMeasureIndex];
            Object thisLineRunningSum = currentThisLineAggr.getInterimValue((IExpr)this);
            if (thisLineRunningSum instanceof BigDecimal) {
                isStopForward = true;
                headRunningSum = (BigDecimal)thisLineRunningSum;
                continue;
            }
            Object me = param.execute(thisLineEnv.createThisLineContext());
            BigDecimal thisLineValue = me == null ? null : (BigDecimal)me;
            HungryLine hungryLine = new HungryLine(this, thisLineValue, currentThisLineAggr);
            stack.add(hungryLine);
            CompositeKey previousDimKey = dateParser.createAnotherDimensionKey(thisDimKey);
            if (previousDimKey == null || routed.contains(previousDimKey)) {
                isStopForward = true;
                break;
            }
            thisLineEnv.previousLine(previousDimKey);
        }
        return headRunningSum;
    }

    private BigDecimal backward(BigDecimal headRunningSum, List<HungryLine> stack) {
        BigDecimal runningSum = headRunningSum;
        while (!stack.isEmpty()) {
            HungryLine hungryLine = stack.remove(stack.size() - 1);
            runningSum = hungryLine.feed(runningSum);
        }
        return runningSum;
    }

    private class DateParser
    extends AbstractInterlineFunction.LastPeriodDateParser {
        public DateParser(List<AnalyticalField> dimensionFields) {
            super(dimensionFields);
        }

        @Override
        protected boolean isAccepted(CompositeKey dimKeyToCheckExist, Object[] dateMembers) {
            if (RunningSum.this._memberExistChecker.isExist(dimKeyToCheckExist)) {
                return true;
            }
            Calendar calendar = Calendar.getInstance();
            calendar.set(1970, 0, 1, 0, 0, 0);
            calendar.set(14, 0);
            for (int partIdx = this._dimIdxs.length - 1; partIdx >= 0; --partIdx) {
                int dimIdx = this._dimIdxs[partIdx];
                Object member = dateMembers[partIdx];
                if (dimIdx < 0 || !(member instanceof Calendar)) continue;
                Calendar date = (Calendar)member;
                if (partIdx == 4) {
                    calendar.set(5, date.get(5));
                    if (!this._continuous[4]) continue;
                    calendar.set(2, date.get(2));
                    calendar.set(1, date.get(1));
                    continue;
                }
                if (partIdx == 3) {
                    calendar.set(2, date.get(2));
                    if (!this._continuous[3]) continue;
                    calendar.set(1, date.get(1));
                    continue;
                }
                if (partIdx == 2) {
                    calendar.set(2, date.get(2));
                    if (!this._continuous[2]) continue;
                    calendar.set(1, date.get(1));
                    continue;
                }
                if (partIdx != 1) continue;
                calendar.set(1, date.get(1));
            }
            boolean isEarlierThanMinDate = calendar.before(RunningSum.this._minDate);
            return isEarlierThanMinDate;
        }
    }

    private static class MemberExistChecker {
        private Cuboid _cuboid;

        private MemberExistChecker() {
        }

        public void bind(Cuboid cuboid) {
            this._cuboid = cuboid;
        }

        public boolean isExist(CompositeKey dimKey) {
            return this._cuboid.getNullableCellAggregators(dimKey) != null;
        }
    }

    private static class HungryLine {
        private RunningSum _expr;
        private BigDecimal _thisLineValue;
        private Aggregator.Agg _thisLineAggr;

        public HungryLine(RunningSum expr, BigDecimal thisLineValue, Aggregator.Agg thisLineAggr) {
            this._expr = expr;
            this._thisLineValue = thisLineValue;
            this._thisLineAggr = thisLineAggr;
        }

        public BigDecimal feed(BigDecimal runningSum) {
            if (runningSum == null) {
                runningSum = this._thisLineValue;
            } else if (this._thisLineValue != null) {
                runningSum = runningSum.add(this._thisLineValue);
            }
            this._thisLineAggr.setInterimValue((IExpr)this._expr, runningSum);
            return runningSum;
        }
    }
}

