/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.engine.runner.longer;

import com.kingdee.bos.qing.common.i18n.II18nContext;
import com.kingdee.bos.qing.core.charttype.longer.AbstractChartTypeCoupler;
import com.kingdee.bos.qing.core.charttype.longer.ChartTypeComposerFactory;
import com.kingdee.bos.qing.core.engine.AbstractEngine;
import com.kingdee.bos.qing.core.engine.DataSourceTraversal;
import com.kingdee.bos.qing.core.engine.EngineOfLonger;
import com.kingdee.bos.qing.core.engine.runner.longer.Helper;
import com.kingdee.bos.qing.core.exception.AnalysisException;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.core.model.analysis.common.filter.AbstractAnalyticalFilter;
import com.kingdee.bos.qing.core.model.analysis.longer.AnalyticalModel;
import com.kingdee.bos.qing.core.model.analysis.longer.FilterFieldSet;
import com.kingdee.bos.qing.core.model.analysis.longer.ModelAssistantStructure;
import com.kingdee.bos.qing.datasource.spec.IDataSourceVisitor;
import com.kingdee.bos.qing.monitor.ICorrespondent;
import java.util.ArrayList;
import java.util.List;

abstract class AbstractEngineRunner {
    private II18nContext _ctx;
    private IDataSourceVisitor _dataSourceVisitor;
    private AnalyticalModel _model;
    private ModelAssistantStructure _modelAssistantStructure;

    public AbstractEngineRunner(IDataSourceVisitor dataSourceVisitor) {
        this._dataSourceVisitor = dataSourceVisitor;
    }

    public final void setContext(II18nContext ctx) {
        this._ctx = ctx;
    }

    protected final II18nContext getContext() {
        return this._ctx;
    }

    protected final IDataSourceVisitor getDataSourceVisitor() {
        return this._dataSourceVisitor;
    }

    protected void setModel(AnalyticalModel model) {
        this._model = model;
        FilterFieldSet filterFieldSet = this._model.getFilterFieldSet();
        if (filterFieldSet != null) {
            for (AbstractAnalyticalFilter filter : filterFieldSet.getFilters()) {
                filter.parseForBeforeRun();
            }
        }
        AbstractChartTypeCoupler ctc = ChartTypeComposerFactory.getInstance(this.getModel().getChartType());
        this._modelAssistantStructure = ctc.parseAssistantStructure(this._model);
    }

    protected final AnalyticalModel getModel() {
        return this._model;
    }

    public ModelAssistantStructure getModelAssistantStructure() {
        return this._modelAssistantStructure;
    }

    public AbstractEngine run(ICorrespondent correspondent) throws AnalysisException {
        this.beforeRun();
        ArrayList<AnalyticalField> dimensionFields = new ArrayList<AnalyticalField>();
        Helper.mergeDimensions(dimensionFields, this._modelAssistantStructure.getRowDimensionFields());
        Helper.mergeDimensions(dimensionFields, this._modelAssistantStructure.getColumnDimensionFields());
        Helper.mergeDimensions(dimensionFields, this._modelAssistantStructure.getCellDimensionFields());
        List<AnalyticalField> measureFields = this._modelAssistantStructure.getMeasureFields();
        this.applyFilterFieldToMeasure(measureFields);
        this.initFilter(dimensionFields, measureFields);
        AbstractEngine engine = this.createEngine();
        engine.setCorrespondent(correspondent);
        engine.setDimensionFields(dimensionFields);
        engine.setMeasureFields(measureFields);
        engine.setDataSourceTraversal(this.createDataSourceTraversal());
        this.initFilterPreparedValueGainer(engine);
        engine.work();
        return engine;
    }

    protected AbstractEngine createEngine() {
        EngineOfLonger engine = new EngineOfLonger();
        engine.setI18nContext(this.getContext());
        engine.setAnalyticalModel(this.getModel());
        engine.setModelAssistantStructure(this._modelAssistantStructure);
        return engine;
    }

    protected DataSourceTraversal createDataSourceTraversal() {
        return new DataSourceTraversal(this.getDataSourceVisitor());
    }

    protected void beforeRun() throws AnalysisException {
    }

    protected abstract void initFilter(List<AnalyticalField> var1, List<AnalyticalField> var2) throws AnalysisException;

    protected abstract void initFilterPreparedValueGainer(AbstractEngine var1) throws AnalysisException;

    private void applyFilterFieldToMeasure(List<AnalyticalField> measureFields) {
        FilterFieldSet filterSet = this.getModel().getFilterFieldSet();
        if (filterSet != null) {
            Helper.mergeMeasures(measureFields, filterSet.getFields());
        }
    }
}

