/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.flattening.square;

import com.kingdee.bos.qing.common.grammar.AbstractExecuteContext;
import com.kingdee.bos.qing.common.grammar.IExecuteContext;
import com.kingdee.bos.qing.common.grammar.exception.ExecuteException;
import com.kingdee.bos.qing.common.grammar.expr.AbstractFunctionExpr;
import com.kingdee.bos.qing.common.grammar.expr.AbstractOpExpr;
import com.kingdee.bos.qing.common.grammar.expr.IExpr;
import com.kingdee.bos.qing.common.grammar.expr.VariantExpr;
import com.kingdee.bos.qing.core.engine.Aggregator;
import com.kingdee.bos.qing.core.engine.CompositeKey;
import com.kingdee.bos.qing.core.engine.Cuboid;
import com.kingdee.bos.qing.core.exception.AnalysisException;
import com.kingdee.bos.qing.core.flattening.common.Scope;
import com.kingdee.bos.qing.core.flattening.common.sort.AbstractSortProcessor;
import com.kingdee.bos.qing.core.flattening.square.AbstractSquareViewMaker;
import com.kingdee.bos.qing.core.flattening.square.refline.AbstractReflineCalculator;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.core.model.analysis.common.Refline;
import com.kingdee.bos.qing.core.model.analysis.square.FieldSet;
import com.kingdee.bos.qing.core.model.analysis.square.SquareModel;
import com.kingdee.bos.qing.core.model.analysis.square.chart.property.sub.Sort;
import com.kingdee.bos.qing.core.model.exhibition.common.chart.AbstractChartModel;
import com.kingdee.bos.qing.core.model.exhibition.common.chart.AbstractNormalChartModel;
import com.kingdee.bos.qing.core.model.exhibition.common.chart.MultiSeriesChartModel;
import com.kingdee.bos.qing.util.LogUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

abstract class AbstractSimilarColumnMaker
extends AbstractSquareViewMaker {
    private int _cAxisDimCount;
    private int _seriesDimCount;
    private int _pAxisMeasureCount;
    private int _measureIndexOffset = 0;
    private Map<Object, AbstractNormalChartModel.Category> _categoryMap = new HashMap<Object, AbstractNormalChartModel.Category>();
    private Map<Object, AbstractNormalChartModel.Series> _seriesMap = new HashMap<Object, AbstractNormalChartModel.Series>();
    private List<AbstractReflineCalculator> _reflineCalculators;
    private AbstractSortProcessor.CuboidShell _sortedInsteadCuboid;

    AbstractSimilarColumnMaker() {
    }

    protected abstract FieldSet getCategoryAxis();

    protected abstract FieldSet getPrimaryAxis();

    protected abstract FieldSet getSeriesFieldSet();

    protected abstract List<Refline> getReflines();

    protected abstract AbstractSortProcessor createSortProcessor();

    private Cuboid getMyCuboid() {
        return this._sortedInsteadCuboid == null ? super.getCuboid() : this._sortedInsteadCuboid;
    }

    public void setCuboidMeasureIndexOffset(int offset) {
        this._measureIndexOffset = offset;
    }

    private int getCuboidMeasureIndex(int idx) {
        return idx + this._measureIndexOffset;
    }

    @Override
    protected AbstractChartModel makeChart() throws AnalysisException {
        this.parseDesignModel();
        MultiSeriesChartModel chart = new MultiSeriesChartModel();
        if (this.getMyCuboid().getCellCount() == 0) {
            this.makeChartWhenDataEmpty(chart);
        } else if (this._pAxisMeasureCount > 0) {
            AbstractSortProcessor sortProcessor = this.createSortProcessor();
            if (sortProcessor != null && this._cAxisDimCount > 0) {
                this._sortedInsteadCuboid = AbstractSortProcessor.CuboidShell.copyShellFrom(this.getCuboid());
                sortProcessor.sortAndTopN(this.getCuboid(), this._sortedInsteadCuboid);
            }
            this.scanDimension(chart);
            this.scanMeasure(chart);
            if (this._reflineCalculators != null) {
                List<AbstractNormalChartModel.PaintableLine> pls = chart.createOneAxisPaintableLines();
                for (AbstractReflineCalculator calculator : this._reflineCalculators) {
                    pls.add(calculator.getResult(this.getI18nContext()));
                }
            }
            ArrayList<IExpr> targetExprs = new ArrayList<IExpr>();
            AbstractSimilarColumnMaker.divideStyleScripts(this.getModel(), targetExprs);
            this.executeStyleScripts(chart, targetExprs);
        }
        return chart;
    }

    protected void makeChartWhenDataEmpty(MultiSeriesChartModel chart) {
        AbstractNormalChartModel.Node node = this.createNode(BigDecimal.ZERO, null);
        node.setText("");
        AbstractNormalChartModel.Series series = new AbstractNormalChartModel.Series();
        series.setName(this._pAxisMeasureCount > 0 ? this.getMeasureTitle(this.getPrimaryAxis().getField(0)) : "");
        series.getCategoryFitnessNodeList(1).set(0, node);
        chart.addCategory(new AbstractNormalChartModel.Category());
        chart.setSeries(new ArrayList<AbstractNormalChartModel.Series>());
        chart.getSeries().add(series);
        AbstractScopeCollector collector = this.createScopeCollector(1);
        collector.collect(0, 0, BigDecimal.ONE);
        collector.done(chart);
    }

    private void parseDesignModel() {
        this._cAxisDimCount = this.getCategoryAxis().getFieldCount();
        this._seriesDimCount = this.getSeriesFieldSet().getFieldCount();
        this._pAxisMeasureCount = this.getPrimaryAxis().getFieldCount();
        List<Refline> reflines = this.getReflines();
        if (reflines != null) {
            for (Refline refline : reflines) {
                int measureIndex = refline.getMeasureIndex();
                if (measureIndex < 0 || measureIndex >= this._pAxisMeasureCount) continue;
                AbstractReflineCalculator calculator = AbstractReflineCalculator.create(refline);
                AnalyticalField measureField = this.getPrimaryAxis().getField(measureIndex);
                calculator.setMeasureField(measureField);
                if (this._reflineCalculators == null) {
                    this._reflineCalculators = new ArrayList<AbstractReflineCalculator>();
                }
                this._reflineCalculators.add(calculator);
            }
        }
    }

    protected final void sortSeriesAndConfirmColor(MultiSeriesChartModel chart) {
        if (chart.getSeries() == null) {
            return;
        }
        chart.sortSeries(this.getI18nContext().getLanManager().getLocale());
        for (AbstractNormalChartModel.Series series : chart.getSeries()) {
            series.setColor(this.makeDiscreteColorValue(series, series.getSeriesFieldText(), false));
        }
    }

    final Map<Object, AbstractNormalChartModel.Series> getSeriesMap() {
        return this._seriesMap;
    }

    final boolean isCategoryJoined(Object member) {
        return this._categoryMap.containsKey(member);
    }

    final void joinCategory(Object member, AbstractNormalChartModel.Category category) {
        this._categoryMap.put(member, category);
    }

    final AbstractNormalChartModel.Category searchCategory(Object member) {
        return this._categoryMap.get(member);
    }

    protected AbstractNormalChartModel.Category createCategory(Object member, AnalyticalField categoryField) {
        AbstractNormalChartModel.Category category = new AbstractNormalChartModel.Category();
        String text = this.formatValue(member, categoryField);
        String value = AbstractSimilarColumnMaker.encodeCategoryValue(member, text);
        category.setLabel(text);
        category.setValue(value);
        category.setOrderingValue(member);
        return category;
    }

    protected void fixCategory(MultiSeriesChartModel chart) {
    }

    private void scanDimension(MultiSeriesChartModel chart) throws AnalysisException {
        Cuboid cuboid = this.getMyCuboid();
        if (this._cAxisDimCount == 0) {
            AbstractNormalChartModel.Category category = new AbstractNormalChartModel.Category();
            this._categoryMap.put(null, category);
            chart.addCategory(category);
        } else {
            AnalyticalField categoryField = this.getCategoryAxis().getField(0);
            String categoryFieldTitle = categoryField.getTitle(this.getI18nContext());
            chart.setCategoryTitle(categoryFieldTitle);
        }
        AnalyticalField onlyOneMeasureField = null;
        if (this._seriesDimCount == 0) {
            for (int i = 0; i < this._pAxisMeasureCount; ++i) {
                AnalyticalField measureField = this.getPrimaryAxis().getField(i);
                String measureTitle = this.getMeasureTitle(measureField);
                AbstractNormalChartModel.Series series = chart.addSeries(measureTitle);
                series.setOrderingValue(this.getCuboidMeasureIndex(i));
                series.setFormatString(measureField.getUsableNumberFormat());
                series.setColor(this.makeDiscreteColorValue(series, measureTitle, true));
            }
        } else {
            if (this._pAxisMeasureCount == 1) {
                onlyOneMeasureField = this.getPrimaryAxis().getField(0);
            }
            AnalyticalField seriesField = this.getSeriesFieldSet().getField(0);
            String seriesFieldTitle = seriesField.getTitle(this.getI18nContext());
            chart.setSeriesFieldTitle(seriesFieldTitle);
        }
        boolean isDynamicSeries = this._seriesDimCount > 0 && onlyOneMeasureField != null;
        HashSet<Object> existCategoryMembers = new HashSet<Object>();
        Iterator<CompositeKey> itKeys = cuboid.createDimensionKeyIterator();
        while (itKeys.hasNext()) {
            AbstractNormalChartModel.Series series;
            Object member;
            this.checkUserStop();
            CompositeKey dimKey = itKeys.next();
            int dimIdx = 0;
            if (this._cAxisDimCount > 0) {
                member = dimKey.getMember(dimIdx);
                AbstractNormalChartModel.Category category = this._categoryMap.get(member);
                if (category == null) {
                    AnalyticalField categoryField = cuboid.getDimensionField(dimIdx);
                    category = this.createCategory(member, categoryField);
                    this.makePcdCategoryAsParent(member, categoryField, category);
                    this._categoryMap.put(member, category);
                }
                if (existCategoryMembers.add(member)) {
                    chart.addCategory(category);
                }
            }
            if (!isDynamicSeries || (series = this._seriesMap.get(member = dimKey.getMember(dimIdx += this._cAxisDimCount))) != null) continue;
            String text = this.formatValue(member, cuboid.getDimensionField(dimIdx));
            series = chart.addSeries(this.getMeasureTitle(onlyOneMeasureField));
            series.setOrderingValue(member);
            series.setSeriesFieldValueText(AbstractSimilarColumnMaker.encodeCategoryValue(member, text), text);
            series.setFormatString(onlyOneMeasureField.getUsableNumberFormat());
            this._seriesMap.put(member, series);
        }
        if (isDynamicSeries) {
            this.sortSeriesAndConfirmColor(chart);
        }
        this.fixCategory(chart);
        chart.sortCategories(this.getI18nContext().getLanManager().getLocale());
    }

    private void scanMeasure(MultiSeriesChartModel chart) {
        int categoryCount = chart.getCategories().size();
        HashMap<Object, Integer> categoryIndexMap = new HashMap<Object, Integer>();
        AbstractScopeCollector scopeCollector = this.createScopeCollector(categoryCount);
        Cuboid cuboid = this.getMyCuboid();
        Iterator<CompositeKey> itKeys = cuboid.createDimensionKeyIterator();
        while (itKeys.hasNext()) {
            Object member;
            CompositeKey dimKey = itKeys.next();
            int categoryIdx = 0;
            int dimIdx = 0;
            if (this._cAxisDimCount > 0) {
                member = dimKey.getMember(dimIdx);
                if (categoryIndexMap.containsKey(member)) {
                    categoryIdx = (Integer)categoryIndexMap.get(member);
                } else {
                    AbstractNormalChartModel.Category category = this._categoryMap.get(member);
                    categoryIdx = chart.getCategories().indexOf(category);
                    categoryIndexMap.put(member, categoryIdx);
                }
            }
            dimIdx += this._cAxisDimCount;
            if (this._seriesDimCount > 0) {
                member = dimKey.getMember(dimIdx);
                AbstractNormalChartModel.Series series = this._seriesMap.get(member);
                List<AbstractNormalChartModel.INode> nodes = series.getCategoryFitnessNodeList(categoryCount);
                if (this._pAxisMeasureCount <= 0) continue;
                int cuboidMeasureIdx = this.getCuboidMeasureIndex(0);
                Aggregator[] aggs = cuboid.getCellAggregators(dimKey);
                Aggregator agg = aggs[cuboidMeasureIdx];
                BigDecimal measureValue = agg.getNumberValue();
                AbstractNormalChartModel.Node node = this.createNode(measureValue, cuboid.getMeasureField(cuboidMeasureIdx));
                nodes.set(categoryIdx, node);
                scopeCollector.collect(0, categoryIdx, measureValue);
                continue;
            }
            Aggregator[] aggs = cuboid.getCellAggregators(dimKey);
            for (int i = 0; i < this._pAxisMeasureCount; ++i) {
                int cuboidMeasureIdx = this.getCuboidMeasureIndex(i);
                Aggregator agg = aggs[cuboidMeasureIdx];
                BigDecimal measureValue = agg.getNumberValue();
                AbstractNormalChartModel.Node node = this.createNode(measureValue, cuboid.getMeasureField(cuboidMeasureIdx));
                List<AbstractNormalChartModel.INode> nodes = chart.getSeries(i).getCategoryFitnessNodeList(categoryCount);
                nodes.set(categoryIdx, node);
                scopeCollector.collect(i, categoryIdx, measureValue);
            }
        }
        scopeCollector.done(chart);
    }

    protected abstract AbstractScopeCollector createScopeCollector(int var1);

    static void divideStyleScripts(SquareModel squareModel, List<IExpr> collector) {
        List<IExpr> exprs = squareModel.getChartModel().getChartProperty().getStyleExprs();
        if (exprs == null) {
            return;
        }
        block0: for (int i = 0; i < exprs.size(); ++i) {
            IExpr expr = exprs.get(i);
            LinkedList<IExpr> queue = new LinkedList<IExpr>();
            queue.add(expr);
            while (!queue.isEmpty()) {
                String functionName;
                IExpr one = (IExpr)queue.remove(0);
                if (one instanceof AbstractFunctionExpr && ("addGuideline".equalsIgnoreCase(functionName = ((AbstractFunctionExpr)one).getName()) || "setColor".equalsIgnoreCase(functionName))) {
                    collector.add(expr);
                    continue block0;
                }
                if (!(one instanceof AbstractOpExpr)) continue;
                IExpr[] subs = ((AbstractOpExpr)one).getSubExprs();
                for (int k = 0; k < subs.length; ++k) {
                    queue.add(subs[k]);
                }
            }
        }
    }

    private void executeStyleScripts(MultiSeriesChartModel chart, List<IExpr> targetExprs) {
        if (targetExprs == null || targetExprs.size() == 0) {
            return;
        }
        boolean isCategoryContinuous = this._cAxisDimCount > 0 ? this.getCategoryAxis().getField(0).isContinuous() : false;
        ScriptExecuteContext ctx = new ScriptExecuteContext();
        ctx.setI18nContext(this.getI18nContext());
        ctx.setCategoryContinuous(isCategoryContinuous);
        ctx.setChart(chart);
        for (int i = 0; i < targetExprs.size(); ++i) {
            IExpr expr = targetExprs.get(i);
            this.runExpr(expr, ctx);
        }
    }

    private void runExpr(IExpr expr, ScriptExecuteContext ctx) {
        try {
            expr.execute((IExecuteContext)ctx);
        }
        catch (ExecuteException ex) {
            LogUtil.debug((String)"Execute style-script error.", (Throwable)ex);
        }
    }

    protected final AbstractColumnSortProcessor createSortProcessorImpl(Sort sort) {
        AbstractColumnSortProcessor sortProcessor;
        boolean isAccordingDefault;
        Sort.SortAccording according = sort.getSortAccording();
        boolean bl = isAccordingDefault = according == null;
        if (isAccordingDefault) {
            boolean isMultiSeriesByMeasure;
            boolean isMultiSeriesByDimension = this._seriesDimCount > 0;
            boolean bl2 = isMultiSeriesByMeasure = !isMultiSeriesByDimension && this._pAxisMeasureCount > 1;
            sortProcessor = isMultiSeriesByMeasure ? new AddibleSortProcessor() : new AppointedMeasureSortProcessor(0);
        } else {
            int measureIndex = according.getRuntimeMeasureIndex();
            if (according.getMeasureIndex() != null && measureIndex >= this._pAxisMeasureCount) {
                measureIndex = 0;
            }
            sortProcessor = new AppointedMeasureSortProcessor(measureIndex);
        }
        sortProcessor.setAscendent(sort.isAscendent());
        sortProcessor.setTopN(sort.getTopN());
        sortProcessor.setOthersAsAnItem(sort.isOthersAsAnItem());
        return sortProcessor;
    }

    static class ScriptExecuteContext
    extends AbstractExecuteContext {
        private boolean _isCategoryContinuous;
        private MultiSeriesChartModel _chart;
        private int _runningCategoryIndex;
        private int _runningSeriesIndex;

        ScriptExecuteContext() {
        }

        public void setChart(MultiSeriesChartModel chart) {
            this._chart = chart;
        }

        public void setCategoryContinuous(boolean isCategoryContinuous) {
            this._isCategoryContinuous = isCategoryContinuous;
        }

        public Object getValue(IExpr expr) throws ExecuteException {
            if (expr instanceof VariantExpr) {
                String name = ((VariantExpr)expr).getName();
                if ("CATEGORY".equalsIgnoreCase(name)) {
                    AbstractNormalChartModel.Category category = this._chart.getCategories().get(this._runningCategoryIndex);
                    return this._isCategoryContinuous ? category.getOrderingValue() : category.getLabel();
                }
                if ("MEASURE".equalsIgnoreCase(name)) {
                    return this.getMeasureAtSeries(this._runningSeriesIndex, BigDecimal.ZERO);
                }
                if ("SERIES_INDEX".equalsIgnoreCase(name)) {
                    return BigDecimal.valueOf(this._runningSeriesIndex);
                }
            } else if (expr instanceof AbstractFunctionExpr) {
                AbstractFunctionExpr func = (AbstractFunctionExpr)expr;
                String name = func.getName();
                if ("addGuideline".equalsIgnoreCase(name)) {
                    return this.addGuideline(func);
                }
                if ("getMeasure".equalsIgnoreCase(name)) {
                    return this.getMeasure(func);
                }
                if ("setColor".equalsIgnoreCase(name)) {
                    return this.setColor(func);
                }
            }
            return null;
        }

        private BigDecimal getMeasureAtSeries(int seriesIdx, BigDecimal insteadOfNull) {
            List<AbstractNormalChartModel.Series> seriesList = this._chart.getSeries();
            if (seriesIdx >= 0 && seriesIdx < seriesList.size()) {
                AbstractNormalChartModel.Series series = seriesList.get(seriesIdx);
                AbstractNormalChartModel.Node node = (AbstractNormalChartModel.Node)series.getNodes().get(this._runningCategoryIndex);
                return node == null ? insteadOfNull : node.getOrigin();
            }
            return null;
        }

        private BigDecimal getMeasure(AbstractFunctionExpr func) throws ExecuteException {
            IExpr[] params = func.getParams();
            IExpr param1 = params[0];
            BigDecimal index = (BigDecimal)param1.execute((IExecuteContext)this);
            if (index != null) {
                int idx = index.intValue();
                IExpr param2 = params.length > 1 ? params[1] : null;
                BigDecimal insteadOfNull = param2 == null ? BigDecimal.ZERO : (BigDecimal)param2.execute((IExecuteContext)this);
                return this.getMeasureAtSeries(idx, insteadOfNull);
            }
            return null;
        }

        private Boolean addGuideline(AbstractFunctionExpr func) throws ExecuteException {
            IExpr conditionExpr = func.getParams()[0];
            int c = this._chart.getCategories().size();
            for (int i = 0; i < c; ++i) {
                this._runningCategoryIndex = i;
                this._runningSeriesIndex = 0;
                Boolean condition = (Boolean)conditionExpr.execute((IExecuteContext)this);
                if (condition == null || !condition.booleanValue()) continue;
                AbstractNormalChartModel.Guideline gl = new AbstractNormalChartModel.Guideline();
                gl.setCategoryIndex(this._runningCategoryIndex);
                List<AbstractNormalChartModel.Guideline> gls = this._chart.getGuidelines();
                if (gls == null) {
                    gls = new ArrayList<AbstractNormalChartModel.Guideline>();
                    this._chart.setGuidelines(gls);
                }
                gls.add(gl);
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }

        private Boolean setColor(AbstractFunctionExpr func) throws ExecuteException {
            IExpr colorValueExpr = func.getParams()[0];
            IExpr conditionExpr = func.getParams()[1];
            Boolean got = Boolean.FALSE;
            List<AbstractNormalChartModel.Category> categoryList = this._chart.getCategories();
            List<AbstractNormalChartModel.Series> seriesList = this._chart.getSeries();
            for (int i = 0; i < categoryList.size(); ++i) {
                this._runningCategoryIndex = i;
                for (int j = 0; j < seriesList.size(); ++j) {
                    this._runningSeriesIndex = j;
                    Boolean condition = (Boolean)conditionExpr.execute((IExecuteContext)this);
                    if (condition == null || !condition.booleanValue()) continue;
                    got = Boolean.TRUE;
                    String color = (String)colorValueExpr.execute((IExecuteContext)this);
                    AbstractNormalChartModel.Series series = seriesList.get(j);
                    AbstractNormalChartModel.Node node = (AbstractNormalChartModel.Node)series.getNodes().get(i);
                    if (node == null) continue;
                    node.setColor(color);
                }
            }
            return got;
        }
    }

    private class AppointedMeasureSortProcessor
    extends AbstractColumnSortProcessor {
        private int _logicCuboidMeasureIndex;

        public AppointedMeasureSortProcessor(int cuboidMeasureIndex) {
            this._logicCuboidMeasureIndex = cuboidMeasureIndex;
        }

        @Override
        protected final BigDecimal confirmAccordingValue(Aggregator[] aggregators) {
            int idx = AbstractSimilarColumnMaker.this.getCuboidMeasureIndex(this._logicCuboidMeasureIndex);
            Aggregator aggregator = aggregators[idx];
            return aggregator.getNumberValue();
        }
    }

    private class AddibleSortProcessor
    extends AbstractColumnSortProcessor {
        private AddibleSortProcessor() {
        }

        @Override
        protected final BigDecimal confirmAccordingValue(Aggregator[] aggregators) {
            BigDecimal accordingValue = null;
            for (int i = 0; i < AbstractSimilarColumnMaker.this._pAxisMeasureCount; ++i) {
                Aggregator aggregator = aggregators[AbstractSimilarColumnMaker.this.getCuboidMeasureIndex(i)];
                BigDecimal partOfAccordingValue = aggregator.getNumberValue();
                if (accordingValue == null) {
                    accordingValue = partOfAccordingValue;
                    continue;
                }
                if (partOfAccordingValue == null) continue;
                accordingValue = accordingValue.add(partOfAccordingValue);
            }
            return accordingValue;
        }
    }

    protected abstract class AbstractColumnSortProcessor
    extends AbstractSortProcessor {
        private int _indexOfCategory = 0;

        protected AbstractColumnSortProcessor() {
        }

        protected abstract BigDecimal confirmAccordingValue(Aggregator[] var1);

        @Override
        protected final List<AbstractSortProcessor.SortableItem> preSort(Cuboid cuboid, AbstractSortProcessor.ICuboidShell insteadCuboid) {
            ArrayList<AbstractSortProcessor.SortableItem> list = new ArrayList<AbstractSortProcessor.SortableItem>();
            HashMap<Object, AbstractSortProcessor.SortableItem> map = new HashMap<Object, AbstractSortProcessor.SortableItem>();
            Iterator<CompositeKey> itDimKey = cuboid.createDimensionKeyIterator();
            while (itDimKey.hasNext()) {
                CompositeKey dimKey = itDimKey.next();
                Aggregator[] aggregators = cuboid.getCellAggregators(dimKey);
                Object categoryValue = this.getCategoryValue(dimKey);
                AbstractSortProcessor.SortableItem item = (AbstractSortProcessor.SortableItem)map.get(categoryValue);
                if (item == null) {
                    item = new AbstractSortProcessor.SortableItem();
                    item.setCategoryValue(categoryValue);
                    item.setAscendent(this.isAscendent());
                    list.add(item);
                    map.put(categoryValue, item);
                }
                BigDecimal accordingValue = this.confirmAccordingValue(aggregators);
                item.addCuboidCell(dimKey, aggregators, accordingValue);
            }
            return list;
        }

        @Override
        protected void collectCategory(Object categoryValue, int idxForSort) throws AnalysisException {
            if (!AbstractSimilarColumnMaker.this._categoryMap.containsKey(categoryValue)) {
                AbstractNormalChartModel.Category category;
                AnalyticalField categoryField = AbstractSimilarColumnMaker.this.getCuboid().getDimensionField(this._indexOfCategory);
                if (categoryValue instanceof AbstractSortProcessor.OthersMember) {
                    category = AbstractSimilarColumnMaker.this.createCategoryForOthers((AbstractSortProcessor.OthersMember)categoryValue, categoryField);
                } else {
                    category = AbstractSimilarColumnMaker.this.createCategory(categoryValue, categoryField);
                    AbstractSimilarColumnMaker.this.makePcdCategoryAsParent(categoryValue, categoryField, category);
                }
                category.setOrderingValue(idxForSort);
                AbstractSimilarColumnMaker.this._categoryMap.put(categoryValue, category);
            }
        }

        @Override
        protected final CompositeKey replaceMemberForOthers(CompositeKey dimKey, AbstractSortProcessor.OthersMember others) {
            Object realMember = dimKey.getMember(this._indexOfCategory);
            others.addRealMember(realMember);
            CompositeKey newInstance = new CompositeKey();
            int c = dimKey.getMemberCount();
            for (int i = 0; i < c; ++i) {
                if (i == this._indexOfCategory) {
                    newInstance.addMember(others);
                    continue;
                }
                newInstance.addMember(dimKey.getMember(i));
            }
            return newInstance;
        }

        @Override
        protected void mergeMeasureForOthers(Cuboid insteadCuboid, CompositeKey insteadDimKey, Aggregator[] aggs) {
            Aggregator[] insteadAggs = insteadCuboid.getCellAggregators(insteadDimKey);
            for (int j = 0; j < aggs.length; ++j) {
                insteadAggs[j].add(aggs[j]);
            }
        }

        private Object getCategoryValue(CompositeKey dimKey) {
            return dimKey.getMember(this._indexOfCategory);
        }
    }

    protected class StackedScopeCollector
    extends AbstractScopeCollector {
        private BigDecimal[] _positiveStack;
        private BigDecimal[] _negativeStack;

        public StackedScopeCollector(int categoryCount) {
            this.setCategoryCount(categoryCount);
        }

        public void setCategoryCount(int categoryCount) {
            this._positiveStack = new BigDecimal[categoryCount];
            this._negativeStack = new BigDecimal[categoryCount];
            for (int i = 0; i < categoryCount; ++i) {
                this._positiveStack[i] = BigDecimal.ZERO;
                this._negativeStack[i] = BigDecimal.ZERO;
            }
        }

        @Override
        public void collect(int measureIndex, int categoryIndex, BigDecimal value) {
            if (value != null) {
                if (value.compareTo(BigDecimal.ZERO) > 0) {
                    this._positiveStack[categoryIndex] = this._positiveStack[categoryIndex].add(value);
                } else {
                    this._negativeStack[categoryIndex] = this._negativeStack[categoryIndex].add(value);
                }
            }
        }

        @Override
        protected boolean isNeedScale() {
            return false;
        }

        @Override
        public void done(MultiSeriesChartModel chart) {
            for (int i = 0; i < this._positiveStack.length; ++i) {
                BigDecimal positive = this._positiveStack[i];
                BigDecimal negative = this._negativeStack[i];
                this.getScope().join(positive);
                this.getScope().join(negative);
                BigDecimal added = positive.add(negative);
                this.dealRefline(added);
            }
            super.done(chart);
        }

        private void dealRefline(BigDecimal measureValue) {
            if (AbstractSimilarColumnMaker.this._reflineCalculators != null) {
                for (AbstractReflineCalculator calculator : AbstractSimilarColumnMaker.this._reflineCalculators) {
                    calculator.collect(measureValue);
                }
            }
        }
    }

    protected class MultiSeriesScopeCollector
    extends AbstractScopeCollector {
        protected MultiSeriesScopeCollector() {
        }

        @Override
        public void collect(int measureIndex, int categoryIndex, BigDecimal value) {
            this.getScope().join(value);
            this.dealRefline(measureIndex, value);
        }

        @Override
        protected boolean isNeedScale() {
            return true;
        }

        private void dealRefline(int measureIndex, BigDecimal measureValue) {
            if (AbstractSimilarColumnMaker.this._reflineCalculators != null) {
                for (AbstractReflineCalculator calculator : AbstractSimilarColumnMaker.this._reflineCalculators) {
                    if (!calculator.isOnDuty(measureIndex)) continue;
                    calculator.collect(measureValue);
                }
            }
        }
    }

    protected abstract class AbstractScopeCollector {
        private Scope _scope = new Scope();

        protected AbstractScopeCollector() {
        }

        protected Scope getScope() {
            return this._scope;
        }

        public abstract void collect(int var1, int var2, BigDecimal var3);

        protected abstract boolean isNeedScale();

        public void done(MultiSeriesChartModel chart) {
            this.reflineJoinInScope(this._scope);
            AbstractNormalChartModel.AxisValueScope axisValueScope = chart.addValueScope(this._scope.getMin().toString(), this._scope.getMax().toString());
            if (this.isNeedScale()) {
                this._scope.makeRulerScale(axisValueScope);
            }
        }

        private void reflineJoinInScope(Scope scope) {
            if (AbstractSimilarColumnMaker.this._reflineCalculators != null) {
                for (AbstractReflineCalculator calculator : AbstractSimilarColumnMaker.this._reflineCalculators) {
                    BigDecimal value = calculator.getLineValue();
                    if (value == null) continue;
                    scope.join(value);
                }
            }
        }
    }
}

