/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.flattening.square;

import com.kingdee.bos.qing.core.exception.AnalysisException;
import com.kingdee.bos.qing.core.flattening.common.sort.AbstractSortProcessor;
import com.kingdee.bos.qing.core.flattening.square.AbstractSimilarColumnMaker;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.core.model.analysis.square.FieldSet;
import com.kingdee.bos.qing.core.model.exhibition.common.chart.AbstractChartModel;
import com.kingdee.bos.qing.core.model.exhibition.common.chart.AbstractNormalChartModel;
import com.kingdee.bos.qing.core.model.exhibition.common.chart.MultiSeriesChartModel;
import com.kingdee.bos.qing.core.model.meta.DataType;
import java.util.Calendar;

abstract class AbstractSimilarLineMaker
extends AbstractSimilarColumnMaker {
    private AnalyticalField _categoryField;
    private Calendar _minCategory;
    private Calendar _maxCategory;

    AbstractSimilarLineMaker() {
    }

    @Override
    protected AbstractSortProcessor createSortProcessor() {
        return null;
    }

    @Override
    protected final AbstractChartModel makeChart() throws AnalysisException {
        FieldSet categoryAxis = this.getCategoryAxis();
        this._categoryField = categoryAxis.getFieldCount() > 0 ? categoryAxis.getField(0) : null;
        return super.makeChart();
    }

    @Override
    protected final int getCategoryMemberLimitedCount() {
        return 1024;
    }

    @Override
    protected int getSeriesMemberLimitedCount() {
        return 16;
    }

    @Override
    protected final AbstractNormalChartModel.Category createCategory(Object member, AnalyticalField categoryField) {
        if (this._categoryField != null && this._categoryField.getDataType() == DataType.DATE && member instanceof Calendar) {
            Calendar value = (Calendar)member;
            this._minCategory = this._minCategory == null || this._minCategory.compareTo(value) > 0 ? value : this._minCategory;
            this._maxCategory = this._maxCategory == null || this._maxCategory.compareTo(value) < 0 ? value : this._maxCategory;
        }
        AbstractNormalChartModel.Category category = super.createCategory(member, categoryField);
        return category;
    }

    @Override
    protected final void fixCategory(MultiSeriesChartModel chart) {
        this.makeSureDateContinuous(chart);
    }

    private void makeSureDateContinuous(MultiSeriesChartModel chart) {
        if (this._categoryField == null || this._categoryField.getDataType() != DataType.DATE || !this._categoryField.isContinuous() || this._minCategory == null) {
            return;
        }
        Calendar min = (Calendar)this._minCategory.clone();
        min.add(1, 100);
        if (min.compareTo(this._maxCategory) < 0) {
            return;
        }
        Calendar value = this._minCategory;
        while (value.compareTo(this._maxCategory) < 0) {
            value = (Calendar)value.clone();
            switch (this._categoryField.getPartValue()) {
                case DATE_YEAR: {
                    value.add(1, 1);
                    break;
                }
                case DATE_QUARTER: 
                case DATE_YQ: {
                    value.add(2, 3);
                    break;
                }
                case DATE_MONTH: 
                case DATE_YM: {
                    value.add(2, 1);
                    break;
                }
                default: {
                    value.add(5, 1);
                }
            }
            if (this.isCategoryJoined(value)) continue;
            AbstractNormalChartModel.Category category = super.createCategory(value, this._categoryField);
            chart.addCategory(category);
            this.joinCategory(value, category);
        }
    }
}

