/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.flattening.square.refline;

import com.kingdee.bos.qing.common.i18n.II18nContext;
import com.kingdee.bos.qing.core.flattening.square.refline.AbstractReflineCalculator;
import com.kingdee.bos.qing.core.i18n.Messages;
import com.kingdee.bos.qing.core.model.analysis.common.Refline;
import com.kingdee.bos.qing.core.model.exhibition.common.chart.AbstractNormalChartModel;
import java.math.BigDecimal;

class AvgCalculator
extends AbstractReflineCalculator {
    private BigDecimal _total;
    private int _count;

    public AvgCalculator(Refline model) {
        super(model);
    }

    @Override
    public void collect(BigDecimal value) {
        if (value != null) {
            this._total = this._total == null ? value : this._total.add(value);
            ++this._count;
        }
    }

    @Override
    public BigDecimal getLineValue() {
        if (this._total == null || this._count == 0) {
            return null;
        }
        int scale = Math.min(15, Math.max(8, this._total.scale()));
        BigDecimal avg = this._total.divide(new BigDecimal(this._count), scale, 4);
        return avg;
    }

    @Override
    public AbstractNormalChartModel.PaintableLine getResult(II18nContext i18nCtx) {
        AbstractNormalChartModel.PaintableLine pl = null;
        BigDecimal avg = this.getLineValue();
        if (avg != null) {
            pl = new AbstractNormalChartModel.PaintableLine();
            String tipsTitle = Messages.getLangMessage(i18nCtx, "reflineAvgTipsTitle", "#1\u7684\u5e73\u5747\u503c");
            tipsTitle = tipsTitle.replaceFirst("#1", this.getMeasreTitle(i18nCtx));
            String label = this.getDesignModel().getLabel();
            if (label == null || label.isEmpty()) {
                pl.setLabel(null);
            } else {
                pl.setLabel(label);
            }
            pl.setLineValue(avg.toString());
            pl.setTipsTitle(tipsTitle);
            pl.setTipsText(this.format(avg));
        }
        return pl;
    }
}

