/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.model.analysis;

import com.kingdee.bos.qing.core.exception.PersistentModelParseException;
import com.kingdee.bos.qing.core.exception.PersistentModelTooModernException;
import com.kingdee.bos.qing.core.model.analysis.AbstractQingModel;
import com.kingdee.bos.qing.core.model.analysis.IPreferences;
import com.kingdee.bos.qing.core.model.analysis.IQingModel;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.core.model.analysis.common.OutsideReference;
import com.kingdee.bos.qing.core.model.analysis.common.PartValue;
import com.kingdee.bos.qing.core.model.analysis.common.filter.DiscreteFilter;
import com.kingdee.bos.qing.core.model.analysis.longer.AbstractFieldSet;
import com.kingdee.bos.qing.core.model.analysis.longer.AnalyticalModel;
import com.kingdee.bos.qing.core.model.analysis.longer.FilterFieldSet;
import com.kingdee.bos.qing.core.model.analysis.longer.preferences.AnalyticalPreferences;
import com.kingdee.bos.qing.core.model.analysis.square.SquareModel;
import com.kingdee.bos.qing.core.model.analysis.square.chart.property.DialChartProperty;
import com.kingdee.bos.qing.core.model.analysis.square.preferences.SquarePreperences;
import com.kingdee.bos.qing.core.model.meta.DataType;
import com.kingdee.bos.qing.core.model.meta.Meta;
import com.kingdee.bos.qing.core.model.meta.MetaField;
import com.kingdee.bos.qing.util.XmlUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom2.Content;
import org.jdom2.Element;

public class ModelBook {
    private static final String VERSION = "20221215";
    private Meta meta;
    private List<ModelPage> pages;
    private Boolean isTooModern;

    public void fixReferences(List<OutsideReference> refItems) {
        for (ModelPage page : this.pages) {
            page.getModel().fixReferences(refItems);
        }
    }

    public List<OutsideReference> pickReferences() {
        ArrayList<OutsideReference> allRefItems = new ArrayList<OutsideReference>();
        for (ModelPage page : this.pages) {
            List<OutsideReference> refItems = page.getModel().pickReferences();
            if (refItems == null) continue;
            allRefItems.addAll(refItems);
        }
        return allRefItems;
    }

    public Meta getMeta() {
        return this.meta;
    }

    public void setMeta(Meta meta) {
        this.meta = meta;
    }

    public List<ModelPage> getPages() {
        return this.pages;
    }

    public void setPages(List<ModelPage> pages) {
        this.pages = pages;
    }

    public Set<String> lookupUsedMetaFields() {
        this.meta.fixMetaFieldOwner();
        this.meta.fixExprAndDependents();
        HashSet<String> all = new HashSet<String>();
        for (ModelPage page : this.pages) {
            IQingModel model = page.getModel();
            model.bindMeta(this.meta);
            all.addAll(model.lookupUsedMetaFields());
        }
        return all;
    }

    public Element toXml() {
        Element root = new Element("Qing");
        root.setAttribute("version", VERSION);
        this.meta.writeXmlToParent(root);
        for (ModelPage page : this.pages) {
            Element nodePage = new Element("Page");
            page.toXml(nodePage);
            root.addContent((Content)nodePage);
        }
        return root;
    }

    public void fromXml(Element root) throws PersistentModelParseException, PersistentModelTooModernException {
        int modelVersion = this.checkVersion(root);
        try {
            this.meta = new Meta();
            this.meta.readXmlFromParent(root);
            List pageNodes = XmlUtil.getChildren((Element)root, (String)"Page");
            this.pages = new ArrayList<ModelPage>(pageNodes.size());
            for (Element nodePage : pageNodes) {
                ModelPage page = new ModelPage();
                page.fromXml(nodePage);
                this.pages.add(page);
            }
        }
        catch (PersistentModelParseException ex) {
            if (this.isTooModern == Boolean.TRUE) {
                throw new PersistentModelTooModernException(VERSION, Integer.toString(modelVersion));
            }
            throw ex;
        }
        this.upgradeModel(modelVersion);
    }

    private int checkVersion(Element root) throws PersistentModelParseException {
        int modelVersion;
        String version;
        try {
            version = XmlUtil.readAttrNotNull((Element)root, (String)"version");
        }
        catch (XmlUtil.NullException e) {
            throw new PersistentModelParseException("The attribute 'version' is missing.");
        }
        int runtimeVersion = Integer.parseInt(VERSION);
        try {
            modelVersion = Integer.parseInt(version);
        }
        catch (NumberFormatException ex) {
            throw new PersistentModelParseException("Invalid version: " + version);
        }
        if (modelVersion > runtimeVersion) {
            this.isTooModern = Boolean.TRUE;
        } else {
            if (modelVersion <= 20170228) {
                this.upgradeXml20170228(root);
            }
            if (modelVersion <= 20220401) {
                this.upgradeXml20220401(root);
            }
        }
        return modelVersion;
    }

    private void upgradeXml20170228(Element root) {
        Element nodeAnalyticalModel = root.getChild("AnalyticalModel");
        Element nodePreferences = root.getChild("Preferences");
        Element nodePage = new Element("Page");
        root.removeContent((Content)nodeAnalyticalModel);
        nodePage.addContent((Content)nodeAnalyticalModel);
        if (nodePreferences != null) {
            root.removeContent((Content)nodePreferences);
            nodePage.addContent((Content)nodePreferences);
        }
        root.addContent((Content)nodePage);
    }

    private void upgradeXml20220401(Element root) {
        Element nodeChart;
        Element nodePage = root.getChild("Page");
        Element nodeSquare = nodePage.getChild("SquareModel");
        if (nodeSquare != null && "Gauge".equals((nodeChart = nodeSquare.getChild("Chart")).getAttributeValue("type"))) {
            nodeChart.setAttribute("type", "Dial");
            Element nodeProperty = nodeChart.getChild("Property");
            nodeChart.removeChild("Property");
            nodeProperty = DialChartProperty.upgradeGauge(nodeProperty);
            nodeChart.addContent((Content)nodeProperty);
        }
    }

    private void upgradeModel(int modelVersion) {
        if (modelVersion <= 20170520) {
            this.upgradeModel20170520();
        }
        if (modelVersion < 20180323) {
            this.upgradeModelTo20180323();
        }
    }

    private void upgradeModel20170520() {
        Map<String, MetaField> metaFields = this.meta.createSearchingMap();
        AnalyticalModel model = (AnalyticalModel)this.getPages().get(0).getModel();
        FilterFieldSet filterFieldSet = model.getFilterFieldSet();
        int c = filterFieldSet.getFieldCount();
        for (int i = 0; i < c; ++i) {
            AnalyticalField field = filterFieldSet.getField(i);
            String fieldName = field.getName();
            MetaField mf = metaFields.get(fieldName);
            if (mf == null || DataType.DATE != mf.getDataType() || PartValue.DATE_YEAR == field.getPartValue() || PartValue.DATE_DAY == field.getPartValue()) continue;
            DiscreteFilter filter = (DiscreteFilter)filterFieldSet.getFilters().get(i);
            filter.setSelecteds(new ArrayList<String>());
            filter.setFullValue(true);
        }
    }

    private void upgradeModelTo20180323() {
        AnalyticalModel model = (AnalyticalModel)this.getPages().get(0).getModel();
        this.upgragePartValueRelativeFormatString(model.getRow());
        this.upgragePartValueRelativeFormatString(model.getColumn());
        this.upgragePartValueRelativeFormatString(model.getMarkFieldSet());
        this.upgragePartValueRelativeFormatString(model.getFilterFieldSet());
    }

    private void upgragePartValueRelativeFormatString(AbstractFieldSet fieldSet) {
        int c = fieldSet.getFieldCount();
        block5: for (int i = 0; i < c; ++i) {
            AnalyticalField field = fieldSet.getField(i);
            PartValue partValue = field.getPartValue();
            if (partValue == null) continue;
            switch (partValue) {
                case DATE_YEAR: {
                    field.setDateFormat("yyyy");
                    continue block5;
                }
                case DATE_QUARTER: {
                    field.setDateFormat("\u7b2cq\u5b63\u5ea6");
                    continue block5;
                }
                case DATE_DAY: {
                    field.setDateFormat("d");
                    continue block5;
                }
            }
        }
    }

    public static ModelBook createFromOneModel(Meta meta, IQingModel model) {
        ModelPage modelPage = new ModelPage();
        modelPage.setModel(model);
        ArrayList<ModelPage> pages = new ArrayList<ModelPage>(1);
        pages.add(modelPage);
        ModelBook modelBook = new ModelBook();
        modelBook.setMeta(meta);
        modelBook.setPages(pages);
        return modelBook;
    }

    public static class ModelPage {
        private String type;
        private IQingModel model;
        private IPreferences preferences;
        private String name;
        private Boolean current;

        public IQingModel getModel() {
            return this.model;
        }

        public void setModel(IQingModel model) {
            this.model = model;
            if (this.model instanceof AnalyticalModel) {
                this.type = "L";
            } else if (this.model instanceof SquareModel) {
                this.type = "S";
            } else {
                throw new RuntimeException("Unknow model type.");
            }
        }

        public IPreferences getPreferences() {
            return this.preferences;
        }

        public void toXml(Element node) {
            Element nodeModel;
            XmlUtil.writeAttrWhenExist((Element)node, (String)"name", (String)this.name);
            XmlUtil.writeAttrDefaultFalse((Element)node, (String)"current", (boolean)(this.current == null ? false : this.current));
            if (this.model instanceof AnalyticalModel) {
                nodeModel = new Element("AnalyticalModel");
            } else if (this.model instanceof SquareModel) {
                nodeModel = new Element("SquareModel");
            } else {
                throw new RuntimeException("Modify here.");
            }
            this.model.toXml(nodeModel);
            node.addContent((Content)nodeModel);
            if (this.preferences != null) {
                Element nodePreferences = new Element("Preferences");
                this.preferences.toXml(nodePreferences);
                node.addContent((Content)nodePreferences);
            }
        }

        public void fromXml(Element node) throws PersistentModelParseException {
            AbstractQingModel qingModel;
            this.name = XmlUtil.readAttrWhenExist((Element)node, (String)"name");
            this.current = XmlUtil.readAttrDefaultFalse((Element)node, (String)"current") ? Boolean.TRUE : null;
            Element nodeModel = XmlUtil.getChild((Element)node, (String)"AnalyticalModel");
            if (nodeModel == null) {
                nodeModel = XmlUtil.getChild((Element)node, (String)"SquareModel");
                if (nodeModel == null) {
                    throw new PersistentModelParseException("Model node not found in page.");
                }
                qingModel = new SquareModel();
                this.preferences = new SquarePreperences();
            } else {
                qingModel = new AnalyticalModel();
                this.preferences = new AnalyticalPreferences();
            }
            qingModel.fromXml(nodeModel);
            this.setModel(qingModel);
            Element nodePreferences = XmlUtil.getChild((Element)node, (String)"Preferences");
            if (nodePreferences != null) {
                this.preferences.fromXml(nodePreferences);
            }
        }

        public static void prepareForExecuting(Meta meta, IQingModel model, IPreferences preferences) {
            meta.fixMetaFieldOwner();
            meta.fixExprAndDependents();
            model.bindMeta(meta);
            model.bindPreferences(preferences);
        }
    }
}

