/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.model.analysis.square;

import com.kingdee.bos.qing.core.exception.PersistentModelParseException;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.core.model.analysis.common.filter.AbstractAnalyticalFilter;
import com.kingdee.bos.qing.core.model.analysis.common.filter.ContinuousDateFilter;
import com.kingdee.bos.qing.core.model.analysis.common.filter.ContinuousFilter;
import com.kingdee.bos.qing.core.model.analysis.common.filter.DiscreteFilter;
import com.kingdee.bos.qing.util.XmlUtil;
import org.jdom2.Content;
import org.jdom2.Element;

public class FilterItem {
    private AnalyticalField field;
    private AbstractAnalyticalFilter filter;
    private Boolean outsideAllowed;

    public void setField(AnalyticalField field) {
        this.field = field;
    }

    public AnalyticalField getField() {
        return this.field;
    }

    public void setFilter(AbstractAnalyticalFilter filter) {
        this.filter = filter;
    }

    public AbstractAnalyticalFilter getFilter() {
        return this.filter;
    }

    public void toXml(Element node) {
        XmlUtil.writeAttrBoolWhenExist((Element)node, (String)"outsideAllowed", (Boolean)this.outsideAllowed);
        Element nodeField = new Element("Field");
        this.field.toXml(nodeField);
        node.addContent((Content)nodeField);
        Element nodeFilter = new Element("Filter");
        this.filter.toXml(nodeFilter);
        XmlUtil.writeAttrNotNull((Element)nodeFilter, (String)"name", (String)this.filter.getName());
        node.addContent((Content)nodeFilter);
    }

    public void fromXml(Element node) throws PersistentModelParseException {
        String filterName;
        Element nodeFilter;
        Element nodeField;
        this.outsideAllowed = XmlUtil.readAttrBoolWhenExist((Element)node, (String)"outsideAllowed");
        try {
            nodeField = XmlUtil.getChildNotNull((Element)node, (String)"Field");
            nodeFilter = XmlUtil.getChildNotNull((Element)node, (String)"Filter");
            filterName = XmlUtil.readAttrNotNull((Element)nodeFilter, (String)"name");
        }
        catch (XmlUtil.NullException ex) {
            throw new PersistentModelParseException(ex);
        }
        this.field = new AnalyticalField();
        this.field.fromXml(nodeField);
        if ("discrete".equals(filterName)) {
            this.filter = new DiscreteFilter();
        } else if ("continuous".equals(filterName)) {
            this.filter = new ContinuousFilter();
        } else if ("continuousDate".equals(filterName)) {
            this.filter = new ContinuousDateFilter();
        } else {
            throw new PersistentModelParseException("Unknown filter name");
        }
        this.filter.fromXml(nodeFilter);
    }

    public FilterItem copy() {
        FilterItem inst = new FilterItem();
        inst.field = this.field.copy();
        inst.filter = this.filter.copy();
        return inst;
    }
}

