/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.model.exhibition.common.chart;

import com.kingdee.bos.qing.core.engine.sort.CommonComparator;
import com.kingdee.bos.qing.core.model.exhibition.common.AbstractComparableObject;
import com.kingdee.bos.qing.core.model.exhibition.common.chart.MultiSeriesChartModel;
import com.kingdee.bos.qing.util.JsonUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public abstract class AbstractChartModel
extends AbstractComparableObject {
    protected static int searchInsertingIndex(IOrderingSupported item, List<? extends IOrderingSupported> list, Comparator<IOrderingSupported> comparator) {
        int insertionPoint = Collections.binarySearch(list, item, comparator);
        int idx = insertionPoint > -1 ? insertionPoint : -insertionPoint - 1;
        return idx;
    }

    public static List<IOrderingSupported> toOrderedWrapList(Set<?> valueCollector, Locale sortingContext) {
        DefaultComparator comparator = new DefaultComparator(sortingContext);
        ArrayList<IOrderingSupported> sortingList = new ArrayList<IOrderingSupported>();
        for (Object value : valueCollector) {
            OrderingObject item = new OrderingObject(value);
            int idx = AbstractChartModel.searchInsertingIndex(item, sortingList, comparator);
            sortingList.add(idx, item);
        }
        return sortingList;
    }

    public static <T extends IOrderingSupported> List<T> toOrderedCollection(Collection<T> valueCollector, Locale sortingContext) {
        DefaultComparator comparator = new DefaultComparator(sortingContext);
        ArrayList<IOrderingSupported> sortingList = new ArrayList<IOrderingSupported>();
        for (IOrderingSupported item : valueCollector) {
            int idx = AbstractChartModel.searchInsertingIndex(item, sortingList, comparator);
            sortingList.add(idx, item);
        }
        return sortingList;
    }

    protected static class DefaultComparator
    implements Comparator<IOrderingSupported> {
        private CommonComparator _comparer;

        public DefaultComparator(Locale locale) {
            this._comparer = new CommonComparator(locale);
        }

        @Override
        public int compare(IOrderingSupported o1, IOrderingSupported o2) {
            Comparable v1 = (Comparable)o1.getOrderingValue();
            Comparable v2 = (Comparable)o2.getOrderingValue();
            return this._comparer.compare(v1, v2);
        }
    }

    public static class OrderingObject
    implements IOrderingSupported {
        private Object _orderingVaue;

        public OrderingObject(Object orderingVaue) {
            this._orderingVaue = orderingVaue;
        }

        @Override
        public Object getOrderingValue() {
            return this._orderingVaue;
        }
    }

    public static interface IOrderingSupported {
        public Object getOrderingValue();
    }

    public static class JsonDecoder
    extends JsonUtil.AbstractJsonDecoder<AbstractChartModel> {
        protected AbstractChartModel decode(JsonUtil.AbstractJsonDecoder.Json json) {
            return (AbstractChartModel)this.fromJson(json, MultiSeriesChartModel.class);
        }
    }
}

