/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.model.exhibition.common.chart;

import com.kingdee.bos.qing.core.model.exhibition.common.AbstractComparableObject;
import com.kingdee.bos.qing.core.model.exhibition.common.chart.AbstractChartModel;
import com.kingdee.bos.qing.monitor.heapsize.OccupyByte;
import com.kingdee.bos.qing.util.JsonUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;

public abstract class AbstractNormalChartModel
extends AbstractChartModel {
    public static final int HEAPZISE_OVERHEAD = OccupyByte.align(OccupyByte.OBJECT + OccupyByte.REFERENCE * 7);
    public static final Category EmptyCategory = new Category();
    private String categoryTitle;
    private String seriesFieldTitle;
    private List<Category> categories;
    private List<Series> series;
    private List<AxisValueScope> scopes;
    private List<List<PaintableLine>> paintableLines;
    private List<Guideline> guidelines;

    public final void setCategoryTitle(String title) {
        this.categoryTitle = title;
    }

    public final String getCategoryTitle() {
        return this.categoryTitle;
    }

    public final void setSeriesFieldTitle(String fieldTitle) {
        this.seriesFieldTitle = fieldTitle;
    }

    public final String getSeriesFieldTitle() {
        return this.seriesFieldTitle;
    }

    public final void setCategories(List<Category> categories) {
        this.categories = categories;
    }

    public final List<Category> getCategories() {
        return this.categories;
    }

    public void sortCategories(Locale locale) {
        List<Category> categories = this.getCategories();
        Category[] categoryArray = categories.toArray(new Category[0]);
        AbstractChartModel.DefaultComparator comparator = new AbstractChartModel.DefaultComparator(locale);
        Arrays.sort(categoryArray, comparator);
        ListIterator<Category> it = categories.listIterator();
        for (Category each : categoryArray) {
            it.next();
            it.set(each);
        }
    }

    public final void setSeries(List<Series> series) {
        this.series = series;
    }

    public final List<Series> getSeries() {
        return this.series;
    }

    public void sortSeries(Locale locale) {
        List<Series> series = this.getSeries();
        Series[] seriesArray = series.toArray(new Series[0]);
        AbstractChartModel.DefaultComparator comparator = new AbstractChartModel.DefaultComparator(locale);
        Arrays.sort(seriesArray, comparator);
        ListIterator<Series> it = series.listIterator();
        for (Series each : seriesArray) {
            it.next();
            it.set(each);
        }
    }

    public final void setScopes(List<AxisValueScope> scopes) {
        this.scopes = scopes;
    }

    public final List<AxisValueScope> getScopes() {
        return this.scopes;
    }

    public final void setPaintableLines(List<List<PaintableLine>> paintableLines) {
        this.paintableLines = paintableLines;
    }

    public final List<List<PaintableLine>> getPaintableLines() {
        return this.paintableLines;
    }

    public final void setGuidelines(List<Guideline> guidelines) {
        this.guidelines = guidelines;
    }

    public final List<Guideline> getGuidelines() {
        return this.guidelines;
    }

    protected final void createCategoryList() {
        this.setCategories(new ArrayList<Category>());
    }

    protected final Series createOneSeries(String name) {
        if (this.series == null) {
            this.series = new ArrayList<Series>();
        }
        Series one = new Series();
        this.series.add(one);
        one.setName(name);
        one.setNodes(new ArrayList<INode>());
        return one;
    }

    @Override
    public boolean isEqualTo(Object obj) {
        if (!(obj instanceof AbstractNormalChartModel)) {
            return false;
        }
        AbstractNormalChartModel another = (AbstractNormalChartModel)obj;
        return AbstractNormalChartModel.isEqualEachOther(this.categoryTitle, another.categoryTitle) && AbstractNormalChartModel.isListEqualEachOther(this.categories, another.categories) && AbstractNormalChartModel.isListEqualEachOther(this.series, another.series) && AbstractNormalChartModel.isListEqualEachOther(this.scopes, another.scopes) && AbstractNormalChartModel.isListEqualEachOther(this.paintableLines, another.paintableLines) && AbstractNormalChartModel.isListEqualEachOther(this.guidelines, another.guidelines);
    }

    public boolean cutTooLarge(int categoryLimitedCount, int seriesLimitedCount) {
        boolean isHappened = false;
        if (this.series != null && this.series.size() > seriesLimitedCount) {
            this.series = this.series.subList(0, seriesLimitedCount);
            isHappened = true;
        }
        if (this.categories != null && this.categories.size() > categoryLimitedCount) {
            this.categories = this.categories.subList(0, categoryLimitedCount);
            if (this.series != null) {
                for (Series series : this.series) {
                    series.setNodes(series.getNodes().subList(0, categoryLimitedCount));
                }
            }
            isHappened = true;
        }
        return isHappened;
    }

    public static void toOrderedNodes(List<INode> nodes, List<Node> sortingNodes, boolean isAscendent) {
        NodeComparator comparator = new NodeComparator(isAscendent);
        for (int i = 0; i < nodes.size(); ++i) {
            Node node = (Node)nodes.get(i);
            int idx = AbstractNormalChartModel.searchInsertingIndex(node, sortingNodes, comparator);
            sortingNodes.add(idx, node);
        }
    }

    private static class NodeComparator
    extends AbstractChartModel.DefaultComparator {
        private boolean _isAscendent = true;

        public NodeComparator(boolean isAscendent) {
            super(null);
            this._isAscendent = isAscendent;
        }

        @Override
        public int compare(AbstractChartModel.IOrderingSupported o1, AbstractChartModel.IOrderingSupported o2) {
            int c = o1 == null ? (o2 == null ? 0 : -1) : (o2 == null ? 1 : super.compare(o1, o2));
            if (!this._isAscendent) {
                c = -c;
            }
            return c;
        }
    }

    protected static abstract class AbstractOrderingSupported
    extends AbstractComparableObject
    implements AbstractChartModel.IOrderingSupported {
        private transient Object orderingValue;

        protected AbstractOrderingSupported() {
        }

        public void setOrderingValue(Object value) {
            this.orderingValue = value;
        }

        @Override
        public Object getOrderingValue() {
            return this.orderingValue;
        }
    }

    public static class Guideline
    extends AbstractComparableObject {
        private int category;
        private String label;

        public void setCategoryIndex(int idx) {
            this.category = idx;
        }

        public int getCategoryIndex() {
            return this.category;
        }

        public void setLabel(String text) {
            this.label = text;
        }

        public String getLabel() {
            return this.label;
        }

        @Override
        public boolean isEqualTo(Object obj) {
            if (!(obj instanceof Guideline)) {
                return false;
            }
            Guideline another = (Guideline)obj;
            return Guideline.isEqualEachOther(this.label, another.label) && Guideline.isEqualEachOther(this.category, another.category);
        }
    }

    public static class PaintableLine
    extends AbstractComparableObject {
        private String label;
        private String line;
        private String tipsTitle;
        private String tipsText;

        public void setLabel(String text) {
            this.label = text;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLineValue(String value) {
            this.line = value;
        }

        public String getLineValue() {
            return this.line;
        }

        public void setTipsTitle(String text) {
            this.tipsTitle = text;
        }

        public String getTipsTitle() {
            return this.tipsTitle;
        }

        public void setTipsText(String text) {
            this.tipsText = text;
        }

        public String getTipsText() {
            return this.tipsText;
        }

        @Override
        public boolean isEqualTo(Object obj) {
            if (!(obj instanceof PaintableLine)) {
                return false;
            }
            PaintableLine another = (PaintableLine)obj;
            return PaintableLine.isEqualEachOther(this.label, another.label) && PaintableLine.isEqualEachOther(this.line, another.line) && PaintableLine.isEqualEachOther(this.tipsTitle, another.tipsTitle) && PaintableLine.isEqualEachOther(this.tipsText, another.tipsText);
        }
    }

    public static class AxisValueScope
    extends AbstractComparableObject {
        private String min;
        private String max;
        private String title;
        private String formatString;
        private String color;
        private Boolean suggestLog;
        private Double logMin;
        private Double logMax;
        private Integer logOffset;
        private Double cuttableForLinear;
        private Integer cuttableForLog;

        public void setMin(String value) {
            this.min = value;
        }

        public String getMin() {
            return this.min;
        }

        public void setMax(String value) {
            this.max = value;
        }

        public String getMax() {
            return this.max;
        }

        public void setTitle(String measureFieldTitle) {
            this.title = measureFieldTitle;
        }

        public String getTitle() {
            return this.title;
        }

        public void setFormatString(String formatString) {
            this.formatString = formatString;
        }

        public String getFormatString() {
            return this.formatString;
        }

        public void setColor(String color) {
            this.color = color;
        }

        public String getColor() {
            return this.color;
        }

        public void setSuggestUseLog(boolean isSuggestLog) {
            this.suggestLog = isSuggestLog ? Boolean.valueOf(true) : null;
        }

        public boolean isSuggestUseLog() {
            return this.suggestLog == null ? false : this.suggestLog;
        }

        public void setLogParam(Double logMin, Double logMax, Integer logOffset) {
            this.logMin = logMin;
            this.logMax = logMax;
            this.logOffset = logOffset;
        }

        public Double getLogMin() {
            return this.logMin;
        }

        public Double getLogMax() {
            return this.logMax;
        }

        public Integer getLogOffset() {
            return this.logOffset;
        }

        public void setCuttableForLinear(Double cuttable) {
            this.cuttableForLinear = cuttable;
        }

        public Double getCuttableLinear() {
            return this.cuttableForLinear;
        }

        public void setCuttableForLog(Integer cuttable) {
            this.cuttableForLog = cuttable;
        }

        public Integer getCuttableForLog() {
            return this.cuttableForLog;
        }

        @Override
        public boolean isEqualTo(Object obj) {
            if (!(obj instanceof AxisValueScope)) {
                return false;
            }
            AxisValueScope another = (AxisValueScope)obj;
            return AxisValueScope.isEqualEachOther(this.min, another.min) && AxisValueScope.isEqualEachOther(this.max, another.max);
        }
    }

    public static class XYNode
    extends AbstractOrderingSupported
    implements INode {
        public static final int HEAPZISE_OVERHEAD = OccupyByte.align(OccupyByte.OBJECT + OccupyByte.REFERENCE * 3);
        private String x;
        private String y;
        private String z;

        public void setXAxisValue(String x) {
            this.x = x;
        }

        public String getXAxisValue() {
            return this.x;
        }

        public void setYAxisValue(String y) {
            this.y = y;
        }

        public String getYAxisValue() {
            return this.y;
        }

        public void setZAxisValue(String z) {
            this.z = z;
        }

        public String getZAxisValue() {
            return this.z;
        }

        @Override
        public boolean isEqualTo(Object obj) {
            if (!(obj instanceof XYNode)) {
                return false;
            }
            XYNode another = (XYNode)obj;
            return XYNode.isEqualEachOther(this.x, another.x) && XYNode.isEqualEachOther(this.y, another.y) && XYNode.isEqualEachOther(this.z, another.z);
        }
    }

    public static class Node
    extends AbstractOrderingSupported
    implements INode {
        public static final int HEAPZISE_OVERHEAD = OccupyByte.align(OccupyByte.OBJECT + OccupyByte.REFERENCE * 2);
        private String value;
        private String text;
        private String color;

        public void setValue(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public void setText(String text) {
            this.text = text;
        }

        public String getText() {
            return this.text;
        }

        public void setColor(String color) {
            this.color = color;
        }

        public String getColor() {
            return this.color;
        }

        public void setOrigin(BigDecimal value) {
            super.setOrderingValue(value);
        }

        public BigDecimal getOrigin() {
            return (BigDecimal)super.getOrderingValue();
        }

        @Override
        public boolean isEqualTo(Object obj) {
            if (!(obj instanceof Node)) {
                return false;
            }
            Node another = (Node)obj;
            return Node.isEqualEachOther(this.value, another.value) && Node.isEqualEachOther(this.text, another.text) && Node.isEqualEachOther(this.color, another.color);
        }
    }

    public static interface INode {

        public static class JsonDecoder
        extends JsonUtil.AbstractJsonDecoder<INode> {
            protected INode decode(JsonUtil.AbstractJsonDecoder.Json json) {
                if (json.hasAttr("value") || json.hasAttr("text")) {
                    return (INode)this.fromJson(json, Node.class);
                }
                if (json.hasAttr("x") || json.hasAttr("y") || json.hasAttr("z")) {
                    return (INode)this.fromJson(json, XYNode.class);
                }
                throw new RuntimeException("Unknown NormalChartModel.INode type.");
            }
        }
    }

    public static class Series
    extends AbstractOrderingSupported {
        public static final int HEAPZISE_OVERHEAD = OccupyByte.align(OccupyByte.OBJECT + OccupyByte.REFERENCE * 5);
        private String name;
        private List<INode> nodes;
        private String color;
        private String formatString;
        private String seriesFieldText;
        private String seriesFieldValue;
        private Integer axisIndex;

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setNodes(List<INode> node) {
            this.nodes = node;
        }

        public List<INode> getNodes() {
            return this.nodes;
        }

        public List<INode> getCategoryFitnessNodeList(int categoryCount) {
            if (this.nodes == null) {
                this.nodes = new ArrayList<INode>(categoryCount);
            }
            if (this.nodes.size() == 0) {
                for (int i = 0; i < categoryCount; ++i) {
                    this.nodes.add(null);
                }
            }
            return this.nodes;
        }

        public void setColor(String color) {
            this.color = color;
        }

        public String getColor() {
            return this.color;
        }

        public void setFormatString(String formatString) {
            this.formatString = formatString;
        }

        public String getFormatString() {
            return this.formatString;
        }

        public void setSeriesFieldValueText(String fieldValue, String fieldText) {
            this.seriesFieldValue = fieldValue;
            this.seriesFieldText = fieldText;
        }

        public String getSeriesFieldValue() {
            return this.seriesFieldValue;
        }

        public String getSeriesFieldText() {
            return this.seriesFieldText;
        }

        public String getExecutableSeriesFieldValue() {
            return this.seriesFieldValue == null ? this.seriesFieldText : this.seriesFieldValue;
        }

        public void setAxisIndex(int idx) {
            this.axisIndex = idx;
        }

        public int getAxisIndex() {
            return this.axisIndex == null ? 0 : this.axisIndex;
        }

        @Override
        public boolean isEqualTo(Object obj) {
            if (!(obj instanceof Series)) {
                return false;
            }
            Series another = (Series)obj;
            return Series.isEqualEachOther(this.name, another.name) && Series.isListEqualEachOther(this.nodes, another.nodes) && Series.isEqualEachOther(this.color, another.color) && Series.isEqualEachOther(this.formatString, another.formatString) && Series.isEqualEachOther(this.seriesFieldValue, another.seriesFieldValue) && Series.isEqualEachOther(this.seriesFieldText, another.seriesFieldText) && Series.isEqualEachOther(this.axisIndex, another.axisIndex);
        }
    }

    public static class Category
    extends AbstractOrderingSupported {
        public static final int HEAPZISE_OVERHEAD = OccupyByte.align(OccupyByte.OBJECT + OccupyByte.REFERENCE * 3);
        private String label;
        private String value;
        private String color;
        private Boolean asParent;

        public void setLabel(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public void setColor(String color) {
            this.color = color;
        }

        public String getColor() {
            return this.color;
        }

        public void setAsParent(boolean isAsParent) {
            this.asParent = isAsParent;
        }

        public boolean isAsParent() {
            return this.asParent == null ? false : this.asParent;
        }

        @Override
        public boolean isEqualTo(Object obj) {
            if (!(obj instanceof Category)) {
                return false;
            }
            Category another = (Category)obj;
            return Category.isEqualEachOther(this.label, another.label) && Category.isEqualEachOther(this.value, another.value) && Category.isEqualEachOther(this.color, another.color) && Category.isEqualEachOther(this.asParent, another.asParent);
        }
    }
}

