/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.dashboard.model.rich;

import com.kingdee.bos.qing.dashboard.model.rich.Content;
import com.kingdee.bos.qing.dashboard.model.rich.Paragraph;
import com.kingdee.bos.qing.util.XmlUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom2.Element;

public class Chapter {
    private List<Paragraph> paragraphs;

    public int getParagraphCount() {
        return this.paragraphs.size();
    }

    public Paragraph getParagraph(int idx) {
        return this.paragraphs.get(idx);
    }

    public void toXml(Element node) {
        FamiliarValueManager fvm = new FamiliarValueManager();
        fvm.vote(this);
        XmlUtil.writeAttrInt((Element)node, (String)"lineHeight", (int)fvm.getFamiliarLineHeight());
        XmlUtil.writeAttrInt((Element)node, (String)"fontSize", (int)fvm.getFamiliarFontSize());
        for (Paragraph paragraph : this.paragraphs) {
            Element nodeParagraph = new Element("Paragraph");
            paragraph.toXml(nodeParagraph, fvm);
            node.addContent((org.jdom2.Content)nodeParagraph);
        }
    }

    public void fromXml(Element node) {
        FamiliarValueManager fvm = new FamiliarValueManager();
        try {
            fvm.restoreLineHeight(XmlUtil.readAttrInt((Element)node, (String)"lineHeight"));
        }
        catch (XmlUtil.NullException e) {
            fvm.restoreLineHeight(100);
        }
        try {
            fvm.restoreFontSize(XmlUtil.readAttrInt((Element)node, (String)"fontSize"));
        }
        catch (XmlUtil.NullException e) {
            fvm.restoreFontSize(12);
        }
        List subNodes = XmlUtil.getChildren((Element)node, (String)"Paragraph");
        this.paragraphs = new ArrayList<Paragraph>(subNodes.size());
        if (subNodes.size() == 0) {
            Paragraph paragraph = new Paragraph();
            paragraph.setContents(Arrays.asList(new Content("")));
            this.paragraphs.add(paragraph);
        } else {
            for (Element nodeParagraph : subNodes) {
                Paragraph paragraph = new Paragraph();
                paragraph.fromXml(nodeParagraph, fvm);
                this.paragraphs.add(paragraph);
                if (paragraph.getContentCount() != 0) continue;
                paragraph.setContents(Arrays.asList(new Content("")));
            }
        }
    }

    protected static class FamiliarIntegerVoter {
        private Map<Integer, Integer> _counter = new HashMap<Integer, Integer>();
        private Integer _target;

        protected FamiliarIntegerVoter() {
        }

        public void vote(int data) {
            Integer count = this._counter.get(data);
            count = (count == null ? 0 : count) + 1;
            this._counter.put(data, count);
        }

        public int getVotedData() {
            if (this._target == null) {
                int maxCount = 0;
                for (Map.Entry<Integer, Integer> entry : this._counter.entrySet()) {
                    if (entry.getValue() <= maxCount) continue;
                    maxCount = entry.getValue();
                    this._target = entry.getKey();
                }
            }
            return this._target;
        }
    }

    protected static class FamiliarValueManager {
        private FamiliarIntegerVoter _lineHeightVoter = new FamiliarIntegerVoter();
        private FamiliarIntegerVoter _fontSizeVoter = new FamiliarIntegerVoter();

        protected FamiliarValueManager() {
        }

        public void vote(Chapter chapter) {
            for (int i = 0; i < chapter.getParagraphCount(); ++i) {
                Paragraph paragraph = chapter.getParagraph(i);
                paragraph.voteLineHeight(this._lineHeightVoter);
                for (int j = 0; j < paragraph.getContentCount(); ++j) {
                    Content content = paragraph.getContent(j);
                    content.voteFontSize(this._fontSizeVoter);
                }
            }
        }

        public int getFamiliarLineHeight() {
            return this._lineHeightVoter.getVotedData();
        }

        public void restoreLineHeight(int value) {
            this._lineHeightVoter.vote(value);
        }

        public int getFamiliarFontSize() {
            return this._fontSizeVoter.getVotedData();
        }

        public void restoreFontSize(int value) {
            this._fontSizeVoter.vote(value);
        }
    }
}

