/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.dashboard.model.rich;

import com.kingdee.bos.qing.dashboard.model.rich.Chapter;
import com.kingdee.bos.qing.util.XmlUtil;
import org.jdom2.Element;

public class Content {
    private static final String SPACE_SAFE_BOUNDARY = "&nbsp;";
    private String text;
    private String fontName;
    private int fontSize;
    private Boolean bold;
    private Boolean italic;
    private String color;

    public Content(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public String getFontName() {
        return this.fontName;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public boolean isBold() {
        return this.bold == null ? false : this.bold;
    }

    public boolean isItalic() {
        return this.italic == null ? false : this.italic;
    }

    public String getColor() {
        return this.color;
    }

    public void voteFontSize(Chapter.FamiliarIntegerVoter voter) {
        voter.vote(this.fontSize);
    }

    public void toXml(Element node, Chapter.FamiliarValueManager fvm) {
        String characters = this.wrapSpaceSafely(this.text);
        XmlUtil.addCDATA((Element)node, (String)characters);
        if (this.fontSize != fvm.getFamiliarFontSize()) {
            XmlUtil.writeAttrInt((Element)node, (String)"fontSize", (int)this.fontSize);
        }
        XmlUtil.writeAttrWhenExist((Element)node, (String)"fontName", (String)this.fontName);
        XmlUtil.writeAttrBoolWhenExist((Element)node, (String)"bold", (Boolean)this.bold);
        XmlUtil.writeAttrBoolWhenExist((Element)node, (String)"italic", (Boolean)this.italic);
        XmlUtil.writeAttrWhenExist((Element)node, (String)"color", (String)this.color);
    }

    public void fromXml(Element node, Chapter.FamiliarValueManager fvm) {
        String characters = node.getTextTrim();
        this.text = this.unwrapSpaceSafely(characters);
        Integer fontSize = XmlUtil.readAttrIntWhenExist((Element)node, (String)"fontSize");
        this.fontSize = fontSize == null ? fvm.getFamiliarFontSize() : fontSize.intValue();
        this.fontName = XmlUtil.readAttrWhenExist((Element)node, (String)"fontName");
        this.bold = XmlUtil.readAttrBoolWhenExist((Element)node, (String)"bold");
        this.italic = XmlUtil.readAttrBoolWhenExist((Element)node, (String)"italic");
        this.color = XmlUtil.readAttrWhenExist((Element)node, (String)"color");
    }

    private String wrapSpaceSafely(String text) {
        String encoded = text;
        if (encoded.startsWith(" ")) {
            encoded = SPACE_SAFE_BOUNDARY + encoded;
        }
        if (encoded.endsWith(" ")) {
            encoded = encoded + SPACE_SAFE_BOUNDARY;
        }
        return encoded;
    }

    private String unwrapSpaceSafely(String encoded) {
        String text = encoded;
        if (text.startsWith(SPACE_SAFE_BOUNDARY)) {
            text = text.substring(SPACE_SAFE_BOUNDARY.length());
        }
        if (text.endsWith(SPACE_SAFE_BOUNDARY)) {
            text = text.substring(0, text.length() - SPACE_SAFE_BOUNDARY.length());
        }
        return text;
    }
}

