/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.domain;

import com.kingdee.bos.qing.core.engine.AbstractEngine;
import com.kingdee.bos.qing.core.engine.IEngineOutput;
import com.kingdee.bos.qing.core.engine.runner.longer.EngineRunner;
import com.kingdee.bos.qing.core.engine.runner.longer.MdEngineRunner;
import com.kingdee.bos.qing.core.exception.AnalysisException;
import com.kingdee.bos.qing.core.model.analysis.IQingModel;
import com.kingdee.bos.qing.core.model.analysis.longer.AnalyticalModel;
import com.kingdee.bos.qing.core.model.analysis.square.RollFieldSet;
import com.kingdee.bos.qing.core.model.analysis.square.SquareModel;
import com.kingdee.bos.qing.core.model.meta.Meta;
import com.kingdee.bos.qing.datasource.spec.IDataSourceVisitor;
import com.kingdee.bos.qing.domain.AbstractDomain;
import com.kingdee.bos.qing.domain.AdditionalFilterDomain;

abstract class AbstractBriefOutputDomain
extends AbstractDomain {
    public AbstractBriefOutputDomain(AbstractDomain.IDataSourceCreator dataSourceCreator) {
        super(dataSourceCreator);
    }

    protected final IEngineOutput makeCube(IQingModel model, AdditionalFilterDomain.AdditionalFilters additionalFilters) throws AnalysisException {
        AbstractEngine engineOutput;
        IDataSourceVisitor dataSource = this.createDataSourceVisitor();
        if (model instanceof AnalyticalModel) {
            AnalyticalModel analyticalModel = (AnalyticalModel)model;
            if (additionalFilters != null) {
                AdditionalFilterDomain afd = new AdditionalFilterDomain(this.getDataSourceCreator());
                afd.mergeIntoLonger(analyticalModel, additionalFilters);
            }
            EngineRunner engineRunner = model.getMeta().getSrcMode() == Meta.Src.MD ? new MdEngineRunner(dataSource, analyticalModel) : new EngineRunner(dataSource, analyticalModel);
            engineRunner.setContext(this.getI18nContext());
            engineOutput = engineRunner.run(AbstractBriefOutputDomain.createExecutingCorrespondent());
        } else if (model instanceof SquareModel) {
            SquareModel squareModel = (SquareModel)model;
            RollFieldSet rollFieldSet = squareModel.getChartModel().getRoll();
            if (rollFieldSet != null) {
                rollFieldSet.clearAllState();
            }
            if (additionalFilters != null) {
                AdditionalFilterDomain afd = new AdditionalFilterDomain(this.getDataSourceCreator());
                afd.mergeIntoSquare(squareModel, additionalFilters);
            }
            com.kingdee.bos.qing.core.engine.runner.square.EngineRunner engineRunner = new com.kingdee.bos.qing.core.engine.runner.square.EngineRunner(dataSource, squareModel, this.getI18nContext());
            engineOutput = engineRunner.run(AbstractBriefOutputDomain.createExecutingCorrespondent());
        } else {
            throw new RuntimeException("Impossible");
        }
        return engineOutput;
    }
}

