/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.domain;

import com.kingdee.bos.qing.core.engine.DataSourceGreenChannel;
import com.kingdee.bos.qing.core.engine.FilterPreparedValueGainer;
import com.kingdee.bos.qing.core.exception.AnalysisException;
import com.kingdee.bos.qing.core.exception.DataTraversalException;
import com.kingdee.bos.qing.core.exception.FormulaExecutingException;
import com.kingdee.bos.qing.core.model.analysis.IQingModel;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.core.model.analysis.common.filter.AbstractAnalyticalFilter;
import com.kingdee.bos.qing.core.model.analysis.common.filter.ContinuousDateFilter;
import com.kingdee.bos.qing.core.model.analysis.common.filter.ContinuousFilter;
import com.kingdee.bos.qing.core.model.analysis.common.filter.DiscreteFilter;
import com.kingdee.bos.qing.core.model.exhibition.common.filter.AbstractPreparedValue;
import com.kingdee.bos.qing.core.model.exhibition.common.filter.InvalidPreparedValue;
import com.kingdee.bos.qing.core.model.meta.DataType;
import com.kingdee.bos.qing.core.model.meta.Meta;
import com.kingdee.bos.qing.datasource.exception.AbstractDataSourceException;
import com.kingdee.bos.qing.datasource.exception.DataSourceNoDataException;
import com.kingdee.bos.qing.datasource.spec.IDataSourceVisitor;
import com.kingdee.bos.qing.domain.AbstractDomain;
import com.kingdee.bos.qing.monitor.ICorrespondent;
import java.util.Calendar;
import java.util.Map;

public abstract class AbstractFilterDomain
extends AbstractDomain {
    public AbstractFilterDomain(AbstractDomain.IDataSourceCreator dataSourceCreator) {
        super(dataSourceCreator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final FilterPreparedValueGainer.IPreparedValueFruit getRelativedPreparedValue(IQingModel model, AnalyticalField field) throws AnalysisException {
        ICorrespondent correspondent = null;
        try {
            correspondent = AbstractFilterDomain.createExecutingCorrespondent();
            FilterPreparedValueGainer.IPreparedValueFruit iPreparedValueFruit = this.getRelativedPreparedValue(model, field, correspondent);
            return iPreparedValueFruit;
        }
        finally {
            AbstractFilterDomain.destroyExecutingCorrespondent(correspondent);
        }
    }

    protected abstract FilterPreparedValueGainer.IPreparedValueFruit getRelativedPreparedValue(IQingModel var1, AnalyticalField var2, ICorrespondent var3) throws AnalysisException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final FilterPreparedValueGainer.IPreparedValueFruit getAllPreparedValueByEngine(IQingModel model, AnalyticalField field) throws AnalysisException {
        ICorrespondent correspondent = null;
        try {
            correspondent = AbstractFilterDomain.createExecutingCorrespondent();
            FilterPreparedValueGainer.IPreparedValueFruit iPreparedValueFruit = this.getAllPreparedValueByEngine(model, field, correspondent);
            return iPreparedValueFruit;
        }
        finally {
            AbstractFilterDomain.destroyExecutingCorrespondent(correspondent);
        }
    }

    protected abstract FilterPreparedValueGainer.IPreparedValueFruit getAllPreparedValueByEngine(IQingModel var1, AnalyticalField var2, ICorrespondent var3) throws AnalysisException;

    protected final AbstractPreparedValue getFilterPreparedValue(IQingModel model, AnalyticalField field, AbstractAnalyticalFilter filter, boolean isFilteredByOthers, boolean isAffected) throws AnalysisException {
        AbstractPreparedValue invalidPreparedValue = AbstractFilterDomain.checkInvalid(field, filter);
        if (invalidPreparedValue != null) {
            return invalidPreparedValue;
        }
        if (isFilteredByOthers && isAffected && model.getMeta().getSrcMode() != Meta.Src.MD) {
            FilterPreparedValueGainer.IPreparedValueFruit pvfRelatived = this.getRelativedPreparedValue(model, field);
            return pvfRelatived.getPreparedValue();
        }
        FilterPreparedValueGainer.IPreparedValueFruit pvfAll = field.isCanPullDown() ? this.getAllPreparedValueByPullDown(field) : this.getAllPreparedValueByEngine(model, field);
        return pvfAll.getPreparedValue();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final FilterPreparedValueGainer.IPreparedValueFruit getAllPreparedValueByPullDown(AnalyticalField field) throws AnalysisException {
        Comparable<Calendar>[] scope;
        IDataSourceVisitor dataSourceVisitor = this.createDataSourceVisitor();
        DataSourceGreenChannel greenChannel = new DataSourceGreenChannel(dataSourceVisitor);
        final FilterPreparedValueGainer.AbstractPreparedValueGainer gainer = FilterPreparedValueGainer.create(field, this.getI18nContext());
        if (field.getDataType() == DataType.DATE && field.isDimension() && field.isContinuous()) {
            try {
                scope = greenChannel.getDateScope(field);
                if (scope != null && scope.length == 2) {
                    gainer.gain(scope[0]);
                    gainer.gain(scope[1]);
                }
            }
            catch (AbstractDataSourceException ex) {
                throw DataTraversalException.createGetDateScopeError((Exception)((Object)ex));
            }
        }
        if (field.getDataType() == DataType.NUMBER && field.isDimension() && field.isContinuous()) {
            try {
                scope = greenChannel.getNumberScope(field);
                if (scope == null || scope.length != 2) return gainer.getFruit();
                gainer.gain(scope[0]);
                gainer.gain(scope[1]);
                return gainer.getFruit();
            }
            catch (AbstractDataSourceException ex) {
                throw DataTraversalException.createGetDateScopeError((Exception)((Object)ex));
            }
        }
        try {
            greenChannel.getDistinctValue(field, new DataSourceGreenChannel.AbstractValueCollecter(){

                @Override
                public void accept(Map<String, Object> values) {
                    Object value;
                    try {
                        value = gainer.getDataGetter(null).getData(values);
                    }
                    catch (FormulaExecutingException e) {
                        value = null;
                    }
                    gainer.gain(value);
                }
            });
            return gainer.getFruit();
        }
        catch (DataSourceNoDataException ex) {
            return gainer.getFruit();
        }
        catch (AbstractDataSourceException ex) {
            throw DataTraversalException.createGetDistinctError((Exception)((Object)ex));
        }
    }

    public static AbstractPreparedValue checkInvalid(AnalyticalField field, AbstractAnalyticalFilter filter) {
        if (field.getMetaField().isCalculation() && !field.getMetaField().isValidCalculation()) {
            return InvalidPreparedValue.FIELD_ERROR_PREPARED_VALUE;
        }
        if (filter instanceof ContinuousFilter) {
            if (DataType.NUMBER != field.getMetaField().getDataType()) {
                return InvalidPreparedValue.PMODEL_UNMATCH_PREPARED_VALUE;
            }
        } else if (filter instanceof ContinuousDateFilter) {
            if (DataType.DATE != field.getMetaField().getDataType()) {
                return InvalidPreparedValue.PMODEL_UNMATCH_PREPARED_VALUE;
            }
        } else if (filter instanceof DiscreteFilter) {
            boolean isValid2;
            boolean isValid1 = DataType.STRING == field.getMetaField().getDataType() && field.getPartValue() == null;
            boolean bl = isValid2 = DataType.DATE == field.getMetaField().getDataType() && field.getPartValue() != null;
            if (!isValid1 && !isValid2) {
                return InvalidPreparedValue.PMODEL_UNMATCH_PREPARED_VALUE;
            }
        }
        return null;
    }
}

