/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.domain;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.core.charttype.longer.AbstractChartTypeCoupler;
import com.kingdee.bos.qing.core.charttype.longer.ChartTypeComposerFactory;
import com.kingdee.bos.qing.core.engine.AbstractEngine;
import com.kingdee.bos.qing.core.engine.FilterPreparedValueGainer;
import com.kingdee.bos.qing.core.engine.IEngineOutput;
import com.kingdee.bos.qing.core.engine.runner.longer.EngineRunner;
import com.kingdee.bos.qing.core.engine.runner.longer.EngineRunnerForFilterPreparedValue;
import com.kingdee.bos.qing.core.exception.AnalysisException;
import com.kingdee.bos.qing.core.exception.ConfigCeilingException;
import com.kingdee.bos.qing.core.flattening.longer.AbstractFlatBuilder;
import com.kingdee.bos.qing.core.i18n.Messages;
import com.kingdee.bos.qing.core.model.ResultWrapper;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.core.model.analysis.common.filter.AbstractAnalyticalFilter;
import com.kingdee.bos.qing.core.model.analysis.longer.AnalyticalModel;
import com.kingdee.bos.qing.core.model.analysis.longer.ChartType;
import com.kingdee.bos.qing.core.model.analysis.longer.FilterFieldSet;
import com.kingdee.bos.qing.core.model.analysis.longer.ModelAssistantStructure;
import com.kingdee.bos.qing.core.model.analysis.longer.preferences.ExhibitionStatus;
import com.kingdee.bos.qing.core.model.exhibition.common.filter.AbstractPreparedValue;
import com.kingdee.bos.qing.core.model.exhibition.common.filter.AbstractScopeLimitedSelectedValues;
import com.kingdee.bos.qing.core.model.exhibition.longer.TableView;
import com.kingdee.bos.qing.datasource.spec.IDataSourceVisitor;
import com.kingdee.bos.qing.domain.AbstractDomain;
import com.kingdee.bos.qing.domain.AbstractFilterDomain;
import com.kingdee.bos.qing.domain.AdditionalFilterDomain;
import com.kingdee.bos.qing.domain.FilterDomain;
import com.kingdee.bos.qing.domain.MetaDomain;
import com.kingdee.bos.qing.domain.PostExecuteDomain;
import com.kingdee.bos.qing.monitor.ICorrespondent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ExecuteDomain
extends AbstractDomain {
    public static final String KEY_ENGINE = "engine";
    public static final String PERFORMACE_CPU_ALL = "allTime";
    public static final String PERFORMACE_CPU_DETAIL = "detailTime";
    public static final String PERFORMACE_MEM_ALL = "allMemory";
    public static final String PERFORMACE_MEM_DETAIL = "detailMemory";
    private IMilestoneListener _milestoneListener;
    private Map<String, Object> _performanceInfo;
    private long _startTime;
    private long _milestoneTime = -1L;
    private List<Integer> _timeCollection;
    private QingContext _qingContext;
    private boolean _isExhibitionCacheable = false;
    private int _outputMaxColumns = -1;

    public ExecuteDomain(AbstractDomain.IDataSourceCreator dataSourceCreator) {
        super(dataSourceCreator);
    }

    public void setQingContext(QingContext ctx) {
        this._qingContext = ctx;
    }

    public Map<String, Object> getPerformaceInfo() {
        return this._performanceInfo;
    }

    public void setMilestoneListener(IMilestoneListener listener) {
        this._milestoneListener = listener;
    }

    private void fireMilestoneEvent(Milestone milestone, Map<String, Object> info) {
        if (this._milestoneTime == -1L) {
            this._milestoneTime = this._startTime = System.currentTimeMillis();
            this._timeCollection = new ArrayList<Integer>(5);
            this._performanceInfo = new HashMap<String, Object>();
        } else {
            this._milestoneTime = this.timestmp(this._milestoneTime, this._timeCollection);
        }
        if (this._milestoneListener != null) {
            this._milestoneListener.park(milestone, info);
        }
    }

    protected final void fireMilestoneEvent(Milestone milestone) {
        this.fireMilestoneEvent(milestone, null);
    }

    protected final void fireMilestoneEvent(Milestone milestone, String key, Object value) {
        HashMap<String, Object> info = new HashMap<String, Object>();
        info.put(key, value);
        this.fireMilestoneEvent(milestone, info);
    }

    public void setExhibitionCacheable(boolean isCacheable) {
        this._isExhibitionCacheable = isCacheable;
    }

    protected boolean isExhibitionCacheable() {
        return this._isExhibitionCacheable;
    }

    public void setOutputMaxColumns(int maxColumns) {
        this._outputMaxColumns = maxColumns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultWrapper christmas(AnalyticalModel model, AdditionalFilterDomain.AdditionalFilters additionalFilters, boolean isCheckSelectedValueScope) throws AnalysisException {
        TableView tv;
        this.fireMilestoneEvent(Milestone.BEGIN);
        IDataSourceVisitor dataSource = this.createDataSourceVisitor();
        boolean theRealFirstTime = isCheckSelectedValueScope;
        if (theRealFirstTime) {
            MetaDomain.verifyMetaFieldsExist(model.getMeta(), dataSource.getMeta());
        }
        AnalyticalModel model2 = model.copy();
        if (additionalFilters != null) {
            AdditionalFilterDomain afd = new AdditionalFilterDomain(this.getDataSourceCreator());
            afd.mergeIntoLonger(model, additionalFilters);
        }
        this.fireMilestoneEvent(Milestone.ENGINE_START);
        EngineRunner runner = new EngineRunner(dataSource, model);
        runner.setContext(this.getI18nContext());
        ICorrespondent correspondent = null;
        try {
            correspondent = ExecuteDomain.createExecutingCorrespondent();
            AbstractEngine engine = runner.run(correspondent);
            this.fireMilestoneEvent(Milestone.ENGINE_FINISH, KEY_ENGINE, engine);
            this.fireMilestoneEvent(Milestone.FLAT_START);
            tv = this.flat(model, runner.getModelAssistantStructure(), engine, correspondent);
            this.fireMilestoneEvent(Milestone.FLAT_FINISH);
            this.collectMemoryInfo(correspondent);
            engine = null;
        }
        catch (ConfigCeilingException ex) {
            tv = this.createFlatBuilder(model, null).getTableView();
            tv.getTopHead().add(new String[]{" "});
            tv.setWarning(Messages.getLangMessage(this.getI18nContext(), "tooLargeDataToExecute", "\u6570\u636e\u91cf\u8d85\u51fa\u5f15\u64ce\u5904\u7406\u9650\u5236\u3002"));
        }
        finally {
            ExecuteDomain.destroyExecutingCorrespondent(correspondent);
        }
        FilterFieldSet filterFieldSet = model2.getFilterFieldSet();
        int filterCount = filterFieldSet.getFieldCount();
        ArrayList<AbstractPreparedValue> pvs = new ArrayList<AbstractPreparedValue>(filterCount);
        ArrayList<AbstractScopeLimitedSelectedValues> filterSelectedValue = isCheckSelectedValueScope ? new ArrayList<AbstractScopeLimitedSelectedValues>(filterCount) : null;
        Integer[] filterIndexArray = this.cleanInvalidFilterFieldForPrepareValues(filterFieldSet, pvs, filterSelectedValue);
        boolean[] isFilteredByOthersArray = this.isFilteredByOthers(filterFieldSet, filterIndexArray, -1);
        boolean[] isNeedGetAll = new boolean[filterIndexArray.length];
        for (int i = 0; i < filterIndexArray.length; ++i) {
            boolean isFilteredByOthers = isFilteredByOthersArray[i];
            AbstractAnalyticalFilter filter = filterFieldSet.getFilters().get(i);
            boolean isRelativedNeeded = isFilteredByOthers && filter.isAffected();
            boolean isCheckingScopeNeeded = isCheckSelectedValueScope && !filter.isFullValue();
            isNeedGetAll[i] = !isRelativedNeeded || isCheckingScopeNeeded;
        }
        List<FilterPreparedValueGainer.IPreparedValueFruit> allPvfs = this.runForAllPreparedValues(model2, filterFieldSet, isNeedGetAll, tv);
        for (int i = 0; i < filterIndexArray.length; ++i) {
            AbstractPreparedValue pv;
            int filterIdx = filterIndexArray[i];
            boolean isFilteredByOthers = isFilteredByOthersArray[i];
            AnalyticalField field = filterFieldSet.getFields().get(i);
            AbstractAnalyticalFilter filter = filterFieldSet.getFilters().get(i);
            FilterPreparedValueGainer.IPreparedValueFruit allPvf = allPvfs.get(i);
            boolean isAllGot = false;
            if (isFilteredByOthers && filter.isAffected()) {
                FilterDomain filterDomain = new FilterDomain(this.getDataSourceCreator());
                FilterPreparedValueGainer.IPreparedValueFruit relativedPvf = filterDomain.getRelativedPreparedValue(model2, field);
                pv = relativedPvf.getPreparedValue();
            } else {
                pv = allPvf.getPreparedValue();
                isAllGot = true;
            }
            pvs.set(filterIdx, pv);
            if (!isCheckSelectedValueScope || filter.isFullValue() || allPvf.isGainerInvalid()) continue;
            AbstractPreparedValue allScope = isAllGot ? pv : allPvf.getPreparedValue();
            AbstractScopeLimitedSelectedValues selectedValue = filter.getSlicedSelectValuesWithinScope(allScope);
            filterSelectedValue.set(filterIdx, selectedValue);
        }
        this.fireMilestoneEvent(Milestone.END);
        this.collectCpuInfo();
        ResultWrapper wrapper = new ResultWrapper();
        wrapper.setTableView(tv);
        wrapper.setFilterPreparedValues(pvs);
        wrapper.setFilterSelectedValues(filterSelectedValue);
        return wrapper;
    }

    protected final Integer[] cleanInvalidFilterFieldForPrepareValues(FilterFieldSet filterFieldSet, List<AbstractPreparedValue> preparedValueList, List<AbstractScopeLimitedSelectedValues> selectedValuesList) {
        ArrayList<Integer> validFilterIdxList = new ArrayList<Integer>();
        Iterator<AbstractAnalyticalFilter> filterIterator = filterFieldSet.getFilters().iterator();
        Iterator<AnalyticalField> fieldIterator = filterFieldSet.getFields().iterator();
        selectedValuesList = selectedValuesList == null ? new ArrayList<Object>() : selectedValuesList;
        int index = 0;
        while (fieldIterator.hasNext()) {
            AbstractAnalyticalFilter filter;
            AnalyticalField field = fieldIterator.next();
            AbstractPreparedValue invalidPreparedValue = AbstractFilterDomain.checkInvalid(field, filter = filterIterator.next());
            if (invalidPreparedValue == null) {
                preparedValueList.add(null);
                validFilterIdxList.add(index);
            } else {
                fieldIterator.remove();
                filterIterator.remove();
                preparedValueList.add(invalidPreparedValue);
            }
            selectedValuesList.add(null);
            ++index;
        }
        return validFilterIdxList.toArray(new Integer[0]);
    }

    private boolean[] isFilteredByOthers(FilterFieldSet filterFieldSet, Integer[] filterIndexArray, int filteringIndex) {
        boolean[] isFilteredByOthersArray = new boolean[filterIndexArray.length];
        for (int i = 0; i < filterIndexArray.length; ++i) {
            boolean isFilteredByOthers = false;
            for (int j = 0; j < filterIndexArray.length; ++j) {
                if (j == i) continue;
                int brotherFilterIdx = filterIndexArray[j];
                if (brotherFilterIdx == filteringIndex) {
                    isFilteredByOthers = true;
                    break;
                }
                AbstractAnalyticalFilter brotherFilter = filterFieldSet.getFilters().get(j);
                if (brotherFilter.isFullValue()) continue;
                isFilteredByOthers = true;
                break;
            }
            isFilteredByOthersArray[i] = isFilteredByOthers;
        }
        return isFilteredByOthersArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<FilterPreparedValueGainer.IPreparedValueFruit> runForAllPreparedValues(AnalyticalModel model, FilterFieldSet filterFieldSet, boolean[] isNeeded, TableView tv) throws AnalysisException {
        List<FilterPreparedValueGainer.IPreparedValueFruit> allPvfs;
        if (filterFieldSet == null || filterFieldSet.getFieldCount() == 0) {
            return null;
        }
        boolean isEachCanPullDown = true;
        for (int i = 0; i < filterFieldSet.getFieldCount(); ++i) {
            AnalyticalField field;
            if (!isNeeded[i] || (field = filterFieldSet.getField(i)).isCanPullDown()) continue;
            isEachCanPullDown = false;
            break;
        }
        if (isEachCanPullDown) {
            allPvfs = new ArrayList<FilterPreparedValueGainer.IPreparedValueFruit>();
            FilterDomain filterDomain = new FilterDomain(this.getDataSourceCreator());
            for (int i = 0; i < filterFieldSet.getFieldCount(); ++i) {
                if (isNeeded[i]) {
                    AnalyticalField field = filterFieldSet.getField(i);
                    allPvfs.add(filterDomain.getAllPreparedValueByPullDown(field));
                    continue;
                }
                allPvfs.add(null);
            }
        } else {
            IDataSourceVisitor dataSource = this.createDataSourceVisitor();
            EngineRunnerForFilterPreparedValue runnerForAll = new EngineRunnerForFilterPreparedValue(dataSource, model);
            runnerForAll.setContext(this.getI18nContext());
            ICorrespondent correspondent = null;
            try {
                correspondent = ExecuteDomain.createExecutingCorrespondent();
                try {
                    runnerForAll.run(correspondent);
                }
                catch (ConfigCeilingException ex) {
                    if (tv.getWarning() == null) {
                        tv.setWarning(Messages.getLangMessage(this.getI18nContext(), "tooLargeDataToGetPreparedValue", "\u7531\u4e8e\u6570\u636e\u91cf\u8d85\u51fa\u5f15\u64ce\u5904\u7406\u9650\u5236\uff0c\u67d0\u4e9b\u7b5b\u9009\u5668\u7684\u5907\u9009\u503c\u53ef\u80fd\u4e0d\u51c6\u786e\u3002"));
                    }
                }
            }
            finally {
                ExecuteDomain.destroyExecutingCorrespondent(correspondent);
            }
            allPvfs = runnerForAll.getPreparedValueFruits();
        }
        return allPvfs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultWrapper filtering(AnalyticalModel model, AdditionalFilterDomain.AdditionalFilters additionalFilters, int filteringIndex) throws AnalysisException {
        TableView tv;
        this.fireMilestoneEvent(Milestone.BEGIN);
        IDataSourceVisitor dataSource = this.createDataSourceVisitor();
        AnalyticalModel model2 = model.copy();
        if (additionalFilters != null) {
            AdditionalFilterDomain afd = new AdditionalFilterDomain(this.getDataSourceCreator());
            afd.mergeIntoLonger(model, additionalFilters);
        }
        this.fireMilestoneEvent(Milestone.ENGINE_START);
        EngineRunner runner = new EngineRunner(dataSource, model);
        runner.setContext(this.getI18nContext());
        ICorrespondent correspondent = null;
        try {
            correspondent = ExecuteDomain.createExecutingCorrespondent();
            AbstractEngine engine = runner.run(correspondent);
            this.fireMilestoneEvent(Milestone.ENGINE_FINISH, KEY_ENGINE, engine);
            this.fireMilestoneEvent(Milestone.FLAT_START);
            tv = this.flat(model, runner.getModelAssistantStructure(), engine, correspondent);
            this.fireMilestoneEvent(Milestone.FLAT_FINISH);
            this.collectMemoryInfo(correspondent);
            engine = null;
        }
        finally {
            ExecuteDomain.destroyExecutingCorrespondent(correspondent);
        }
        FilterFieldSet filterFieldSet = model2.getFilterFieldSet();
        ArrayList<AbstractPreparedValue> pvs = new ArrayList<AbstractPreparedValue>(filterFieldSet.getFieldCount());
        Integer[] filterIndexArray = this.cleanInvalidFilterFieldForPrepareValues(filterFieldSet, pvs, null);
        boolean[] isFilteredByOthersArray = this.isFilteredByOthers(filterFieldSet, filterIndexArray, filteringIndex);
        for (int i = 0; i < filterIndexArray.length; ++i) {
            int filterIdx = filterIndexArray[i];
            if (filterIdx == filteringIndex) continue;
            boolean isFilteredByOthers = isFilteredByOthersArray[i];
            AbstractAnalyticalFilter filter = filterFieldSet.getFilters().get(i);
            if (!isFilteredByOthers || !filter.isAffected()) continue;
            AnalyticalField field = filterFieldSet.getFields().get(i);
            FilterDomain filterDomain = new FilterDomain(this.getDataSourceCreator());
            FilterPreparedValueGainer.IPreparedValueFruit relativedPvf = filterDomain.getRelativedPreparedValue(model2, field);
            AbstractPreparedValue pv = relativedPvf.getPreparedValue();
            pvs.set(filterIdx, pv);
        }
        this.fireMilestoneEvent(Milestone.END);
        this.collectCpuInfo();
        ResultWrapper wrapper = new ResultWrapper();
        wrapper.setTableView(tv);
        wrapper.setFilterPreparedValues(pvs);
        return wrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultWrapper execute(AnalyticalModel model, AdditionalFilterDomain.AdditionalFilters additionalFilters) throws AnalysisException {
        TableView tv;
        if (this.hasFilterRelativeAggregation(model)) {
            return this.christmas(model, additionalFilters, false);
        }
        if (additionalFilters != null) {
            AdditionalFilterDomain afd = new AdditionalFilterDomain(this.getDataSourceCreator());
            afd.mergeIntoLonger(model, additionalFilters);
        }
        this.fireMilestoneEvent(Milestone.BEGIN);
        IDataSourceVisitor dataSource = this.createDataSourceVisitor();
        this.fireMilestoneEvent(Milestone.ENGINE_START);
        EngineRunner engineRunner = new EngineRunner(dataSource, model);
        engineRunner.setContext(this.getI18nContext());
        ICorrespondent correspondent = null;
        try {
            correspondent = ExecuteDomain.createExecutingCorrespondent();
            AbstractEngine engine = engineRunner.run(correspondent);
            this.fireMilestoneEvent(Milestone.ENGINE_FINISH, KEY_ENGINE, engine);
            this.fireMilestoneEvent(Milestone.FLAT_START);
            tv = this.flat(model, engineRunner.getModelAssistantStructure(), engine, correspondent);
            this.fireMilestoneEvent(Milestone.FLAT_FINISH);
            this.collectMemoryInfo(correspondent);
            engine = null;
        }
        finally {
            ExecuteDomain.destroyExecutingCorrespondent(correspondent);
        }
        this.fireMilestoneEvent(Milestone.END);
        this.collectCpuInfo();
        ResultWrapper wrapper = new ResultWrapper();
        wrapper.setTableView(tv);
        wrapper.setFilterPreparedValues(new ArrayList<AbstractPreparedValue>());
        return wrapper;
    }

    protected boolean isOutputingLeftHeadMergeBlocks(AnalyticalModel model) {
        boolean isTreeExist = this.isParentChildDimentionAtRow(model);
        return !isTreeExist;
    }

    protected final AbstractFlatBuilder createFlatBuilder(AnalyticalModel model, ModelAssistantStructure mas) {
        AbstractChartTypeCoupler ctc = ChartTypeComposerFactory.getInstance(model.getChartType());
        mas = mas == null ? ctc.parseAssistantStructure(model) : mas;
        AbstractFlatBuilder flatBuilder = ctc.createFlatBuilder();
        flatBuilder.setQingContext(this.getI18nContext(), this.getSkinName());
        flatBuilder.setOutputtingLeftHeadMergeBlocks(this.isOutputingLeftHeadMergeBlocks(model));
        flatBuilder.setModel(model, mas);
        return flatBuilder;
    }

    protected final TableView flat(AnalyticalModel model, ModelAssistantStructure mas, IEngineOutput engine, ICorrespondent correspondent) throws AnalysisException {
        AbstractFlatBuilder flatBuilder = this.createFlatBuilder(model, mas);
        if (this._outputMaxColumns > 0) {
            flatBuilder.setTableMaxColumns(this._outputMaxColumns);
        }
        flatBuilder.setEngineOutputer(engine);
        flatBuilder.flat(correspondent);
        TableView tv = flatBuilder.getTableView();
        if (this.isExhibitionCacheable()) {
            this.cache(model, tv);
        }
        return tv;
    }

    private void cache(AnalyticalModel model, TableView tv) {
        int rows = tv.getLeftHead().size();
        int leftColumnCount = rows > 0 ? tv.getLeftHead().get(0).length : 0;
        int bodyColumnCount = tv.getTopHead().size();
        int columns = leftColumnCount + bodyColumnCount;
        if (rows == 0 || columns == 0) {
            return;
        }
        AbstractDomain.IExhibitionCacheWriter cacheWriter = this.getDataSourceCreator().createExhibitionCacheWriter(this._qingContext);
        PostExecuteDomain postExecuteDomain = new PostExecuteDomain();
        if (this.isParentChildDimentionAtRow(model)) {
            List<ExhibitionStatus.TreeExpandState> treeExpandStates = model.getTreeExpandStates();
            postExecuteDomain.cacheTreeExhibition(cacheWriter, tv, treeExpandStates, leftColumnCount);
        } else {
            int firstPartRows = Math.max(100, Math.min(10000, 25600 / columns));
            int everyPartRows = Math.max(100, Math.min(1000, firstPartRows / 10));
            if (ChartType.Table != model.getChartType() && ChartType.HeatMap != model.getChartType()) {
                firstPartRows = Math.max(20, Math.min(100, firstPartRows / 10));
                everyPartRows = Math.max(10, Math.min(50, everyPartRows / 10));
            }
            postExecuteDomain.cacheNormalExhibition(cacheWriter, tv, firstPartRows, everyPartRows);
        }
    }

    private boolean isParentChildDimentionAtRow(AnalyticalModel model) {
        for (AnalyticalField field : model.getRow().getFields()) {
            if (!field.isParentChildDimension()) continue;
            return true;
        }
        return false;
    }

    private boolean hasFilterRelativeAggregation(AnalyticalModel model) {
        FilterFieldSet filterFieldSet = model.getFilterFieldSet();
        if (filterFieldSet != null && filterFieldSet.getFieldCount() > 0) {
            List<AnalyticalField> fields = filterFieldSet.getFields();
            for (AnalyticalField field : fields) {
                if (!field.isMeasure() || field.getAggregation() == null) continue;
                return true;
            }
        }
        return false;
    }

    private long timestmp(long lastTime, List<Integer> collection) {
        long time = System.currentTimeMillis();
        collection.add((int)(time - lastTime));
        return time;
    }

    protected final void collectMemoryInfo(ICorrespondent correspondent) {
        if (correspondent != null) {
            Map<String, Object> map = correspondent.getPerformanceInfo();
            this._performanceInfo.put(PERFORMACE_MEM_ALL, map.get("all"));
            this._performanceInfo.put(PERFORMACE_MEM_DETAIL, map.get("detail"));
        }
    }

    protected final void collectCpuInfo() {
        this._performanceInfo.put(PERFORMACE_CPU_ALL, this._milestoneTime - this._startTime);
        this._performanceInfo.put(PERFORMACE_CPU_DETAIL, this._timeCollection);
    }

    public static enum Milestone {
        BEGIN,
        ENGINE_START,
        ENGINE_FINISH,
        FLAT_START,
        FLAT_FINISH,
        END;

    }

    public static interface IMilestoneListener {
        public void park(Milestone var1, Map<String, Object> var2);
    }
}

