/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.export.chart.mock;

import com.kingdee.bos.qing.export.chart.mock.Canvas;
import com.kingdee.bos.qing.export.chart.mock.FontUtil;
import com.kingdee.bos.qing.export.common.util.ColorTransUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Context2D {
    private Graphics2D graphics;
    private Point2D currentPathStartPoint;
    private Path2D.Float currentPath = new Path2D.Float();
    private Map stateSavedMap = new HashMap();
    private boolean isMoveToCalled;
    public Canvas canvas;
    public Object fillStyle = "#000000";
    public Object strokeStyle;
    public float lineWidth;
    public String lineCap;
    public String lineJoin;
    public float miterLimit;
    public String font;
    public String textAlign;
    public String textBaseline;

    public Context2D(Graphics g) {
        this.graphics = (Graphics2D)g;
        this.graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this.graphics.setBackground(Color.white);
    }

    public void beginPath() {
        this.currentPath.reset();
    }

    public void closePath() {
        this.currentPath.closePath();
    }

    public void fill() {
        this.fillInit();
        if (this.isMoveToCalled) {
            this.closePath();
        }
        this.graphics.fill(this.currentPath);
    }

    public void arc(double x, double y, double radius, double startAngleJS, double endAngleJS, boolean counterclockwise) {
        Arc2D arc = this.createArc(x, y, radius, startAngleJS, endAngleJS, counterclockwise);
        if (this.currentPath.getCurrentPoint() != null) {
            Point2D point = arc.getStartPoint();
            this.currentPath.lineTo(point.getX(), point.getY());
        }
        this.currentPath.append(arc, true);
    }

    public void arc(double x, double y, double radius, double startAngle, double endAngle, Object undefined) {
        this.arc(x, y, radius, startAngle, endAngle, false);
    }

    public void arc(double x, double y, double radius, double startAngle, double endAngle) {
        this.arc(x, y, radius, startAngle, endAngle, false);
    }

    public void arcTo(double x1, double y1, double x2, double y2, double radius) {
        Point2D.Double p0 = new Point2D.Double(this.currentPath.getCurrentPoint().getX(), this.currentPath.getCurrentPoint().getY());
        Point2D.Double p1 = new Point2D.Double(x1, y1);
        Point2D.Double p2 = new Point2D.Double(x2, y2);
        if (this.currentPath.getCurrentPoint() == null) {
            this.currentPath.moveTo(x1, y1);
            return;
        }
        if (this.isEqual(((Point2D)p1).getX(), ((Point2D)p0).getX()) && this.isEqual(((Point2D)p1).getY(), ((Point2D)p0).getY()) || this.isEqual(((Point2D)p1).getX(), ((Point2D)p2).getX()) && this.isEqual(((Point2D)p1).getY(), ((Point2D)p2).getY()) || this.isEqual(radius, 0.0)) {
            this.currentPath.lineTo(((Point2D)p1).getX(), ((Point2D)p1).getY());
            return;
        }
        Point2D.Double p1p0 = new Point2D.Double(((Point2D)p0).getX() - ((Point2D)p1).getX(), ((Point2D)p0).getY() - ((Point2D)p1).getY());
        Point2D.Double p1p2 = new Point2D.Double(((Point2D)p2).getX() - ((Point2D)p1).getX(), ((Point2D)p2).getY() - ((Point2D)p1).getY());
        double p1p0_length = Math.sqrt(((Point2D)p1p0).getX() * ((Point2D)p1p0).getX() + ((Point2D)p1p0).getY() * ((Point2D)p1p0).getY());
        double p1p2_length = Math.sqrt(((Point2D)p1p2).getX() * ((Point2D)p1p2).getX() + ((Point2D)p1p2).getY() * ((Point2D)p1p2).getY());
        double cos_phi = (((Point2D)p1p0).getX() * ((Point2D)p1p2).getX() + ((Point2D)p1p0).getY() * ((Point2D)p1p2).getY()) / (p1p0_length * p1p2_length);
        if (this.isEqual(-1.0, cos_phi)) {
            this.currentPath.lineTo(((Point2D)p1).getX(), ((Point2D)p1).getY());
            return;
        }
        if (this.isEqual(1.0, cos_phi)) {
            Point2D.Double ep = new Point2D.Double(((Point2D)p1).getX(), ((Point2D)p1).getY());
            this.currentPath.lineTo(((Point2D)ep).getX(), ((Point2D)ep).getY());
            return;
        }
        double tangent = radius / Math.tan(Math.acos(cos_phi) / 2.0);
        double factor_p1p0 = tangent / p1p0_length;
        Point2D.Double t_p1p0 = new Point2D.Double(((Point2D)p1).getX() + factor_p1p0 * ((Point2D)p1p0).getX(), ((Point2D)p1).getY() + factor_p1p0 * ((Point2D)p1p0).getY());
        Point2D.Double orth_p1p0 = new Point2D.Double(((Point2D)p1p0).getY(), -((Point2D)p1p0).getX());
        double orth_p1p0_length = Math.sqrt(((Point2D)orth_p1p0).getX() * ((Point2D)orth_p1p0).getX() + ((Point2D)orth_p1p0).getY() * ((Point2D)orth_p1p0).getY());
        double factor_ra = radius / orth_p1p0_length;
        double cos_alpha = (((Point2D)orth_p1p0).getX() * ((Point2D)p1p2).getX() + ((Point2D)orth_p1p0).getY() * ((Point2D)p1p2).getY()) / (orth_p1p0_length * p1p2_length);
        if (cos_alpha < 0.0) {
            orth_p1p0 = new Point2D.Double(-((Point2D)orth_p1p0).getX(), -((Point2D)orth_p1p0).getY());
        }
        Point2D.Double p = new Point2D.Double(((Point2D)t_p1p0).getX() + factor_ra * ((Point2D)orth_p1p0).getX(), ((Point2D)t_p1p0).getY() + factor_ra * ((Point2D)orth_p1p0).getY());
        orth_p1p0 = new Point2D.Double(-((Point2D)orth_p1p0).getX(), -((Point2D)orth_p1p0).getY());
        double sa = Math.acos(((Point2D)orth_p1p0).getX() / orth_p1p0_length);
        if (((Point2D)orth_p1p0).getY() < 0.0) {
            sa = Math.PI * 2 - sa;
        }
        boolean anticlockwise = false;
        double factor_p1p2 = tangent / p1p2_length;
        Point2D.Double t_p1p2 = new Point2D.Double(((Point2D)p1).getX() + factor_p1p2 * ((Point2D)p1p2).getX(), ((Point2D)p1).getY() + factor_p1p2 * ((Point2D)p1p2).getY());
        Point2D.Double orth_p1p2 = new Point2D.Double(((Point2D)t_p1p2).getX() - ((Point2D)p).getX(), ((Point2D)t_p1p2).getY() - ((Point2D)p).getY());
        double orth_p1p2_length = Math.sqrt(((Point2D)orth_p1p2).getX() * ((Point2D)orth_p1p2).getX() + ((Point2D)orth_p1p2).getY() * ((Point2D)orth_p1p2).getY());
        double ea = Math.acos(((Point2D)orth_p1p2).getX() / orth_p1p2_length);
        if (((Point2D)orth_p1p2).getY() < 0.0) {
            ea = Math.PI * 2 - ea;
        }
        if (sa > ea && sa - ea < Math.PI) {
            anticlockwise = true;
        }
        if (sa < ea && ea - sa > Math.PI) {
            anticlockwise = true;
        }
        this.currentPath.lineTo(((Point2D)t_p1p0).getX(), ((Point2D)t_p1p0).getY());
        if (anticlockwise && Math.PI * 2 != radius) {
            this.currentPath.append(this.createArc(((Point2D)p).getX(), ((Point2D)p).getY(), radius, sa, ea), true);
        } else {
            this.currentPath.append(this.createArc(((Point2D)p).getX(), ((Point2D)p).getY(), radius, sa, ea), false);
        }
    }

    public void lineTo(double x, double y) {
        this.currentPath.lineTo(x, y);
    }

    public void moveTo(double x, double y) {
        this.updateStartPosition(x, y);
        this.currentPath.moveTo(x, y);
        this.isMoveToCalled = true;
    }

    public void clearRect(int x, int y, int width, int height) {
        this.graphics.clearRect(x, y, width, height);
    }

    public void fillRect(double x, double y, double width, double height) {
        this.fillInit();
        this.graphics.fill(new Rectangle2D.Double(x, y, width, height));
    }

    public void rect(double x, double y, double width, double height) {
        this.moveTo(x, y);
        this.currentPath.append(new Rectangle2D.Double(x, y, width, height), false);
    }

    public void strokeRect(double x, double y, double width, double height) {
        this.strokeInit();
        this.graphics.draw(new Rectangle2D.Double(x, y, width, height));
    }

    public void stroke() {
        this.strokeInit();
        this.graphics.draw(this.currentPath);
    }

    public CanvasGradient createLinearGradient(float x0, float y0, float x1, float y1) {
        return new CanvasGradient(x0, y0, x1, y1);
    }

    public void bezierCurveTo(double x0, double y0, double x1, double y1, double x2, double y2) {
        this.currentPath.lineTo(x2, y2);
    }

    public void scale(double scaleWidth, double scaleHeight) {
        this.graphics.scale(scaleWidth, scaleHeight);
    }

    public void rotate(double theta) {
        this.graphics.rotate(theta);
    }

    public void translate(double x, double y) {
        this.graphics.translate(x, y);
    }

    public void setTransform(double m00, double m10, double m01, double m11, double dx, double dy) {
        AffineTransform transform = this.graphics.getTransform();
        if (transform == null) {
            transform = new AffineTransform();
        }
        transform.setTransform(m00, m10, m01, m11, dx, dy);
        this.graphics.setTransform(transform);
    }

    public void transform(double m00, double m10, double m01, double m11, double dx, double dy) {
        this.graphics.transform(new AffineTransform(m00, m10, m01, m11, dx, dy));
    }

    public void fillText(String text, float x, float y, int maxWidth) {
        if (text == null || text.length() == 0) {
            return;
        }
        this.fillInit();
        this.fontInit();
        if (maxWidth == Integer.MAX_VALUE) {
            this.graphics.drawString(text, this.calculateTextX(text, x), this.calculateTextY(text, y));
        } else {
            float width = this.measureText((String)text).width;
            if (width > (float)maxWidth) {
                AffineTransform transform = this.graphics.getTransform();
                float scaleWidth = (float)maxWidth / width;
                this.scale(scaleWidth, 1.0);
                this.graphics.drawString(text, this.calculateTextX(text, x) / scaleWidth, this.calculateTextY(text, y));
                this.graphics.setTransform(transform);
            } else {
                this.graphics.drawString(text, this.calculateTextX(text, x), this.calculateTextY(text, y));
            }
        }
    }

    public void fillText(String text, float x, float y) {
        this.fillText(text, x, y, Integer.MAX_VALUE);
    }

    public void strokeText(String text, float x, float y) {
        this.fillText(text, x, y);
    }

    public MeasureTextResult measureText(String text) {
        if (text == null || text.length() == 0) {
            return new MeasureTextResult(0.0f);
        }
        this.fillInit();
        this.fontInit();
        float strWidth = this.graphics.getFontMetrics().stringWidth(text);
        return new MeasureTextResult(strWidth);
    }

    public void save() {
        this.stateSavedMap.clear();
        this.stateSavedMap.put("transform", this.graphics.getTransform().clone());
        this.stateSavedMap.put("clip", this.graphics.getClip());
        this.stateSavedMap.put("strokeStyle", this.strokeStyle);
        this.stateSavedMap.put("fillStyle", this.fillStyle);
        this.stateSavedMap.put("lineWidth", Float.valueOf(this.lineWidth));
        this.stateSavedMap.put("lineCap", this.lineCap);
        this.stateSavedMap.put("lineJoin", this.lineJoin);
        this.stateSavedMap.put("miterLimit", Float.valueOf(this.miterLimit));
        this.stateSavedMap.put("font", this.font);
        this.stateSavedMap.put("textAlign", this.textAlign);
        this.stateSavedMap.put("textBaseline", this.textBaseline);
    }

    public void restore() {
        if (this.stateSavedMap.isEmpty()) {
            return;
        }
        Object value = this.stateSavedMap.get("transform");
        if (value != null) {
            this.graphics.setTransform((AffineTransform)value);
        }
        if ((value = this.stateSavedMap.get("clip")) != null) {
            this.graphics.setClip((Shape)value);
        }
        if ((value = this.stateSavedMap.get("strokeStyle")) != null) {
            this.strokeStyle = value;
        }
        if ((value = this.stateSavedMap.get("fillStyle")) != null) {
            this.fillStyle = value;
        }
        if ((value = this.stateSavedMap.get("lineWidth")) != null) {
            this.lineWidth = ((Float)value).floatValue();
        }
        if ((value = this.stateSavedMap.get("lineCap")) != null) {
            this.lineCap = (String)value;
        }
        if ((value = this.stateSavedMap.get("lineJoin")) != null) {
            this.lineJoin = (String)value;
        }
        if ((value = this.stateSavedMap.get("miterLimit")) != null) {
            this.miterLimit = ((Float)value).floatValue();
        }
        if ((value = this.stateSavedMap.get("font")) != null) {
            this.font = (String)value;
        }
        if ((value = this.stateSavedMap.get("textAlign")) != null) {
            this.textAlign = (String)value;
        }
        if ((value = this.stateSavedMap.get("textBaseline")) != null) {
            this.textBaseline = (String)value;
        }
    }

    public void dispose() {
        this.graphics.dispose();
        this.graphics = null;
    }

    private void init() {
        this.graphics.setStroke(this.convertToStroke(this.lineWidth, this.lineCap, this.lineJoin, this.miterLimit));
    }

    private void fontInit() {
        if (this.font != null && this.font.length() > 0) {
            this.graphics.setFont(FontUtil.parseCssFont(this.font));
        }
    }

    private void fillInit() {
        this.init();
        this.setFillStyle();
    }

    private void strokeInit() {
        this.init();
        this.setStrokeStyle();
    }

    private void setFillStyle() {
        if (this.fillStyle instanceof String) {
            this.graphics.setPaint(ColorTransUtil.parseString((String)this.fillStyle));
        } else if (this.fillStyle instanceof CanvasGradient) {
            this.graphics.setPaint(((CanvasGradient)this.fillStyle).createPaint());
        }
    }

    private void setStrokeStyle() {
        if (this.strokeStyle instanceof String) {
            this.graphics.setColor(ColorTransUtil.parseString((String)this.strokeStyle));
        } else if (this.strokeStyle instanceof CanvasGradient) {
            this.graphics.setPaint(((CanvasGradient)this.strokeStyle).createPaint());
        }
    }

    private Stroke convertToStroke(float lineWidth, String lineCapJS, String lineJoinJS, float miterLimit) {
        int lineCap = lineCapJS == null || lineCapJS.length() == 0 ? 2 : (lineCapJS.equals("butt") ? 0 : (lineCapJS.equals("round") ? 1 : 2));
        int lineJoin = lineJoinJS == null || lineJoinJS.length() == 0 ? 0 : (lineJoinJS.equals("bevel") ? 2 : (lineJoinJS.equals("round") ? 1 : 0));
        if (miterLimit == 0.0f) {
            return new BasicStroke(lineWidth, lineCap, lineJoin);
        }
        return new BasicStroke(lineWidth, lineCap, lineJoin, miterLimit);
    }

    public Arc2D createArc(double x, double y, double radius, double startAngle, double endAngle, boolean antiClockwise) {
        double startE = this.radianToAngle(startAngle);
        double endE = this.radianToAngle(endAngle);
        if (antiClockwise) {
            double se = 360.0 - startE;
            double extent = endE - startE;
            if (extent < 0.0) {
                extent += 360.0;
            }
            extent = 360.0 - extent;
            return new Arc2D.Double(x - radius, y - radius, radius * 2.0, radius * 2.0, se, extent, 0);
        }
        double se = 360.0 - startE;
        double extent = endE - startE;
        if (extent < 0.0) {
            extent += 360.0;
        }
        extent = -extent;
        return new Arc2D.Double(x - radius, y - radius, radius * 2.0, radius * 2.0, se, extent, 0);
    }

    public Arc2D createArc(double x, double y, double radius, double startAngle, double endAngle) {
        return this.createArc(x, y, radius, startAngle, endAngle, false);
    }

    private double radianToAngle(double radian) {
        return 57.29577951308232 * radian;
    }

    private void updateStartPosition(double x, double y) {
        if (this.currentPathStartPoint == null) {
            this.currentPathStartPoint = new Point2D.Double();
        }
        this.currentPathStartPoint.setLocation(x, y);
    }

    private boolean isEqual(double a, double b) {
        return Math.abs(a - b) <= 0.0;
    }

    private float calculateTextX(String text, float x) {
        if (this.textAlign == null || this.textAlign.length() == 0 || this.textAlign.equalsIgnoreCase("left") || this.textAlign.equalsIgnoreCase("start")) {
            return x;
        }
        if (this.textAlign.equalsIgnoreCase("right") || this.textAlign.equalsIgnoreCase("end")) {
            int strWidth = this.graphics.getFontMetrics().stringWidth(text);
            return x - (float)strWidth;
        }
        if (this.textAlign.equalsIgnoreCase("center")) {
            int strWidth = this.graphics.getFontMetrics().stringWidth(text);
            return x - (float)(strWidth >> 1);
        }
        return x;
    }

    private float calculateTextY(String text, float y) {
        if (this.textBaseline == null || this.textBaseline.length() == 0 || this.textBaseline.equalsIgnoreCase("alphabetic")) {
            return y;
        }
        FontRenderContext fontRenderContext = this.graphics.getFontRenderContext();
        LineMetrics lineMetrics = this.graphics.getFont().getLineMetrics(text, fontRenderContext);
        float height = (float)this.graphics.getFont().getSize() - lineMetrics.getDescent();
        if (this.textBaseline.equalsIgnoreCase("top")) {
            return y + height;
        }
        if (this.textBaseline.equalsIgnoreCase("hanging")) {
            return y + height;
        }
        if (this.textBaseline.equalsIgnoreCase("middle")) {
            return y + height / 2.0f;
        }
        if (this.textBaseline.equalsIgnoreCase("ideographic")) {
            return y;
        }
        if (this.textBaseline.equalsIgnoreCase("bottom")) {
            return y;
        }
        return y;
    }

    public static class CanvasGradient {
        private float x0;
        private float y0;
        private float x1;
        private float y1;
        private List<Float> fractionList;
        private List<Color> colorList;

        public CanvasGradient(float x0, float y0, float x1, float y1) {
            this.x0 = x0;
            this.y0 = y0;
            this.x1 = x1;
            this.y1 = y1;
            this.fractionList = new ArrayList<Float>();
            this.colorList = new ArrayList<Color>();
        }

        public void addColorStop(float offset, String colorStr) {
            this.fractionList.add(Float.valueOf(offset));
            this.colorList.add(ColorTransUtil.parseString(colorStr));
        }

        public LinearGradientPaint createPaint() {
            float[] arrFraction = new float[this.fractionList.size()];
            for (int i = 0; i < this.fractionList.size(); ++i) {
                arrFraction[i] = this.fractionList.get(i).floatValue();
            }
            Color[] arrColor = new Color[this.colorList.size()];
            for (int i = 0; i < this.colorList.size(); ++i) {
                arrColor[i] = this.colorList.get(i);
            }
            return new LinearGradientPaint(this.x0, this.y0, this.x1, this.y1, arrFraction, arrColor);
        }
    }

    public static class MeasureTextResult {
        public float width;

        public MeasureTextResult() {
        }

        public MeasureTextResult(float width) {
            this.width = width;
        }
    }
}

