/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.export.chart.renderer.longer;

import com.kingdee.bos.qing.core.model.analysis.longer.preferences.ChartConfig;
import com.kingdee.bos.qing.core.model.exhibition.common.chart.AbstractNormalChartModel;
import com.kingdee.bos.qing.core.model.exhibition.common.chart.MultiSeriesChartModel;
import com.kingdee.bos.qing.core.model.exhibition.common.chart.SingleSeriesChartModel;
import com.kingdee.bos.qing.core.model.exhibition.longer.DrawInfo;
import com.kingdee.bos.qing.core.model.exhibition.longer.ICell;
import com.kingdee.bos.qing.export.common.model.ExStyle;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractCellRenderer {
    public abstract Object draw(CellRenderParameter var1);

    private void mergeSeries(AbstractNormalChartModel.Series modelAtCommonCell, AbstractNormalChartModel.Series modelAtCell) {
        String valueAtCommonCell = modelAtCommonCell.getColor();
        if (valueAtCommonCell != null && !valueAtCommonCell.isEmpty()) {
            modelAtCell.setColor(valueAtCommonCell);
        }
        if ((valueAtCommonCell = modelAtCommonCell.getName()) != null && !valueAtCommonCell.isEmpty()) {
            modelAtCell.setName(valueAtCommonCell);
        }
        String value = modelAtCommonCell.getSeriesFieldValue();
        String text = modelAtCommonCell.getSeriesFieldText();
        if (value != null || text != null) {
            modelAtCell.setSeriesFieldValueText(value, text);
        }
        if ((valueAtCommonCell = modelAtCommonCell.getFormatString()) != null && !valueAtCommonCell.isEmpty()) {
            modelAtCell.setFormatString(valueAtCommonCell);
        }
    }

    private void mergeNormalChartModel(AbstractNormalChartModel modelAtCommonCell, AbstractNormalChartModel modelAtCell) {
        List<AbstractNormalChartModel.Series> arrSeries;
        List<AbstractNormalChartModel.Category> arrCategory;
        String sValueAtCommonCell = modelAtCommonCell.getCategoryTitle();
        if (sValueAtCommonCell != null && !sValueAtCommonCell.isEmpty()) {
            modelAtCell.setCategoryTitle(sValueAtCommonCell);
        }
        if ((sValueAtCommonCell = modelAtCommonCell.getSeriesFieldTitle()) != null && !sValueAtCommonCell.isEmpty()) {
            modelAtCell.setSeriesFieldTitle(sValueAtCommonCell);
        }
        if ((arrCategory = modelAtCommonCell.getCategories()) != null && arrCategory.size() > 0) {
            modelAtCell.setCategories(arrCategory);
        }
        if ((arrSeries = modelAtCommonCell.getSeries()) != null && arrSeries.size() > 0) {
            int len = arrSeries.size();
            List<AbstractNormalChartModel.Series> arrSeriesAtCell = modelAtCell.getSeries();
            if (arrSeriesAtCell == null) {
                arrSeriesAtCell = new ArrayList<AbstractNormalChartModel.Series>(len);
            }
            for (int i = 0; i < len; ++i) {
                AbstractNormalChartModel.Series oMySeries;
                AbstractNormalChartModel.Series oSeries = arrSeries.get(i);
                if (i < arrSeriesAtCell.size()) {
                    oMySeries = arrSeriesAtCell.get(i);
                    if (oMySeries == null) {
                        oMySeries = new AbstractNormalChartModel.Series();
                        oMySeries.setNodes(new ArrayList<AbstractNormalChartModel.INode>());
                        arrSeriesAtCell.set(i, oMySeries);
                    }
                } else {
                    oMySeries = new AbstractNormalChartModel.Series();
                    oMySeries.setNodes(new ArrayList<AbstractNormalChartModel.INode>());
                    arrSeriesAtCell.add(oMySeries);
                }
                this.mergeSeries(oSeries, oMySeries);
            }
            modelAtCell.setSeries(arrSeriesAtCell);
        }
    }

    protected void fillCellModelData(SingleSeriesChartModel modelAtCommonCell, SingleSeriesChartModel modelAtCell) {
        AbstractNormalChartModel.AxisValueScope scope;
        this.mergeNormalChartModel(modelAtCommonCell, modelAtCell);
        List<AbstractNormalChartModel.AxisValueScope> scopes = modelAtCommonCell.getScopes();
        if (scopes != null && !scopes.isEmpty() && (scope = scopes.get(0)) != null) {
            modelAtCell.setValueScope(scope.getMin(), scope.getMax());
        }
    }

    protected void fillCellModelData(MultiSeriesChartModel modelAtCommonCell, MultiSeriesChartModel modelAtCell) {
        block5: {
            this.mergeNormalChartModel(modelAtCommonCell, modelAtCell);
            List<AbstractNormalChartModel.AxisValueScope> scopes = modelAtCommonCell.getScopes();
            if (scopes == null || scopes.size() <= 0) break block5;
            if (modelAtCell.getScopes() == null) {
                for (AbstractNormalChartModel.AxisValueScope scope : scopes) {
                    modelAtCell.addValueScope(scope.getMin(), scope.getMax());
                }
            } else {
                int len = scopes.size();
                List<AbstractNormalChartModel.AxisValueScope> scopesAtCell = modelAtCommonCell.getScopes();
                for (int i = 0; i < len; ++i) {
                    AbstractNormalChartModel.AxisValueScope oScope = scopes.get(i);
                    if (i < scopesAtCell.size()) {
                        AbstractNormalChartModel.AxisValueScope oMyScope = scopesAtCell.get(i);
                        oMyScope.setMin(oScope.getMin());
                        oMyScope.setMax(oScope.getMax());
                        continue;
                    }
                    modelAtCell.addValueScope(oScope.getMin(), oScope.getMax());
                }
            }
        }
    }

    public static class RectTreeChartConfigAdpter {
        private ChartConfig.RectTreeChartConfig config;

        public RectTreeChartConfigAdpter(ChartConfig.RectTreeChartConfig config) {
            this.config = config;
        }

        public boolean isHideNegative() {
            return this.config.isHideNegative();
        }
    }

    public static class PieChartConfigAdpter {
        private ChartConfig.PieChartConfig config;
        private int defaultLabelType = 2;

        public PieChartConfigAdpter(ChartConfig.PieChartConfig config) {
            this.config = config;
        }

        public int getTopN() {
            return this.config.getTopN();
        }

        public boolean isHideNegative() {
            return this.config.isHideNegative();
        }

        public int getLabelType() {
            return this.config.getLabelType() != null ? this.config.getLabelType() : this.defaultLabelType;
        }
    }

    public static class ChartConfigAdpter {
        private ChartConfig chartConfig;
        private boolean isLabelInBar = false;

        public ChartConfigAdpter(ChartConfig chartConfig) {
            this.chartConfig = chartConfig == null ? new ChartConfig() : chartConfig;
        }

        public boolean isShowLabel() {
            return this.chartConfig.isShowLabel();
        }

        public PieChartConfigAdpter getPieChartConfig() {
            return new PieChartConfigAdpter(this.chartConfig.getPieChartConfig() != null ? this.chartConfig.getPieChartConfig() : new ChartConfig.PieChartConfig());
        }

        public RectTreeChartConfigAdpter getRectTreeChartConfig() {
            return new RectTreeChartConfigAdpter(this.chartConfig.getRectTreeChartConfig() != null ? this.chartConfig.getRectTreeChartConfig() : new ChartConfig.RectTreeChartConfig());
        }

        public boolean isLabelInBar() {
            return this.isLabelInBar;
        }

        public void setLabelInBar(boolean isLabelInBar) {
            this.isLabelInBar = isLabelInBar;
        }
    }

    public static class CellRenderParameter {
        private ChartConfigAdpter chartConfigAdpter;
        private Object cellModel;
        private ICell commonCell;
        private Graphics jdkGraphics;
        private ExStyle cellStyle;
        private DrawInfo.Direction direction;

        public ChartConfigAdpter getChartConfig() {
            return this.chartConfigAdpter;
        }

        public void setChartConfig(ChartConfig chartConfig) {
            this.chartConfigAdpter = new ChartConfigAdpter(chartConfig);
        }

        public Object getCellModel() {
            return this.cellModel;
        }

        public void setCellModel(Object cellModel) {
            this.cellModel = cellModel;
        }

        public ICell getCommonCell() {
            return this.commonCell;
        }

        public void setCommonCell(ICell commonCell) {
            this.commonCell = commonCell;
        }

        public Graphics getJdkGraphics() {
            return this.jdkGraphics;
        }

        public void setJdkGraphics(Graphics jdkGraphics) {
            this.jdkGraphics = jdkGraphics;
        }

        public DrawInfo.Direction getDirection() {
            return this.direction;
        }

        public void setDirection(DrawInfo.Direction direction) {
            this.direction = direction;
        }

        public ExStyle getCellStyle() {
            return this.cellStyle;
        }

        public void setCellStyle(ExStyle cellStyle) {
            this.cellStyle = cellStyle;
        }
    }
}

