/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.export.chart.renderer.longer;

import com.kingdee.bos.qing.export.chart.model.TreeNodeCellAdapter;
import com.kingdee.bos.qing.export.chart.renderer.longer.CellRendererForTreeNode;
import com.kingdee.bos.qing.export.common.model.ExAlign;
import com.kingdee.bos.qing.export.common.model.ExStyle;
import java.awt.Color;
import java.awt.Graphics;

public class CellRendererForTreeNodeOfHorizontal
extends CellRendererForTreeNode {
    @Override
    protected void drawTree(Graphics g, TreeNodeCellAdapter cellModel, ExStyle cellStyle, int throughLinkCount, int cornerLinkCount) {
        int i;
        cellStyle.setHorizontalAlignment(ExAlign.CENTER);
        cellStyle.setVerticalAlignment(ExAlign.TOP);
        int x = cellStyle.getxOffset();
        int yMove = cellStyle.getyOffset() + 5 + 2;
        int width = cellStyle.getWidth();
        for (i = 0; i < throughLinkCount; ++i) {
            this.drawThroughLink(g, x, yMove, width);
            yMove += 11;
        }
        for (i = 0; i < cornerLinkCount; ++i) {
            this.drawCornerLink(g, x, yMove, width);
            yMove += 11;
        }
        if (cellModel.isLeaf()) {
            this.drawLeafButton(g, x + width / 2, yMove);
        } else if (cellModel.isExpanded()) {
            this.drawExpandedButton(g, x + width / 2, yMove, width);
        } else {
            this.drawCollapsedButton(g, x + width / 2, yMove);
        }
        if (cellModel.getText() != null && !cellModel.getText().isEmpty()) {
            cellStyle.setyOffset(yMove + 5 + 1);
            this.drawString(g, cellModel.getText().trim(), cellStyle);
        }
    }

    private void drawExpandedButton(Graphics g, int x, int y, int cellWidth) {
        g.setColor(lineColor);
        int padding = 2;
        int xEnd = x + cellWidth / 2;
        for (int xTail = x + 5; xTail < xEnd; xTail += 2) {
            g.drawLine(xTail, y, xTail, y);
        }
        g.setColor(buttonBgColor);
        g.fillRoundRect(x -= 5, y -= 5, 10, 10, 5, 5);
        g.setColor(lineColor);
        g.drawRoundRect(x, y, 10, 10, 5, 5);
        g.setColor(Color.black);
        int centerY = y + 5;
        g.drawLine(x + padding, centerY, x + 10 - padding, centerY);
    }

    private void drawThroughLink(Graphics g, int x, int y, int cellWidth) {
        g.setColor(lineColor);
        int xEnd = x + cellWidth;
        for (int xMove = x; xMove < xEnd; ++xMove) {
            g.drawLine(xMove, y, xMove, y);
            xMove += 2;
        }
    }

    private void drawCornerLink(Graphics g, int x, int y, int cellWidth) {
        int xMove;
        g.setColor(lineColor);
        int xEnd = x + cellWidth / 2;
        for (xMove = x; xMove < xEnd; ++xMove) {
            g.drawLine(xMove, y, xMove, y);
            xMove += 2;
        }
        int yMove = y;
        for (int i = 0; i < 3; ++i) {
            g.drawLine(xMove, yMove, xMove, yMove);
            yMove += 2;
        }
    }
}

