/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.export.image.util;

import java.awt.image.BufferedImage;

public class ImageScaleUtil {
    public static BufferedImage scalePng(BufferedImage im, float resizeTimes) {
        return ImageScaleUtil.scale(im, resizeTimes, 2);
    }

    public static BufferedImage scale(BufferedImage im, float resizeTimes, int imageType) {
        int width = im.getWidth();
        int height = im.getHeight();
        int toWidth = (int)(Float.parseFloat(String.valueOf(width)) * resizeTimes);
        int toHeight = (int)(Float.parseFloat(String.valueOf(height)) * resizeTimes);
        BufferedImage result = new BufferedImage(toWidth, toHeight, imageType);
        result.getGraphics().drawImage(im.getScaledInstance(toWidth, toHeight, 4), 0, 0, null);
        return result;
    }

    public static BufferedImage scalePng(BufferedImage im, int toWidth, int toHeight, boolean isClip) {
        return ImageScaleUtil.scale(im, toWidth, toHeight, 2, isClip);
    }

    public static BufferedImage scale(BufferedImage im, int toWidth, int imageType) {
        int width = im.getWidth();
        int height = im.getHeight();
        float resizeTimes = (float)toWidth / (float)width;
        int toHeight = (int)(Float.parseFloat(String.valueOf(height)) * resizeTimes);
        BufferedImage result = new BufferedImage(toWidth, toHeight, imageType);
        result.getGraphics().drawImage(im.getScaledInstance(toWidth, toHeight, 4), 0, 0, null);
        return result;
    }

    public static BufferedImage scale(BufferedImage im, int toWidth, int toHeight, int imageType, boolean isClip) {
        BufferedImage scaleIm = new BufferedImage(toWidth, toHeight, imageType);
        if (isClip) {
            int scaledHeight;
            int scaledWidth;
            int width = im.getWidth();
            int height = im.getHeight();
            float widthRatio = (float)width / (float)toWidth;
            float heightRatio = (float)height / (float)toHeight;
            int x = 0;
            int y = 0;
            if (widthRatio < 1.0f && heightRatio > 1.0f) {
                scaledWidth = (int)((float)width / heightRatio);
                scaledHeight = toHeight;
                x = toWidth - scaledWidth >> 1;
                y = 0;
            } else if (widthRatio > 1.0f && heightRatio < 1.0f) {
                scaledWidth = toWidth;
                scaledHeight = (int)((float)height / widthRatio);
                x = 0;
                y = toHeight - scaledHeight >> 1;
            } else if (widthRatio > heightRatio) {
                scaledWidth = (int)((float)width / heightRatio);
                scaledHeight = toHeight;
            } else {
                scaledWidth = toWidth;
                scaledHeight = (int)((float)height / widthRatio);
            }
            scaleIm.getGraphics().drawImage(im.getScaledInstance(scaledWidth, scaledHeight, 4), x, y, null);
        } else {
            scaleIm.getGraphics().drawImage(im.getScaledInstance(toWidth, toHeight, 4), 0, 0, null);
        }
        return scaleIm;
    }
}

