/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.export.pdf;

import com.kingdee.bos.qing.export.common.exception.ExportFontException;
import com.kingdee.bos.qing.util.CloseUtil;
import com.kingdee.bos.qing.util.IOUtil;
import com.kingdee.bos.qing.util.LogUtil;
import com.lowagie.text.DocumentException;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.FontMapper;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.GraphicsEnvironment;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Locale;

public class ExFontMapper
implements FontMapper {
    private static final String DEFAULT_FONT_NAME = "Microsoft YaHei";
    private static final String DEFAULT_FONT_PATH = "/com/kingdee/bos/qing/export/fonts/msyh.ttf";
    private static final int DEFAULT_FONT_SIZE = 12;
    private BaseFont baseFont;
    private HashMap<String, String> aliases = new HashMap();
    private HashMap<String, BaseFontParameters> mapper = new HashMap();
    private boolean isLoggedFontErrorMsg;

    public ExFontMapper() {
        this.loadPresetFontInfo();
        this.loadEmbedFont();
        this.registerEmbedFont();
        LogUtil.info((String)("ExFontMapper.aliases=" + this.aliases.toString()));
        LogUtil.info((String)("ExFontMapper.mapper=" + this.mapper.toString()));
        String configFontName = System.getProperty("qingFontsName");
        this.baseFont = configFontName != null ? this.createBaseFont(configFontName) : this.createDefaultBaseFont();
    }

    private void loadPresetFontInfo() {
        String prop = ExFontMapper.getQingFontsDir();
        if (prop != null) {
            this.insertDirectory(prop);
        }
    }

    private void loadEmbedFont() {
        this.insertFont(DEFAULT_FONT_NAME, this.getClass().getResource(DEFAULT_FONT_PATH).toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerEmbedFont() {
        InputStream is = null;
        FileOutputStream out = null;
        try {
            is = this.getClass().getResourceAsStream(DEFAULT_FONT_PATH);
            String filePath = System.getProperty("java.io.tmpdir") + File.separator + "msyh.ttf";
            File file = new File(filePath);
            if (!file.exists()) {
                try {
                    out = new FileOutputStream(filePath);
                    IOUtil.copy((InputStream)is, (OutputStream)out);
                }
                catch (FileNotFoundException e) {
                    LogUtil.error((String)e.getMessage(), (Throwable)e);
                }
                catch (IOException e) {
                    LogUtil.error((String)e.getMessage(), (Throwable)e);
                }
            }
            ExFontMapper.registerCustomeFont(0, file);
        }
        catch (Throwable throwable) {
            CloseUtil.close((Closeable[])new Closeable[]{is});
            CloseUtil.close((Closeable[])new Closeable[]{out});
            throw throwable;
        }
        CloseUtil.close((Closeable[])new Closeable[]{is});
        CloseUtil.close((Closeable[])new Closeable[]{out});
    }

    private boolean insertFont(String name, String fontURL) {
        name = name.toLowerCase(Locale.ENGLISH);
        try {
            if (!name.contains(".") || name.endsWith(".ttf") || name.endsWith(".otf") || name.endsWith(".afm")) {
                String[][] names = BaseFont.getFullFontName((String)fontURL, (String)"Cp1252", null);
                this.insertNames(names, fontURL);
            } else if (name.endsWith(".ttc")) {
                String[] ttcs = BaseFont.enumerateTTCNames((String)fontURL);
                for (int j = 0; j < ttcs.length; ++j) {
                    String nt = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(fontURL))).append(",").append(j)));
                    String[][] names = BaseFont.getFullFontName((String)nt, (String)"Cp1252", null);
                    this.insertNames(names, nt);
                }
            }
            return true;
        }
        catch (Exception e) {
            LogUtil.error((String)e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public Font getAwtFontByName(String fontName) throws ExportFontException {
        BaseFontParameters p = this.getBaseFontParameters(fontName);
        if (p == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("qing-\u6ca1\u6709\u627e\u5230").append(fontName).append("\u5b57\u4f53\uff0c\u4f7f\u7528\u9ed8\u8ba4\u5b57\u4f53").append(DEFAULT_FONT_NAME).append("\u4ee3\u66ff\u3002");
            LogUtil.info((String)sb.toString());
            return this.getDefaultFont();
        }
        BaseFont baseFont = null;
        try {
            baseFont = BaseFont.createFont((String)p.fontName, (String)p.encoding, (boolean)p.embedded, (boolean)p.cached, (byte[])p.ttfAfm, (byte[])p.pfb);
            LogUtil.info((String)p.toString());
            LogUtil.info((String)("qing-\u5f53\u524d\u4f7f\u7528\u5b57\u4f53\u4e3a\uff1a" + p.fontName));
        }
        catch (DocumentException e) {
            throw new ExportFontException((Throwable)e, "Init " + p.fontName + " occurs an DocumentException.");
        }
        catch (IOException e) {
            throw new ExportFontException((Throwable)e, "Init " + p.fontName + " occurs an IOException.");
        }
        return this.pdfToAwt(baseFont, 12);
    }

    private Font getDefaultFont() {
        return this.pdfToAwt(this.baseFont, 12);
    }

    private BaseFont createDefaultBaseFont() {
        return this.createBaseFont(DEFAULT_FONT_PATH);
    }

    private BaseFont createBaseFont(String fontName) {
        return this.awtToPdf(new Font(fontName, 0, 12));
    }

    public BaseFont awtToPdf(Font font) {
        try {
            int style;
            BaseFontParameters p = this.getBaseFontParameters(font.getFontName());
            if (p == null && (style = font.getStyle()) != 0) {
                String styledName = font.getFontName();
                if ((style & 1) != 0) {
                    styledName = String.valueOf(String.valueOf(styledName)).concat(" Bold");
                }
                if ((style & 2) != 0) {
                    styledName = String.valueOf(String.valueOf(styledName)).concat(" Italic");
                }
                p = this.getBaseFontParameters(styledName);
            }
            if (p == null) {
                p = this.getBaseFontParameters(DEFAULT_FONT_NAME);
            }
            if (p == null) {
                if (this.baseFont != null) {
                    return this.baseFont;
                }
                if (!this.isLoggedFontErrorMsg) {
                    this.isLoggedFontErrorMsg = true;
                    String msg = String.valueOf(String.valueOf(new StringBuffer("Can't find any font named [").append(font.getName()).append("] installed in your system, default font is not Available too.")));
                    LogUtil.info((String)msg);
                }
                return BaseFont.createFont();
            }
            BaseFont basefont = BaseFont.createFont((String)p.fontName, (String)p.encoding, (boolean)p.embedded, (boolean)p.cached, (byte[])p.ttfAfm, (byte[])p.pfb);
            return basefont;
        }
        catch (Exception e) {
            if (this.baseFont != null) {
                return this.baseFont;
            }
            try {
                return BaseFont.createFont();
            }
            catch (Exception e1) {
                throw new ExceptionConverter(e1);
            }
        }
    }

    private BaseFontParameters getBaseFontParameters(String name) {
        String alias = this.aliases.get(name);
        if (alias == null) {
            return this.mapper.get(name);
        }
        BaseFontParameters p = this.mapper.get(alias);
        if (p == null) {
            return this.mapper.get(name);
        }
        return p;
    }

    private void insertNames(String[][] names, String path) {
        String main = null;
        for (int k = 0; k < names.length; ++k) {
            String[] name = names[k];
            if (!name[2].equals("1033")) continue;
            main = name[3];
            break;
        }
        if (main == null) {
            main = names[0][3];
        }
        BaseFontParameters p = new BaseFontParameters(path);
        this.mapper.put(main, p);
        for (int k = 0; k < names.length; ++k) {
            this.aliases.put(names[k][3], main);
        }
    }

    private int insertDirectory(String dir) {
        File file = new File(dir);
        if (!file.exists() || !file.isDirectory()) {
            return 0;
        }
        File[] files = file.listFiles();
        int count = 0;
        for (int k = 0; k < files.length; ++k) {
            file = files[k];
            boolean insertResult = this.insertFont(file.toString(), file.toString());
            if (!insertResult) continue;
            ++count;
        }
        return count;
    }

    public Font pdfToAwt(BaseFont font, int size) {
        String finalName;
        String[][] names = font.getFullFontName();
        if (names.length == 1) {
            return new Font(names[0][3], 0, size);
        }
        String name10 = null;
        String name3x = null;
        for (int k = 0; k < names.length; ++k) {
            String[] name = names[k];
            if (name[0].equals("1") && name[1].equals("0")) {
                name10 = name[3];
                continue;
            }
            if (!name[2].equals("1033")) continue;
            name3x = name[3];
            break;
        }
        if ((finalName = name3x) == null) {
            finalName = name10;
        }
        if (finalName == null) {
            finalName = names[0][3];
        }
        return new Font(finalName, 0, size);
    }

    public void setLoggedFontErrorMsg(boolean isLoggedFontErrorMsg) {
        this.isLoggedFontErrorMsg = isLoggedFontErrorMsg;
    }

    public static String getDefaultFontName() {
        return DEFAULT_FONT_NAME;
    }

    public static int getDefaultFontSizeOfPx() {
        return 12;
    }

    private static String getQingFontsDir() {
        String path = System.getProperty("qingFontsDir");
        if (path == null) {
            LogUtil.info((String)"Warnning! 'qingFontsDir' is not configured! Going to use default font Microsoft YaHei");
            return null;
        }
        if (!path.endsWith("/") && !path.endsWith("\\")) {
            path = path + File.separator;
        }
        LogUtil.info((String)("qingFontsDir=" + path));
        return path;
    }

    private static Font registerCustomeFont(int fontFormat, File file) {
        Font font = null;
        try {
            font = Font.createFont(0, file);
            font.deriveFont(0, 12.0f);
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            boolean register = ge.registerFont(font);
            if (register) {
                LogUtil.info((String)"\u6ce8\u518c\u5185\u5d4c\u5b57\u4f53\u6210\u529f\u3002");
            } else {
                LogUtil.info((String)"\u6ce8\u518c\u5185\u5d4c\u5b57\u4f53\u5931\u8d25\u3002");
            }
        }
        catch (FontFormatException e) {
            LogUtil.error((String)("\u5b57\u4f53\u683c\u5f0f\u5316\u5f02\u5e38\u3002" + e.getMessage()), (Throwable)e);
        }
        catch (IOException e) {
            LogUtil.error((String)("\u8bfb\u5199\u5b57\u4f53\u6587\u4ef6\u5f02\u5e38\u3002" + e.getMessage()), (Throwable)e);
        }
        return font;
    }

    private static class BaseFontParameters {
        private String fontName;
        private String encoding;
        private boolean embedded;
        private boolean cached;
        private byte[] ttfAfm;
        private byte[] pfb;

        public BaseFontParameters(String fontName) {
            this.fontName = fontName;
            this.encoding = "Identity-H";
            this.embedded = true;
            this.cached = true;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("{");
            sb.append("fontName=").append(this.fontName);
            sb.append(", encoding=").append(this.encoding);
            sb.append(", embedded=").append(this.embedded);
            sb.append(", cached=").append(this.cached);
            sb.append("}");
            return sb.toString();
        }
    }
}

