/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.export.pdf;

import com.kingdee.bos.qing.export.common.model.IExportAdapter;
import com.kingdee.bos.qing.export.common.model.RowColRange;
import com.kingdee.bos.qing.export.common.util.UnitUtil;
import com.kingdee.bos.qing.export.pdf.TableViewExportJob;
import com.kingdee.bos.qing.export.pdf.model.DimensionFloat;
import com.kingdee.bos.qing.export.pdf.model.SetupModel;
import com.kingdee.bos.qing.util.LogUtil;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TableViewExportPagination {
    private SetupModel model;
    private IExportAdapter tableAdapter;
    private Map<Integer, List<RowColRange>> mapPageScope;
    private float lastHeight;
    private float lastWidth;
    private float topHeadHeight;
    private float leftHeadWith;
    private boolean isLegendInOneCol;
    private boolean isLegendInOnePage;
    private int legendNumber;
    private float legendWidthPT;

    public TableViewExportPagination(SetupModel model, IExportAdapter tableAdapter) {
        this.model = model;
        this.tableAdapter = tableAdapter;
        this.mapPageScope = new HashMap<Integer, List<RowColRange>>();
        this.legendNumber = tableAdapter.getLegendNumber();
        if (this.legendNumber > 0) {
            this.legendWidthPT = UnitUtil.pixelToPt(tableAdapter.getLegendWidth());
        }
    }

    public int pageCount() {
        boolean hasNext;
        int maxRow = this.tableAdapter.getRowCount();
        int maxCol = this.tableAdapter.getColCount();
        if (maxRow <= 0 || maxCol <= 0) {
            return -1;
        }
        int thePageCount = 0;
        DimensionFloat rect = this.createContentRect();
        while (hasNext = this.calcNextPage(rect, thePageCount)) {
            if (!this.mapPageScope.containsKey(thePageCount)) continue;
            ++thePageCount;
        }
        float pageWidth = rect.getWidth() / this.model.getScaleModel().getScale();
        float pageHeight = rect.getHeight() / this.model.getScaleModel().getScale();
        this.decideLegendPosition(pageWidth, pageHeight);
        if (this.isLegendInOnePage) {
            ++thePageCount;
        }
        return thePageCount;
    }

    private void decideLegendPosition(float pageWidth, float pageHeight) {
        if (this.legendNumber < 1) {
            return;
        }
        if (this.model.getScaleModel().isAutoFit()) {
            this.isLegendInOnePage = false;
            switch (this.model.getLegendAlign()) {
                case RIGHT_VERTICAL: {
                    this.isLegendInOneCol = true;
                    break;
                }
                case BOTTOM_HORIZONTAL: {
                    this.isLegendInOneCol = false;
                    break;
                }
                case BOTTOM_VERTICAL: {
                    this.isLegendInOneCol = true;
                    break;
                }
                case RIGHT_HORIZONTAL: {
                    this.isLegendInOneCol = false;
                    break;
                }
                default: {
                    this.isLegendInOneCol = true;
                }
            }
            return;
        }
        float legendGap = UnitUtil.pixelToPt(this.tableAdapter.getLegendGap());
        float allLegendHeight = UnitUtil.pixelToPt(this.tableAdapter.getVerticalLegendHeight());
        if (pageHeight > allLegendHeight) {
            this.isLegendInOneCol = true;
            this.isLegendInOnePage = this.lastWidth + this.legendWidthPT + legendGap > pageWidth;
        } else {
            this.isLegendInOneCol = false;
            this.isLegendInOnePage = (this.legendWidthPT + legendGap) * (float)this.legendNumber + this.lastWidth > pageWidth;
        }
    }

    private boolean calcNextPage(DimensionFloat rect, int thePageIndex) {
        int maxRow = this.tableAdapter.getRowCount() - 1;
        int maxCol = this.tableAdapter.getColCount() - 1;
        List<RowColRange> pageRanges = null;
        RowColRange pageRange = new RowColRange();
        if (thePageIndex > 0) {
            RowColRange lastPage = null;
            pageRanges = this.mapPageScope.get(thePageIndex - 1);
            if (pageRanges != null && pageRanges.size() > 0 && (lastPage = pageRanges.get(pageRanges.size() - 1)).getToRow() >= maxRow && lastPage.getToCol() >= maxCol) {
                return false;
            }
            this.handleRowColFirst(lastPage, pageRange, maxRow, maxCol);
        }
        int fromRow = pageRange.getFromRow();
        int fromCol = pageRange.getFromCol();
        float pageHeight = rect.getHeight() / this.model.getScaleModel().getScale();
        float pageWidth = rect.getWidth() / this.model.getScaleModel().getScale();
        if (this.topHeadHeight == 0.0f) {
            this.topHeadHeight = TableViewExportPagination.handleTopHeadAll(this.tableAdapter, pageHeight, fromRow);
        }
        if (this.leftHeadWith == 0.0f) {
            this.leftHeadWith = TableViewExportPagination.handleLeftHeadAll(this.tableAdapter, pageWidth, fromCol);
        }
        float lastRemainH = pageHeight - this.lastHeight;
        int toRow = this.calcRowColumnIndex(this.topHeadHeight, pageHeight, fromRow, true, maxRow);
        pageRange.setToRow(toRow);
        float lastRemainW = pageWidth - this.lastWidth;
        int toCol = this.calcRowColumnIndex(this.leftHeadWith, pageWidth, fromCol, false, maxCol);
        pageRange.setToCol(toCol);
        if (pageRanges != null) {
            if (this.model.isVFrugal()) {
                if (lastRemainH >= this.lastHeight + 5.0f) {
                    this.lastHeight = pageHeight - lastRemainH + 5.0f + this.lastHeight + 5.0f;
                    pageRanges.add(pageRange);
                    return true;
                }
            } else if (this.model.isHFrugal() && lastRemainW >= this.lastWidth + 5.0f) {
                this.lastWidth = pageWidth - lastRemainW + 5.0f + (this.lastWidth + 5.0f);
                pageRanges.add(pageRange);
                return true;
            }
        }
        ArrayList<RowColRange> listPages = new ArrayList<RowColRange>();
        listPages.add(pageRange);
        this.mapPageScope.put(thePageIndex, listPages);
        return true;
    }

    private void handleRowColFirst(RowColRange lastPage, RowColRange pageRange, int maxRow, int maxCol) {
        if (lastPage == null) {
            return;
        }
        if (this.tableAdapter.isRowFirst()) {
            if (lastPage.getToCol() >= maxCol) {
                pageRange.setFromCol(0);
                pageRange.setFromRow(lastPage.getToRow() + 1);
            } else {
                pageRange.setFromRow(lastPage.getFromRow());
                pageRange.setFromCol(lastPage.getToCol() + 1);
            }
        } else if (lastPage.getToRow() >= maxRow) {
            pageRange.setFromRow(0);
            pageRange.setFromCol(lastPage.getToCol() + 1);
        } else {
            pageRange.setFromRow(lastPage.getToRow() + 1);
            pageRange.setFromCol(lastPage.getFromCol());
        }
    }

    private int calcRowColumnIndex(float headWidthHeight, float scope, int startPosition, boolean isRow, int maxIndex) {
        float tempAll = 0.0f;
        float tempOne = 0.0f;
        if (isRow && this.tableAdapter.isTopHeaderAll() && startPosition >= this.tableAdapter.getTopHeadRowCount() || !isRow && this.tableAdapter.isLeftHeaderAll() && startPosition >= this.tableAdapter.getLeftHeadColCount()) {
            tempAll = headWidthHeight;
        }
        while (true) {
            if (startPosition > maxIndex) {
                --startPosition;
                if (isRow) {
                    this.lastHeight = tempAll;
                    break;
                }
                this.lastWidth = tempAll;
                break;
            }
            tempOne = this.getRowHeightOrColumnWidth(startPosition, isRow);
            if (tempAll == 0.0f && tempOne > scope) {
                if (isRow) {
                    this.lastHeight = scope;
                    break;
                }
                this.lastWidth = scope;
                break;
            }
            if ((tempAll += tempOne) > scope) {
                --startPosition;
                if (isRow) {
                    this.lastHeight = tempAll - tempOne;
                    break;
                }
                this.lastWidth = tempAll - tempOne;
                break;
            }
            ++startPosition;
        }
        return startPosition;
    }

    public static float handleTopHeadAll(IExportAdapter tableAdapter, float scope, int fromRow) {
        float headHeight = 0.0f;
        if (tableAdapter.isTopHeaderAll() && fromRow >= tableAdapter.getTopHeadRowCount()) {
            int topHeadHeightPix = 0;
            int topHeadCount = tableAdapter.getTopHeadRowCount();
            for (int i = 0; i < topHeadCount; ++i) {
                topHeadHeightPix += tableAdapter.getRowHeight(i);
            }
            float topHeadHeight = UnitUtil.pixelToPt(topHeadHeightPix);
            float rowHeight = UnitUtil.pixelToPt(tableAdapter.getRowHeight(topHeadCount));
            if (topHeadHeight > 0.0f && topHeadHeight + rowHeight <= scope) {
                headHeight = topHeadHeight;
            } else {
                tableAdapter.setTopHeaderAll(false);
                LogUtil.info((String)"The header height exceeds the page height, automatically cancel the page header to follow");
            }
        }
        return headHeight;
    }

    public static float handleLeftHeadAll(IExportAdapter tableAdapter, float scope, int fromCol) {
        float headWidth = 0.0f;
        if (tableAdapter.isLeftHeaderAll() && fromCol >= tableAdapter.getLeftHeadColCount()) {
            int letfHeadWidthPix = 0;
            int leftHeadCount = tableAdapter.getLeftHeadColCount();
            for (int i = 0; i < leftHeadCount; ++i) {
                letfHeadWidthPix += tableAdapter.getColWidth(i);
            }
            float leftHeadWidth = UnitUtil.pixelToPt(letfHeadWidthPix);
            float colWidth = UnitUtil.pixelToPt(tableAdapter.getColWidth(leftHeadCount));
            if (leftHeadWidth > 0.0f && leftHeadWidth + colWidth <= scope) {
                headWidth = leftHeadWidth;
            } else {
                tableAdapter.setLeftHeaderAll(false);
                LogUtil.info((String)"The header width exceeds the page width, automatically cancel the page header to follow");
            }
        }
        return headWidth;
    }

    private float getRowHeightOrColumnWidth(int index, boolean isRow) {
        if (isRow) {
            int h = this.tableAdapter.getRowHeight(index);
            if (h < 0) {
                h = 0;
            }
            return UnitUtil.pixelToPt(h);
        }
        int w = this.tableAdapter.getColWidth(index);
        if (w < 0) {
            w = 0;
        }
        return UnitUtil.pixelToPt(w);
    }

    private DimensionFloat createContentRect() {
        Rectangle2D.Float rect = TableViewExportJob.createBodyRect(this.model);
        return new DimensionFloat(rect.width, rect.height);
    }

    public Map<Integer, List<RowColRange>> getMapPagescope() {
        return this.mapPageScope;
    }

    public void removePageScope(int index) {
        this.mapPageScope.remove(index);
    }

    public boolean isLegendInOnePage() {
        return this.isLegendInOnePage;
    }

    public boolean isLegendInOneCol() {
        return this.isLegendInOneCol;
    }
}

