/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.handler.impl;

import com.kingdee.bos.qing.data.domain.handler.DataHandler;
import com.kingdee.bos.qing.data.domain.unionsource.EntityExtractContext;
import com.kingdee.bos.qing.data.model.designtime.ColumnToRowProperty;
import com.kingdee.bos.qing.data.model.designtime.ColumnToRowPropertyItem;
import com.kingdee.bos.qing.data.model.designtime.DesigningDataType;
import com.kingdee.bos.qing.data.model.designtime.Property;
import com.kingdee.bos.qing.data.model.runtime.RuntimeEntity;
import com.kingdee.bos.qing.util.CollectionUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class ColumnToRowDataHandler
implements DataHandler {
    @Override
    public List<Map<String, Object>> columnToRow(Map<String, Object> rowMap, RuntimeEntity runtimeEntity) {
        List<ColumnToRowProperty> unionColumnToRowProperties;
        EntityExtractContext entityExtractContext;
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        List<ColumnToRowProperty> columnToRowProperties = runtimeEntity.getOrinalEntity().getColumnToRowProperties();
        ArrayList<Map<String, Object>> inputListMap = new ArrayList<Map<String, Object>>();
        inputListMap.add(rowMap);
        boolean isNotExistsColumnToRow = true;
        if (CollectionUtils.isNotEmpty(columnToRowProperties)) {
            isNotExistsColumnToRow = false;
            for (ColumnToRowProperty columnToRowProperty : columnToRowProperties) {
                this.doColumnToRow(columnToRowProperty, inputListMap, resultList);
            }
        }
        if ((entityExtractContext = runtimeEntity.getEntityExtractContext()) != null && CollectionUtils.isNotEmpty(unionColumnToRowProperties = entityExtractContext.getColumnToRowProperties())) {
            isNotExistsColumnToRow = false;
            for (ColumnToRowProperty columnToRowProperty : unionColumnToRowProperties) {
                this.doColumnToRow(columnToRowProperty, inputListMap, resultList);
            }
        }
        if (isNotExistsColumnToRow) {
            resultList.add(rowMap);
        }
        return resultList;
    }

    private void doColumnToRow(ColumnToRowProperty columnToRowProperty, List<Map<String, Object>> inputListMap, List<Map<String, Object>> resultList) {
        resultList.clear();
        ArrayList columnToRowResultList = new ArrayList(10);
        HashSet<String> columnToRowFieldValueNames = new HashSet<String>(16);
        for (Map<String, Object> rowMap : inputListMap) {
            columnToRowResultList.clear();
            columnToRowFieldValueNames.clear();
            Property fieldNameProperty = columnToRowProperty.getFieldNameProperty();
            List<ColumnToRowPropertyItem> columnToRowPropertyItems = columnToRowProperty.getColumnToRowPropertyItems();
            List<Property> fieldValueProperties = columnToRowProperty.getFieldValueProperties();
            for (ColumnToRowPropertyItem columnToRowPropertyItem : columnToRowPropertyItems) {
                HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
                String fieldName = columnToRowPropertyItem.getFieldName();
                resultMap.put(fieldNameProperty.getName(), fieldName);
                List<String> propertyValues = columnToRowPropertyItem.getPropertyValues();
                for (int i = 0; i < propertyValues.size(); ++i) {
                    String propertyValue = propertyValues.get(i);
                    Object value = rowMap.get(propertyValue);
                    DesigningDataType valueDataType = fieldValueProperties.get(i).getDataType();
                    if (value != null && DesigningDataType.STRING == valueDataType) {
                        value = String.valueOf(value);
                    }
                    resultMap.put(fieldValueProperties.get(i).getName(), value);
                    columnToRowFieldValueNames.add(propertyValue);
                }
                columnToRowResultList.add(resultMap);
            }
            for (Map map : columnToRowResultList) {
                for (Map.Entry<String, Object> entry : rowMap.entrySet()) {
                    String propertyName = entry.getKey();
                    if (propertyName.equals(fieldNameProperty.getName()) || columnToRowFieldValueNames.contains(propertyName)) continue;
                    map.put(propertyName, entry.getValue());
                }
            }
            resultList.addAll(columnToRowResultList);
        }
        inputListMap.clear();
        inputListMap.addAll(resultList);
    }
}

