/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.source.api;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.data.domain.source.AbstractDataSourceDomain;
import com.kingdee.bos.qing.data.domain.source.api.ProgramDataSetSourceDomain;
import com.kingdee.bos.qing.data.domain.source.api.RESTfulDataSetSourceDomain;
import com.kingdee.bos.qing.data.domain.source.api.utils.OpenAPIUtil;
import com.kingdee.bos.qing.data.exception.AbstractSourceException;
import com.kingdee.bos.qing.data.exception.UnSupportDataSourceException;
import com.kingdee.bos.qing.data.exception.api.OpenAPIException;
import com.kingdee.bos.qing.data.model.designtime.AbstractSource;
import com.kingdee.bos.qing.data.model.designtime.ColumnToRowProperty;
import com.kingdee.bos.qing.data.model.designtime.Entity;
import com.kingdee.bos.qing.data.model.designtime.EntityErrorState;
import com.kingdee.bos.qing.data.model.designtime.source.OpenAPISource;
import com.kingdee.bos.qing.data.model.runtime.IRuntimeFilter;
import com.kingdee.bos.qing.data.model.runtime.RuntimeEntity;
import com.kingdee.bos.qing.data.model.runtime.RuntimeFilterUtil;
import com.kingdee.bos.qing.data.model.runtime.RuntimeProperty;
import com.kingdee.bos.qing.util.CollectionUtils;
import com.kingdee.bos.qing.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractOpenAPISourceDomain
extends AbstractDataSourceDomain {
    public static AbstractOpenAPISourceDomain newInstance(AbstractSource source) throws UnSupportDataSourceException {
        OpenAPISource openAPISource = (OpenAPISource)source;
        OpenAPISource.OpenAPIType openAPIType = openAPISource.getOpenAPIType();
        switch (openAPIType) {
            case RESTFUL_DATA_SET: {
                return RESTfulDataSetSourceDomain.newInstance();
            }
            case PROGRAM_DATA_SET: {
                return ProgramDataSetSourceDomain.newInstance();
            }
        }
        throw new UnSupportDataSourceException("unsupport openAPIType:" + openAPIType);
    }

    public abstract String openAPIInitialCheck(QingContext var1, AbstractSource var2) throws OpenAPIException;

    @Override
    public void checkSourceLegality(QingContext qingContext, AbstractSource source, List<Entity> entityArrayList, AbstractDataSourceDomain domain) {
        block2: {
            try {
                this.openAPIInitialCheck(qingContext, source);
            }
            catch (OpenAPIException e) {
                if (entityArrayList == null || entityArrayList.isEmpty()) break block2;
                this.setEntityErrorState(qingContext, entityArrayList, EntityErrorState.OPENAPINOTEXIST);
            }
        }
    }

    @Override
    protected boolean isDataFieldUnique(QingContext qingContext, RuntimeEntity runtimeEntity, RuntimeProperty fieldName) throws AbstractSourceException, AbstractQingIntegratedException {
        return true;
    }

    protected OpenAPIRuntimeInfo initRuntimeParams(RuntimeEntity runtimeEntity) {
        IRuntimeFilter runtimeFilter;
        OpenAPIRuntimeInfo openAPIRuntimeInfo = new OpenAPIRuntimeInfo();
        RuntimeFilterUtil.Prediction prediction = this.initRuntimeFilter(runtimeEntity);
        if (prediction.isAlwaysFalse()) {
            return null;
        }
        openAPIRuntimeInfo.runtimeFilter = runtimeFilter = runtimeEntity.getPushdownableFilter();
        return openAPIRuntimeInfo;
    }

    protected Map<String, Object> innerExcuteFilterParam(OpenAPIRuntimeInfo runtimeInfo, Map<String, Object> oneRowMap) {
        if (runtimeInfo.runtimeFilter != null && !runtimeInfo.runtimeFilter.isInvalid()) {
            if (runtimeInfo.runtimeFilter.innerExcuteFilterWtihRawValue(oneRowMap)) {
                return oneRowMap;
            }
            return null;
        }
        return oneRowMap;
    }

    protected Map<String, Object> getPriDataOneRowMap(Object[] objArr, RuntimeEntity runtimeEntity) throws OpenAPIException {
        List<RuntimeProperty> runtimePropertyList = runtimeEntity.getSelectedPriProperties();
        List<String> columnToRowPropertyNameList = AbstractOpenAPISourceDomain.collectColumnToRowPropertyName(runtimeEntity);
        ArrayList<RuntimeProperty> runtimePropertyExcludeCloToRowList = new ArrayList<RuntimeProperty>(10);
        for (RuntimeProperty runtimeProperty : runtimePropertyList) {
            if (columnToRowPropertyNameList.contains(runtimeProperty.getProperty().getAssociateName()) || runtimeProperty.getProperty().isNotExisted()) continue;
            runtimePropertyExcludeCloToRowList.add(runtimeProperty);
        }
        HashMap<String, Object> innerData = new HashMap<String, Object>(runtimePropertyList.size());
        for (int i = 0; i < runtimePropertyExcludeCloToRowList.size(); ++i) {
            RuntimeProperty runtimeProperty = (RuntimeProperty)runtimePropertyExcludeCloToRowList.get(i);
            String propertyName = runtimeProperty.getName();
            Object value = null;
            Object obj = objArr[i];
            if (obj != null && StringUtils.isNotBlank((CharSequence)obj.toString())) {
                try {
                    switch (runtimeProperty.getInputDataType()) {
                        case BOOLEAN: {
                            value = Boolean.parseBoolean(obj.toString());
                            break;
                        }
                        case INT: {
                            Double d = Double.parseDouble(obj.toString());
                            value = d.longValue();
                            break;
                        }
                        case NUMBER: {
                            value = new BigDecimal(obj.toString());
                            break;
                        }
                        case DATE: {
                            Date date = OpenAPIUtil.parseDate(obj.toString());
                            Calendar calendarDate = Calendar.getInstance();
                            calendarDate.setTime(date);
                            value = calendarDate;
                            break;
                        }
                        case DATETIME: {
                            Date dateTime = OpenAPIUtil.parseDateTime(obj.toString());
                            Calendar calendarDateTime = Calendar.getInstance();
                            calendarDateTime.setTime(dateTime);
                            value = calendarDateTime;
                            break;
                        }
                        default: {
                            value = obj.toString();
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    value = null;
                    StringBuilder errorMessage = new StringBuilder();
                    errorMessage.append(2061102).append("parse data error: field:").append(propertyName).append("; value:").append(obj).append("; fieldType:").append(runtimeProperty.getInputDataType());
                    throw new OpenAPIException(errorMessage.toString());
                }
            }
            innerData.put(runtimeProperty.getName(), value);
        }
        return innerData;
    }

    protected static String getSelectedFields(RuntimeEntity runtimeEntity) {
        List<String> columnToRowPropertyNameList = AbstractOpenAPISourceDomain.collectColumnToRowPropertyName(runtimeEntity);
        StringBuilder selectedFields = new StringBuilder();
        for (RuntimeProperty runtimeProperty : runtimeEntity.getSelectedPriProperties()) {
            if (columnToRowPropertyNameList.contains(runtimeProperty.getProperty().getAssociateName()) || runtimeProperty.getProperty().isNotExisted()) continue;
            selectedFields.append(runtimeProperty.getAssociateName()).append(",");
        }
        return StringUtils.isEmpty((CharSequence)selectedFields) ? "" : selectedFields.substring(0, selectedFields.length() - 1);
    }

    private static List<String> collectColumnToRowPropertyName(RuntimeEntity runtimeEntity) {
        ArrayList<String> columnToRowPropertyNameList = new ArrayList<String>(6);
        List<ColumnToRowProperty> columnToRowProperties = runtimeEntity.getOrinalEntity().getColumnToRowProperties();
        if (CollectionUtils.isNotEmpty(columnToRowProperties)) {
            for (ColumnToRowProperty columnToRowProperty : columnToRowProperties) {
                columnToRowPropertyNameList.add(columnToRowProperty.getFieldNameProperty().getName());
                columnToRowPropertyNameList.addAll(columnToRowProperty.getFieldValueNames());
            }
        }
        return columnToRowPropertyNameList;
    }

    protected static class OpenAPIRuntimeInfo {
        public IRuntimeFilter runtimeFilter;

        protected OpenAPIRuntimeInfo() {
        }
    }
}

