/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.source.api;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.i18n.Messages;
import com.kingdee.bos.qing.common.trace.TraceSpan;
import com.kingdee.bos.qing.common.trace.TracerUtil;
import com.kingdee.bos.qing.data.domain.handler.impl.ColumnToRowDataHandler;
import com.kingdee.bos.qing.data.domain.source.api.AbstractOpenAPISourceDomain;
import com.kingdee.bos.qing.data.domain.source.api.ITableDataProvider;
import com.kingdee.bos.qing.data.domain.source.api.constant.OpenAPIConstant;
import com.kingdee.bos.qing.data.domain.source.api.parser.ProgramDataSetResultParseTool;
import com.kingdee.bos.qing.data.domain.source.api.utils.OpenAPIUtil;
import com.kingdee.bos.qing.data.exception.AbstractSourceException;
import com.kingdee.bos.qing.data.exception.api.OpenAPIException;
import com.kingdee.bos.qing.data.model.designtime.AbstractSource;
import com.kingdee.bos.qing.data.model.designtime.ColumnToRowProperty;
import com.kingdee.bos.qing.data.model.designtime.source.OpenAPISource;
import com.kingdee.bos.qing.data.model.runtime.IRuntimeFilter;
import com.kingdee.bos.qing.data.model.runtime.ProgressProcessor;
import com.kingdee.bos.qing.data.model.runtime.RuntimeEntity;
import com.kingdee.bos.qing.data.model.runtime.api.APITable;
import com.kingdee.bos.qing.data.model.vo.AbstractNode;
import com.kingdee.bos.qing.data.model.vo.DesigntimeDataObject;
import com.kingdee.bos.qing.data.model.vo.PreviewDataModel;
import com.kingdee.bos.qing.datasource.exception.DataSourcePersistenceException;
import com.kingdee.bos.qing.datasource.spec.IDataSourceWriter;
import com.kingdee.bos.qing.util.CollectionUtils;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.StackTraceUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class ProgramDataSetSourceDomain
extends AbstractOpenAPISourceDomain {
    public static ProgramDataSetSourceDomain newInstance() {
        return new ProgramDataSetSourceDomain();
    }

    @Override
    public String openAPIInitialCheck(QingContext qingContext, AbstractSource source) throws OpenAPIException {
        OpenAPISource openAPISource = (OpenAPISource)source;
        String className = OpenAPIUtil.decodeUrl(openAPISource.getUrl());
        ProgramDataSetSourceDomain.getTableDataProvider(className);
        return null;
    }

    @Override
    public AbstractNode getUsableEntities(QingContext qingContext, AbstractSource source) throws OpenAPIException {
        DesigntimeDataObject designtimeDataObject = this.getDesigntimeDataObject(qingContext, source, null);
        return ProgramDataSetResultParseTool.getUsableEntities(designtimeDataObject);
    }

    @Override
    public DesigntimeDataObject getDesigntimeDataObject(QingContext qingContext, AbstractSource source, String associateName) throws OpenAPIException {
        OpenAPISource openAPISource = (OpenAPISource)source;
        String className = OpenAPIUtil.decodeUrl(openAPISource.getUrl());
        ITableDataProvider tableDataProvider = ProgramDataSetSourceDomain.getTableDataProvider(className);
        APITable apiTable = null;
        try {
            apiTable = tableDataProvider.getTableStructure();
        }
        catch (Exception e) {
            throw new OpenAPIException(2062200, StackTraceUtil.getStackTrace((Throwable)e.fillInStackTrace()));
        }
        return ProgramDataSetResultParseTool.getDesigntimeDataObject(apiTable, openAPISource, associateName);
    }

    @Override
    public long getDataCount(QingContext qingContext, RuntimeEntity runtimeEntity) throws OpenAPIException {
        AbstractOpenAPISourceDomain.OpenAPIRuntimeInfo runtimeParams = this.initRuntimeParams(runtimeEntity);
        if (runtimeParams == null) {
            return 0L;
        }
        OpenAPISource openAPISource = (OpenAPISource)runtimeEntity.getSource();
        String className = OpenAPIUtil.decodeUrl(openAPISource.getUrl());
        ITableDataProvider tableDataProvider = ProgramDataSetSourceDomain.getTableDataProvider(className);
        Long noFilterRowCount = 0L;
        try {
            noFilterRowCount = tableDataProvider.getRowCount();
        }
        catch (Exception e) {
            throw new OpenAPIException(2062200, StackTraceUtil.getStackTrace((Throwable)e.fillInStackTrace()));
        }
        IRuntimeFilter pushdownableFilter = runtimeEntity.getPushdownableFilter();
        IRuntimeFilter unPushdownableFilter = runtimeEntity.getUnPushdownableFilter();
        List<ColumnToRowProperty> columnToRowProperties = runtimeEntity.getOrinalEntity().getColumnToRowProperties();
        Collection unionColumnToRowProperties = null;
        if (runtimeEntity.getEntityExtractContext() != null) {
            columnToRowProperties = runtimeEntity.getEntityExtractContext().getColumnToRowProperties();
        }
        if (CollectionUtils.isNotEmpty(unionColumnToRowProperties) || CollectionUtils.isNotEmpty(columnToRowProperties) || pushdownableFilter != null && !pushdownableFilter.isInvalid() || unPushdownableFilter != null && !unPushdownableFilter.isInvalid()) {
            return this.getHasFilterRowCount(noFilterRowCount, runtimeEntity, runtimeParams, tableDataProvider);
        }
        return noFilterRowCount;
    }

    private long getHasFilterRowCount(long noFilterRowCount, RuntimeEntity runtimeEntity, AbstractOpenAPISourceDomain.OpenAPIRuntimeInfo runtimeParams, ITableDataProvider tableDataProvider) throws OpenAPIException {
        Integer limit = 2000;
        long maxPageNumber = noFilterRowCount / (long)limit.intValue() + (long)(noFilterRowCount % (long)limit.intValue() == 0L ? 0 : 1);
        String selectedFields = ProgramDataSetSourceDomain.getSelectedFields(runtimeEntity);
        long hasFilterRowCount = 0L;
        int pageNumber = 1;
        while ((long)pageNumber <= maxPageNumber) {
            List<Object[]> data = tableDataProvider.getData(pageNumber, limit, selectedFields);
            for (Object[] objArr : data) {
                ColumnToRowDataHandler columnToRowdataHandler;
                List<Map<String, Object>> rowDataList;
                Map<String, Object> innerFilterRowMap;
                Map<String, Object> oneRowMap = this.getPriDataOneRowMap(objArr, runtimeEntity);
                if (oneRowMap == null || (innerFilterRowMap = this.innerExcuteFilterParam(runtimeParams, oneRowMap)) == null || !CollectionUtils.isNotEmpty(rowDataList = (columnToRowdataHandler = new ColumnToRowDataHandler()).columnToRow(oneRowMap, runtimeEntity))) continue;
                for (Map<String, Object> rowMap : rowDataList) {
                    Map<String, Object> calculatedRowData = ProgramDataSetSourceDomain.getRowDataAfterCalculateAndFilter(rowMap, runtimeEntity);
                    if (calculatedRowData == null) continue;
                    ++hasFilterRowCount;
                }
            }
            ++pageNumber;
        }
        return hasFilterRowCount;
    }

    @Override
    public PreviewDataModel getPreviewData(QingContext qingContext, RuntimeEntity runtimeEntity, int rows) throws OpenAPIException {
        ArrayList<Object[]> data = new ArrayList<Object[]>();
        AbstractOpenAPISourceDomain.OpenAPIRuntimeInfo runtimeParams = this.initRuntimeParams(runtimeEntity);
        if (runtimeParams == null) {
            return new PreviewDataModel(data);
        }
        OpenAPISource openAPISource = (OpenAPISource)runtimeEntity.getSource();
        String className = OpenAPIUtil.decodeUrl(openAPISource.getUrl());
        String selectedFields = ProgramDataSetSourceDomain.getSelectedFields(runtimeEntity);
        ITableDataProvider tableDataProvider = ProgramDataSetSourceDomain.getTableDataProvider(className);
        Long rowCount = this.getRowCount(tableDataProvider);
        Integer limit = 2000;
        long maxPageNumber = rowCount / (long)limit.intValue() + (long)(rowCount % (long)limit.intValue() == 0L ? 0 : 1);
        try {
            int pageNumber = 1;
            while ((long)pageNumber <= maxPageNumber) {
                List<Object[]> onePageData = tableDataProvider.getData(pageNumber, limit, selectedFields);
                block3: for (Object[] objArr : onePageData) {
                    ColumnToRowDataHandler columnToRowdataHandler;
                    List<Map<String, Object>> rowDataList;
                    Map<String, Object> oneRowMap = this.getPriDataOneRowMap(objArr, runtimeEntity);
                    Map<String, Object> innerFilterRowMap = this.innerExcuteFilterParam(runtimeParams, oneRowMap);
                    if (innerFilterRowMap == null || !CollectionUtils.isNotEmpty(rowDataList = (columnToRowdataHandler = new ColumnToRowDataHandler()).columnToRow(innerFilterRowMap, runtimeEntity))) continue;
                    for (Map<String, Object> rowMap : rowDataList) {
                        Map<String, Object> calculatedRowData = ProgramDataSetSourceDomain.getRowDataAfterCalculateAndFilter(rowMap, runtimeEntity);
                        if (calculatedRowData == null) continue;
                        data.add(ProgramDataSetSourceDomain.getOutputData(calculatedRowData, runtimeEntity, true));
                        if (data.size() != rows) continue;
                        continue block3;
                    }
                }
                ++pageNumber;
            }
        }
        catch (Exception e) {
            throw new OpenAPIException(2062200, StackTraceUtil.getStackTrace((Throwable)e.fillInStackTrace()));
        }
        return new PreviewDataModel(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String extractData(QingContext qingContext, IDataSourceWriter dataSourceWriter, RuntimeEntity runtimeEntity, ProgressProcessor progressProcessor) throws DataSourcePersistenceException, AbstractSourceException, AbstractQingIntegratedException, InterruptedException {
        String string;
        TraceSpan traceSpan = null;
        try {
            traceSpan = TracerUtil.create((String)(Messages.getMLS((String)"openAPIDataSet", (String)"OpenAPI-\u7a0b\u5e8f\u6570\u636e\u96c6\u6570\u636e\u8868[", (Messages.ProjectName)Messages.ProjectName.QING_DATA) + runtimeEntity.getAlias() + Messages.getMLS((String)"getData", (String)"]\u53d6\u6570", (Messages.ProjectName)Messages.ProjectName.QING_DATA)));
            traceSpan.addClassMethodAttribute(this.getClass().getName() + ".extractData");
            traceSpan.addAttribute(Messages.getMLS((String)"tableName", (String)"\u6570\u636e\u8868\u540d", (Messages.ProjectName)Messages.ProjectName.QING_DATA), runtimeEntity.getName());
            traceSpan.addAttribute(Messages.getMLS((String)"tableAlias", (String)"\u6570\u636e\u8868\u522b\u540d", (Messages.ProjectName)Messages.ProjectName.QING_DATA), runtimeEntity.getAlias());
            OpenAPISource openAPISource = (OpenAPISource)runtimeEntity.getSource();
            String className = OpenAPIUtil.decodeUrl(openAPISource.getUrl());
            ITableDataProvider tableDataProvider = ProgramDataSetSourceDomain.getTableDataProvider(className);
            Long rowCount = this.getRowCount(tableDataProvider);
            string = this.extractDataAnalysis(rowCount, className, dataSourceWriter, runtimeEntity, progressProcessor, tableDataProvider);
        }
        catch (Throwable throwable) {
            TracerUtil.close(traceSpan);
            throw throwable;
        }
        TracerUtil.close((TraceSpan)traceSpan);
        return string;
    }

    private Long getRowCount(ITableDataProvider tableDataProvider) throws OpenAPIException {
        Long rowCount;
        try {
            rowCount = tableDataProvider.getRowCount();
        }
        catch (Exception e) {
            throw new OpenAPIException(2062200, StackTraceUtil.getStackTrace((Throwable)e.fillInStackTrace()));
        }
        return rowCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String extractDataAnalysis(long rowCount, String className, IDataSourceWriter dataSourceWriter, RuntimeEntity runtimeEntity, ProgressProcessor progressProcessor, ITableDataProvider tableDataProvider) throws OpenAPIException, DataSourcePersistenceException, InterruptedException {
        long begin = System.currentTimeMillis();
        long cost = 0L;
        try {
            Integer limit = 2000;
            long maxPageNumber = rowCount / (long)limit.intValue() + (long)(rowCount % (long)limit.intValue() == 0L ? 0 : 1);
            AbstractOpenAPISourceDomain.OpenAPIRuntimeInfo runtimeParams = this.initRuntimeParams(runtimeEntity);
            if (runtimeParams == null) {
                String string = null;
                return string;
            }
            String selectedFields = ProgramDataSetSourceDomain.getSelectedFields(runtimeEntity);
            int pageNumber = 1;
            while ((long)pageNumber <= maxPageNumber) {
                List<Object[]> data = null;
                try {
                    long s = System.currentTimeMillis();
                    data = tableDataProvider.getData(pageNumber, limit, selectedFields);
                    cost += System.currentTimeMillis() - s;
                }
                catch (Exception e) {
                    throw new OpenAPIException(2062200, StackTraceUtil.getStackTrace((Throwable)e.fillInStackTrace()));
                }
                if ((long)pageNumber != maxPageNumber && (data.size() < OpenAPIConstant.MIN_PAGESIZE || data.size() > OpenAPIConstant.MAX_PAGESIZE)) {
                    throw new OpenAPIException(2062101, "2062101: PageSize it has to be between 2000 and 20000");
                }
                for (Object[] objArr : data) {
                    ColumnToRowDataHandler columnToRowdataHandler;
                    List<Map<String, Object>> rowDataList;
                    Map<String, Object> innerFilterRowMap;
                    Map<String, Object> oneRowMap = this.getPriDataOneRowMap(objArr, runtimeEntity);
                    if (oneRowMap == null || (innerFilterRowMap = this.innerExcuteFilterParam(runtimeParams, oneRowMap)) == null || !CollectionUtils.isNotEmpty(rowDataList = (columnToRowdataHandler = new ColumnToRowDataHandler()).columnToRow(oneRowMap, runtimeEntity))) continue;
                    for (Map<String, Object> rowMap : rowDataList) {
                        Map<String, Object> calculatedRowData = ProgramDataSetSourceDomain.getRowDataAfterCalculateAndFilter(rowMap, runtimeEntity);
                        if (progressProcessor != null) {
                            progressProcessor.dealOneRow();
                        }
                        if (calculatedRowData == null) continue;
                        Object[] oneRowData = ProgramDataSetSourceDomain.getOutputData(calculatedRowData, runtimeEntity, false);
                        dataSourceWriter.writeData(oneRowData);
                        if (progressProcessor == null) continue;
                        progressProcessor.writeOneRow();
                        if (!progressProcessor.isDataLimit()) continue;
                        String string = null;
                        return string;
                    }
                }
                ++pageNumber;
            }
            String string = null;
            return string;
        }
        finally {
            long end = System.currentTimeMillis();
            LogUtil.info((String)("\u7a0b\u5e8f\u6570\u636e\u96c6: " + className + "\u603b\u5171\u8017\u65f6" + (end - begin) / 1000L + "\u79d2"));
            TraceSpan traceSpan = TracerUtil.create((String)Messages.getMLS((String)"programDataSetCount", (String)"\u7a0b\u5e8f\u6570\u636e\u96c6\u7b2c\u4e09\u65b9\u53d6\u6570\uff08\u603b\uff09", (Messages.ProjectName)Messages.ProjectName.QING_DATA));
            traceSpan.addClassMethodAttribute(this.getClass().getName() + ".getData");
            TracerUtil.close((TraceSpan)traceSpan, (long)cost);
        }
    }

    private static ITableDataProvider getTableDataProvider(String className) throws OpenAPIException {
        try {
            Class<?> clazz = Class.forName(className);
            Object obj = clazz.newInstance();
            if (obj instanceof ITableDataProvider) {
                return (ITableDataProvider)obj;
            }
            throw new OpenAPIException(2062100);
        }
        catch (ClassNotFoundException e) {
            throw new OpenAPIException(2062201, StackTraceUtil.getStackTrace((Throwable)e.fillInStackTrace()));
        }
        catch (InstantiationException e) {
            throw new OpenAPIException(2062200, "InstantiationException:" + StackTraceUtil.getStackTrace((Throwable)e.fillInStackTrace()));
        }
        catch (IllegalAccessException e) {
            throw new OpenAPIException(2062200, "IllegalAccessException:" + StackTraceUtil.getStackTrace((Throwable)e.fillInStackTrace()));
        }
    }
}

