/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.source.api.utils;

import com.kingdee.bos.qing.data.exception.api.OpenAPIException;
import com.kingdee.bos.qing.util.StackTraceUtil;
import com.kingdee.bos.qing.util.StringUtils;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.codec.binary.Base64;

public class OpenAPIUtil {
    private static final ThreadLocal<DateFormat> dateFormat = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd");
        }
    };
    private static final ThreadLocal<DateFormat> dateTimeFormat = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
    };

    public static String decodeUrl(String url) throws OpenAPIException {
        try {
            return new String(Base64.decodeBase64((String)url), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new OpenAPIException(StackTraceUtil.getStackTrace((Throwable)e.fillInStackTrace()));
        }
    }

    public static String encodeUrl(String url) throws OpenAPIException {
        try {
            return new String(Base64.encodeBase64((byte[])url.getBytes()), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new OpenAPIException(StackTraceUtil.getStackTrace((Throwable)e.fillInStackTrace()));
        }
    }

    public static Date parseDateTime(String asString) throws OpenAPIException {
        if (StringUtils.isNotBlank((CharSequence)asString)) {
            try {
                return dateTimeFormat.get().parse(asString);
            }
            catch (ParseException e) {
                throw new OpenAPIException(2061102, asString + "parse Date error");
            }
        }
        return null;
    }

    public static Date parseDate(String asString) throws OpenAPIException {
        try {
            return dateFormat.get().parse(asString);
        }
        catch (ParseException e) {
            throw new OpenAPIException(2061102, asString + "parse Date error");
        }
    }

    public static boolean checkPropertyValueIsNull(Object obj) throws OpenAPIException {
        if (obj == null) {
            return true;
        }
        Field[] fields = obj.getClass().getDeclaredFields();
        return OpenAPIUtil.checkFieldsValue(fields, obj);
    }

    private static boolean checkFieldsValue(Field[] fields, Object obj) throws OpenAPIException {
        for (Field f : fields) {
            try {
                f.setAccessible(true);
                if (f.get(obj) == null || f.get(obj).toString().isEmpty()) {
                    return true;
                }
                f.setAccessible(false);
            }
            catch (IllegalArgumentException e) {
                throw new OpenAPIException(2061202, StackTraceUtil.getStackTrace((Throwable)e.fillInStackTrace()));
            }
            catch (IllegalAccessException e) {
                throw new OpenAPIException(2061202, StackTraceUtil.getStackTrace((Throwable)e.fillInStackTrace()));
            }
        }
        return false;
    }
}

