/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.source.db;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.framework.server.task.ServerRequestInvokeContext;
import com.kingdee.bos.qing.data.domain.source.AbstractDataSourceIterator;
import com.kingdee.bos.qing.data.domain.source.db.AbstractDBSourceDomain;
import com.kingdee.bos.qing.data.domain.source.db.AbstractDBSourceJDBCAdapter;
import com.kingdee.bos.qing.data.domain.source.db.dataconvert.IResultSetDataConvertor;
import com.kingdee.bos.qing.data.domain.source.db.util.SQLHelper;
import com.kingdee.bos.qing.data.exception.AbstractMacroException;
import com.kingdee.bos.qing.data.exception.AbstractSourceException;
import com.kingdee.bos.qing.data.exception.db.DBExcuseException;
import com.kingdee.bos.qing.data.exception.db.DBKSQLNotSupportException;
import com.kingdee.bos.qing.data.exception.db.DBKSQLTranslateException;
import com.kingdee.bos.qing.data.model.designtime.source.DBSource;
import com.kingdee.bos.qing.data.model.runtime.RuntimeEntity;
import com.kingdee.bos.qing.data.model.runtime.RuntimeFilterUtil;
import com.kingdee.bos.qing.data.model.runtime.RuntimeProperty;
import com.kingdee.bos.qing.data.model.runtime.db.IDBRuntimeFilter;
import com.kingdee.bos.qing.datasource.meta.DataType;
import com.kingdee.bos.qing.util.CloseUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JDBCDataSourceIterator
extends AbstractDataSourceIterator {
    private static final String KSQL_DIALECT = "/*dialect*/";
    private boolean isAlwaysFalse;
    private AbstractDBSourceJDBCAdapter jdbcAdapter;
    private DBSource dataBase;
    private IResultSetDataConvertor dataConvertor;
    private IDBRuntimeFilter pushdownableFilter;
    private Connection conn = null;
    private PreparedStatement ps = null;
    private ResultSet rs = null;
    private String sql;
    private Object[] params;
    private boolean isParamSizeTooLong;
    private Map<String, Object> oneRowMap = null;

    public JDBCDataSourceIterator(QingContext qingContext, AbstractDBSourceDomain abstractDBSourceDomain, RuntimeEntity runtimeEntity, IResultSetDataConvertor dataConvertor) throws AbstractSourceException {
        super(qingContext, runtimeEntity);
        this.dataConvertor = dataConvertor;
        this.dataBase = (DBSource)runtimeEntity.getSource();
        this.jdbcAdapter = abstractDBSourceDomain.getJdbcAdapter();
        RuntimeFilterUtil.Prediction prediction = abstractDBSourceDomain.initRuntimeFilter(runtimeEntity);
        this.isAlwaysFalse = prediction.isAlwaysFalse();
        if (this.isAlwaysFalse) {
            return;
        }
        this.pushdownableFilter = (IDBRuntimeFilter)runtimeEntity.getPushdownableFilter();
        if (this.pushdownableFilter != null) {
            ArrayList<Object> params = new ArrayList<Object>();
            this.pushdownableFilter.collectParamValue(params);
            this.params = params.toArray();
            this.isParamSizeTooLong = this.isParamSizeTooLong();
        }
        ArrayList<Object> userSQLParam = new ArrayList<Object>();
        this.sql = this.makeSqlAndCollectParams(userSQLParam);
        this.conn = this.jdbcAdapter.getConnection(this.dataBase);
        try {
            this.ps = this.conn.prepareStatement(this.sql);
            int parameterIndex = 1;
            int i = 0;
            int c = userSQLParam.size();
            while (parameterIndex < c) {
                Object e = userSQLParam.get(i);
                SQLHelper.setParams((PreparedStatement)this.ps, (int)parameterIndex, e);
                ++parameterIndex;
                ++i;
            }
            if (this.isParamsValid()) {
                for (Object object : this.params) {
                    SQLHelper.setParams((PreparedStatement)this.ps, (int)parameterIndex, (Object)object);
                    ++parameterIndex;
                }
            }
            this.ps.setFetchSize(100);
            this.rs = this.ps.executeQuery();
        }
        catch (SQLException e) {
            throw new DBExcuseException(e);
        }
        this.oneRowMap = new HashMap<String, Object>(runtimeEntity.getAllProperties().size(), 1.0f);
    }

    protected boolean isCanFilterInDB() {
        return JDBCDataSourceIterator.isRuntimeFilterValid(this.pushdownableFilter) && !this.isParamSizeTooLong;
    }

    static boolean isRuntimeFilterValid(IDBRuntimeFilter runtimeFilter) {
        return runtimeFilter != null && !runtimeFilter.isInvalid();
    }

    private String makeSqlAndCollectParams(List<Object> paramCollection) throws DBKSQLTranslateException, AbstractMacroException, DBKSQLNotSupportException {
        String tableAssociateName = this.runtimeEntity.getAssociateName();
        String leftDelimiter = this.jdbcAdapter.getLeftDelimiter();
        String rightDelimiter = this.jdbcAdapter.getRightDelimiter();
        StringBuilder sqlStringBuilder = new StringBuilder();
        DBSource.UserSQL userSQL = this.dataBase.getUserSql(tableAssociateName);
        if (userSQL != null) {
            tableAssociateName = "T";
        }
        ArrayList<String> tableColumnAssociateNames = new ArrayList<String>(this.runtimeEntity.getSelectedPriProperties().size());
        for (RuntimeProperty property : this.runtimeEntity.getSelectedPriProperties()) {
            String tableColumnAssociateName = property.getAssociateName();
            tableColumnAssociateNames.add(tableColumnAssociateName);
        }
        if (tableColumnAssociateNames.size() > 0) {
            for (String columnAssociateName : tableColumnAssociateNames) {
                if (sqlStringBuilder.length() > 0) {
                    sqlStringBuilder.append(", ");
                }
                sqlStringBuilder.append(leftDelimiter);
                sqlStringBuilder.append(tableAssociateName);
                sqlStringBuilder.append(rightDelimiter);
                sqlStringBuilder.append(".");
                sqlStringBuilder.append(leftDelimiter);
                sqlStringBuilder.append(columnAssociateName);
                sqlStringBuilder.append(rightDelimiter);
            }
        } else {
            sqlStringBuilder.append(leftDelimiter);
            sqlStringBuilder.append(tableAssociateName);
            sqlStringBuilder.append(rightDelimiter);
            sqlStringBuilder.append(".* ");
        }
        sqlStringBuilder.insert(0, "select ");
        sqlStringBuilder.append(" from ");
        boolean isConnSupportKsql = this.jdbcAdapter.isConnSupportKsql();
        if (userSQL != null) {
            sqlStringBuilder.append('(');
            SQLHelper.RuntimeUserSQL runtimeUserSQL = SQLHelper.processUserSQL((DBSource.UserSQL)userSQL, (DBSource.DBType)this.dataBase.getDbType(), (QingContext)this.qingContext);
            String dbSQL = runtimeUserSQL.getSQL();
            List userSQLParam = runtimeUserSQL.getParam();
            paramCollection.addAll(userSQLParam);
            sqlStringBuilder.append(dbSQL);
            sqlStringBuilder.append(") ");
            sqlStringBuilder.append(leftDelimiter);
            sqlStringBuilder.append(tableAssociateName);
            sqlStringBuilder.append(rightDelimiter);
        } else {
            sqlStringBuilder.append(leftDelimiter);
            sqlStringBuilder.append(this.jdbcAdapter.wrapTableAssociateName(this.dataBase, tableAssociateName));
            sqlStringBuilder.append(rightDelimiter);
        }
        if (this.isCanFilterInDB()) {
            sqlStringBuilder.append(" where ");
            sqlStringBuilder.append(this.pushdownableFilter.toSqlWhere(leftDelimiter, rightDelimiter));
        }
        if (isConnSupportKsql) {
            sqlStringBuilder.insert(0, KSQL_DIALECT);
        }
        return sqlStringBuilder.toString();
    }

    private Map<String, Object> innerFilterIfParamSizeTooLong(Map<String, Object> oneRowMap) {
        if (this.isParamSizeTooLong && this.pushdownableFilter != null && !this.pushdownableFilter.isInvalid()) {
            if (this.pushdownableFilter.innerExcuteFilterWtihRawValue(oneRowMap)) {
                return oneRowMap;
            }
            return null;
        }
        return oneRowMap;
    }

    private void readPrimaryRowDataFromResultSet(ResultSet rs) throws SQLException {
        this.oneRowMap.clear();
        for (RuntimeProperty property : this.runtimeEntity.getSelectedPriProperties()) {
            String columnName = property.getName();
            DataType inputdataType = property.getInputDataType();
            String associateName = property.getAssociateName();
            this.oneRowMap.put(columnName, this.dataConvertor.getData(rs, associateName, inputdataType));
        }
    }

    private boolean isParamSizeTooLong() {
        return this.params != null && this.params.length > SQLHelper.getMaxParamSize();
    }

    private boolean isParamsValid() {
        return this.params != null && this.params.length > 0 && !this.isParamSizeTooLong;
    }

    @Override
    public boolean hasNext() throws InterruptedException, AbstractSourceException {
        if (this.isAlwaysFalse) {
            return false;
        }
        Map<String, Object> calculatedRowData = null;
        try {
            while (this.rs.next()) {
                ServerRequestInvokeContext.staticCheckInterrupt();
                this.readPrimaryRowDataFromResultSet(this.rs);
                Map<String, Object> innerFilterRow = this.innerFilterIfParamSizeTooLong(this.oneRowMap);
                if (innerFilterRow == null || (calculatedRowData = JDBCDataSourceIterator.getRowDataAfterCalculateAndFilter(this.oneRowMap, this.runtimeEntity)) == null) continue;
                this.oneRowMap = calculatedRowData;
                return true;
            }
        }
        catch (SQLException e) {
            throw new DBExcuseException(e);
        }
        return false;
    }

    @Override
    public Map<String, Object> next() {
        return this.oneRowMap;
    }

    @Override
    public void close() {
        CloseUtil.close((Connection)this.conn, (Statement)this.ps, (ResultSet)this.rs);
    }
}

