/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.source.file.domain;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.i18n.Messages;
import com.kingdee.bos.qing.common.trace.TraceSpan;
import com.kingdee.bos.qing.common.trace.TracerUtil;
import com.kingdee.bos.qing.data.domain.source.db.util.DataTypeUtil;
import com.kingdee.bos.qing.data.domain.source.file.domain.AbstractFileSourceDomain;
import com.kingdee.bos.qing.data.domain.source.file.model.AbstractFileModel;
import com.kingdee.bos.qing.data.domain.source.file.model.ResultContent;
import com.kingdee.bos.qing.data.domain.source.file.model.RunningTimeParams;
import com.kingdee.bos.qing.data.domain.source.file.model.XmlParseDataModel;
import com.kingdee.bos.qing.data.exception.AbstractSourceException;
import com.kingdee.bos.qing.data.model.designtime.AbstractSource;
import com.kingdee.bos.qing.data.model.designtime.Entity;
import com.kingdee.bos.qing.data.model.designtime.source.FileSource;
import com.kingdee.bos.qing.data.model.designtime.source.XMLSource;
import com.kingdee.bos.qing.data.model.runtime.Field;
import com.kingdee.bos.qing.data.model.runtime.IRuntimeFilter;
import com.kingdee.bos.qing.data.model.runtime.ProgressProcessor;
import com.kingdee.bos.qing.data.model.runtime.RuntimeEntity;
import com.kingdee.bos.qing.data.model.runtime.RuntimeFilterUtil;
import com.kingdee.bos.qing.data.model.runtime.Table;
import com.kingdee.bos.qing.data.model.vo.AbstractNode;
import com.kingdee.bos.qing.data.model.vo.DesigntimeDataObject;
import com.kingdee.bos.qing.data.model.vo.FolderNode;
import com.kingdee.bos.qing.data.model.vo.LeafNode;
import com.kingdee.bos.qing.data.model.vo.PreviewDataModel;
import com.kingdee.bos.qing.data.util.ThreadCache;
import com.kingdee.bos.qing.datasource.exception.DataSourcePersistenceException;
import com.kingdee.bos.qing.datasource.spec.IDataSourceWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class XMLSourceDomain
extends AbstractFileSourceDomain {
    private static volatile AbstractFileSourceDomain thiz;
    private static String XML;

    private XMLSourceDomain() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AbstractFileSourceDomain newInstance() {
        if (thiz != null) return thiz;
        Class<XMLSourceDomain> clazz = XMLSourceDomain.class;
        synchronized (XMLSourceDomain.class) {
            if (thiz != null) return thiz;
            thiz = new XMLSourceDomain();
            // ** MonitorExit[var0] (shouldn't be in output)
            return thiz;
        }
    }

    @Override
    public AbstractNode getUsableEntities(QingContext qingContext, AbstractSource source) throws AbstractSourceException {
        XMLSource fileSource = (XMLSource)source;
        String fileUrl = fileSource.getFileUrl();
        XmlParseDataModel xmlParseDataModel = new XmlParseDataModel(fileUrl);
        List<String> tableNames = ((AbstractFileModel)xmlParseDataModel).getTableNames();
        FolderNode mainFolder = new FolderNode();
        for (int i = 0; i < tableNames.size(); ++i) {
            LeafNode leafNode = new LeafNode();
            leafNode.setType(XML);
            leafNode.setName(tableNames.get(i));
            leafNode.setCommentInfo(tableNames.get(i));
            String[] arrTalbeNames = tableNames.get(i).split("/");
            leafNode.setDisplayName(arrTalbeNames[arrTalbeNames.length - 1]);
            mainFolder.addChild((AbstractNode)leafNode);
        }
        return mainFolder;
    }

    @Override
    public PreviewDataModel doGetPreviewData(QingContext qingContext, RuntimeEntity runtimeEntity, int topN) throws AbstractSourceException {
        RuntimeFilterUtil.Prediction prediction = this.initRuntimeFilter(runtimeEntity);
        if (prediction.isAlwaysFalse()) {
            return new PreviewDataModel(new ArrayList<Object[]>());
        }
        XMLSource fileSource = (XMLSource)runtimeEntity.getSource();
        String[] xPath = runtimeEntity.getAssociateName().split("/");
        XmlParseDataModel model = new XmlParseDataModel(fileSource.getFileUrl(), xPath, (FileSource)fileSource);
        model.setFileSourceDomain(this);
        IRuntimeFilter iRuntimeFilter = runtimeEntity.getPushdownableFilter();
        Integer colIndex = 0;
        ThreadCache.setIndex(colIndex);
        ThreadCache.setRow(new HashMap<String, Object>(16));
        RunningTimeParams params = new RunningTimeParams();
        params.setRuntimeFilter(iRuntimeFilter);
        params.setRuntimeEntity(runtimeEntity);
        params.setSource((AbstractSource)fileSource);
        params.setTopN(topN);
        params.setPreview(true);
        ResultContent resultContent = null;
        try {
            resultContent = ((AbstractFileModel)model).topNRow(params, null);
        }
        catch (DataSourcePersistenceException e) {
            throw new RuntimeException(e);
        }
        finally {
            ThreadCache.removeIndex();
            ThreadCache.removeRow();
        }
        return new PreviewDataModel(resultContent.getPreviewResult());
    }

    @Override
    public DesigntimeDataObject getDesigntimeDataObject(QingContext qingContext, AbstractSource source, String sheetName) throws AbstractSourceException {
        XMLSource fileSource = (XMLSource)source;
        Table table = this.getTable(sheetName, null, fileSource, qingContext);
        Entity entity = Entity.fromTable(table);
        entity.setAlias(table.getDisplayName());
        return DesigntimeDataObject.createSingleDataObject(entity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String doExtractData(QingContext qingContext, IDataSourceWriter dataSourceWriter, RuntimeEntity runtimeEntity, ProgressProcessor progressProcessor) throws AbstractSourceException, DataSourcePersistenceException {
        TraceSpan traceSpan;
        XmlParseDataModel model;
        XMLSource fileSource;
        block3: {
            String string;
            fileSource = (XMLSource)runtimeEntity.getSource();
            String[] xPath = runtimeEntity.getAssociateName().split("/");
            model = new XmlParseDataModel(fileSource.getFileUrl(), xPath, (FileSource)fileSource);
            model.setFileSourceDomain(this);
            Integer colIndex = 0;
            ThreadCache.setIndex(colIndex);
            ThreadCache.setRow(new HashMap<String, Object>());
            ThreadCache.setRowWithCalculate(new HashMap<String, Object>());
            traceSpan = null;
            try {
                traceSpan = TracerUtil.create((String)(Messages.getMLS((String)"XmlDataTable", (String)"Xml\u6570\u636e\u8868[", (Messages.ProjectName)Messages.ProjectName.QING_DATA) + runtimeEntity.getAlias() + Messages.getMLS((String)"getData", (String)"]\u53d6\u6570", (Messages.ProjectName)Messages.ProjectName.QING_DATA)));
                traceSpan.addClassMethodAttribute(this.getClass().getName() + ".extractData");
                traceSpan.addAttribute(Messages.getMLS((String)"tableName", (String)"\u6570\u636e\u8868\u540d", (Messages.ProjectName)Messages.ProjectName.QING_DATA), runtimeEntity.getName());
                traceSpan.addAttribute(Messages.getMLS((String)"tableAlias", (String)"\u6570\u636e\u8868\u522b\u540d", (Messages.ProjectName)Messages.ProjectName.QING_DATA), runtimeEntity.getAlias());
                RuntimeFilterUtil.Prediction prediction = this.initRuntimeFilter(runtimeEntity);
                if (!prediction.isAlwaysFalse()) break block3;
                string = null;
            }
            catch (Throwable throwable) {
                ThreadCache.removeIndex();
                ThreadCache.removeRow();
                ThreadCache.removeRowWithCalculate();
                TracerUtil.close(traceSpan);
                throw throwable;
            }
            ThreadCache.removeIndex();
            ThreadCache.removeRow();
            ThreadCache.removeRowWithCalculate();
            TracerUtil.close((TraceSpan)traceSpan);
            return string;
        }
        IRuntimeFilter iRuntimeFilter = runtimeEntity.getPushdownableFilter();
        RunningTimeParams params = new RunningTimeParams();
        params.setRuntimeFilter(iRuntimeFilter);
        params.setRuntimeEntity(runtimeEntity);
        params.setDataSourceWriter(dataSourceWriter);
        params.setSource((AbstractSource)fileSource);
        params.setPreview(false);
        params.setTopN(-2);
        ((AbstractFileModel)model).topNRow(params, progressProcessor);
        String string = null;
        ThreadCache.removeIndex();
        ThreadCache.removeRow();
        ThreadCache.removeRowWithCalculate();
        TracerUtil.close((TraceSpan)traceSpan);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Table getTable(String sheetName, RuntimeEntity runtimeEntity, XMLSource fileSource, QingContext qingContext) throws AbstractSourceException {
        Table table = null;
        String[] xPath = sheetName.split("/");
        String fileUrl = fileSource.getFileUrl();
        String sourceName = fileSource.getName();
        Integer colIndex = 0;
        ThreadCache.setIndex(colIndex);
        ThreadCache.setRow(new HashMap<String, Object>());
        ThreadCache.setRowWithCalculate(new HashMap<String, Object>());
        XmlParseDataModel model = null;
        try {
            model = new XmlParseDataModel(fileUrl, xPath, (FileSource)fileSource);
            model.setFileSourceDomain(this);
            table = new Table();
            table.setName(sheetName);
            table.setSource(sourceName);
            table.setDisplayName(xPath[xPath.length - 1]);
            Map<String, Set<String>> colTypeMap = ((AbstractFileModel)model).getColTypeMap();
            for (Map.Entry<Integer, String> c : ((AbstractFileModel)model).getColIndexNameMap().entrySet()) {
                Field field = new Field();
                String columnName = c.getValue();
                field.setName(columnName);
                String className = this.filterType(colTypeMap.get(columnName));
                field.setClassName(className);
                field.setDataType(DataTypeUtil.parseDataType((String)className));
                table.addField(field);
            }
        }
        finally {
            ThreadCache.removeIndex();
            ThreadCache.removeRow();
            ThreadCache.removeRowWithCalculate();
        }
        return table;
    }

    private String filterType(Set typeSet) {
        if (typeSet.contains("java.lang.String")) {
            return "java.lang.String";
        }
        if (typeSet.size() > 1) {
            return this.calculate(typeSet);
        }
        if (typeSet.toArray()[0] == null) {
            return "java.lang.String";
        }
        return typeSet.size() > 0 ? typeSet.toArray()[0].toString() : "java.lang.String";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long doGetDataCount(QingContext qingContext, RuntimeEntity runtimeEntity) throws AbstractSourceException {
        RuntimeFilterUtil.Prediction prediction = this.initRuntimeFilter(runtimeEntity);
        if (prediction.isAlwaysFalse()) {
            return 0L;
        }
        XMLSource fileSource = (XMLSource)runtimeEntity.getSource();
        IRuntimeFilter iRuntimeFilter = runtimeEntity.getPushdownableFilter();
        Integer colIndex = 0;
        ThreadCache.setIndex(colIndex);
        ThreadCache.setRow(new HashMap<String, Object>());
        RunningTimeParams params = new RunningTimeParams();
        params.setRuntimeFilter(iRuntimeFilter);
        params.setRuntimeEntity(runtimeEntity);
        params.setSource((AbstractSource)fileSource);
        int rowCount = 0;
        try {
            String[] xPath = runtimeEntity.getAssociateName().split("/");
            XmlParseDataModel model = new XmlParseDataModel(fileSource.getFileUrl(), xPath, (FileSource)fileSource);
            model.setFileSourceDomain(this);
            rowCount = ((AbstractFileModel)model).getTotalRowCount(params);
        }
        finally {
            ThreadCache.removeIndex();
            ThreadCache.removeRow();
        }
        return rowCount;
    }

    static {
        XML = "xml";
    }
}

