/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.source.file.excel07.cell;

import com.kingdee.bos.qing.data.domain.source.file.excel07.cell.CellDataType;
import com.kingdee.bos.qing.datasource.meta.DataType;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Calendar;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.model.SharedStringsTable;

public abstract class CellInfo {
    private int col;
    private int row;
    private int numFmtIndex;
    private String numFmtString;
    private String cellOriginalValue = "";
    private CellDataType cellDataType;

    public Object getRawValue() {
        return null;
    }

    public abstract String getDataTypeClassName();

    public abstract void initRawValue(SharedStringsTable var1);

    public String getCellOriginalValue() {
        return this.cellOriginalValue;
    }

    public void setOriginalValue(String cellValue) {
        this.cellOriginalValue = cellValue;
    }

    public int getCol() {
        return this.col;
    }

    public int getRow() {
        return this.row;
    }

    public void setCellAddress(String cellAddress) {
        CellReference cellReference = new CellReference(cellAddress);
        this.col = cellReference.getCol() + 1;
        this.row = cellReference.getRow() + 1;
    }

    public void setLocation(int row, int col) {
        this.col = col;
        this.row = row;
    }

    public CellDataType getCellDataType() {
        return this.cellDataType;
    }

    void setCellDataType(CellDataType cellDataType) {
        this.cellDataType = cellDataType;
    }

    public int getNumFmtIndex() {
        return this.numFmtIndex;
    }

    public void setNumFmtIndex(int numFmtIndex) {
        this.numFmtIndex = numFmtIndex;
    }

    public String getNumFmtString() {
        return this.numFmtString;
    }

    public void setNumFmtString(String numFmtString) {
        this.numFmtString = numFmtString;
    }

    protected abstract CellInfo newInstance();

    public CellInfo createCopy(boolean copyLocaltion) {
        CellInfo target = this.newInstance();
        this.copyBase(target, copyLocaltion);
        return target;
    }

    protected void copyBase(CellInfo target, boolean copyLocation) {
        if (copyLocation) {
            target.row = this.row;
            target.col = this.col;
        }
        target.cellDataType = this.cellDataType;
        target.numFmtIndex = this.numFmtIndex;
        target.numFmtString = this.numFmtString;
        target.cellOriginalValue = this.cellOriginalValue;
    }

    protected String getFormateString() {
        return null;
    }

    public String getStringValue() {
        if (this.getRawValue() == null) {
            return null;
        }
        return this.getFormateString();
    }

    protected BigDecimal getNumericValue() throws ParseException {
        throw new ParseException("value cannot be convert to number.col:" + this.getCol() + ",row:" + this.getRow(), -1);
    }

    protected Long getLongValue() throws ParseException {
        throw new ParseException("value cannot be convert to long.col:" + this.getCol() + ",row:" + this.getRow(), -1);
    }

    protected BigDecimal getBigInt() throws ParseException {
        throw new ParseException("value cannot be convert to number.col:" + this.getCol() + ",row:" + this.getRow(), -1);
    }

    protected Calendar getDateValue() throws ParseException {
        throw new ParseException("value cannot be convert to date.col:" + this.getCol() + ",row:" + this.getRow(), -1);
    }

    protected Boolean getBooleanValue() throws ParseException {
        throw new ParseException("value cannot be convert to boolean.col:" + this.getCol() + ",row:" + this.getRow(), -1);
    }

    public Object getCellValue(DataType dataType) throws ParseException {
        if (this.getRawValue() == null) {
            return null;
        }
        switch (dataType) {
            case STRING: {
                return this.getFormateString();
            }
            case NUMBER: {
                return this.getNumericValue();
            }
            case INT: {
                return this.getBigInt();
            }
            case DATETIME: 
            case DATE: {
                return this.getDateValue();
            }
            case BOOLEAN: {
                return this.getBooleanValue();
            }
        }
        return null;
    }
}

