/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.source.file.handler;

import com.kingdee.bos.qing.data.domain.source.file.handler.XlsSheetContentsHandler;
import com.kingdee.bos.qing.data.domain.source.file.model.ResultContent;
import com.kingdee.bos.qing.data.domain.source.file.model.RunningTimeParams;
import com.kingdee.bos.qing.data.domain.unionsource.EntityExtractContext;
import com.kingdee.bos.qing.data.util.ThreadCache;
import com.kingdee.bos.qing.util.CollectionUtils;
import com.kingdee.bos.qing.util.StringUtils;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.eventusermodel.HSSFUserException;
import shaded.com.google.common.collect.Maps;

public class XlsRowCountHandler
extends ResultContent
implements XlsSheetContentsHandler {
    private RunningTimeParams params;
    private Map<String, String> row = Maps.newHashMap();
    private Map<String, String> mergeCellsIndex;
    private Map<Integer, Map<String, String>> cacheRows = Maps.newHashMap();
    private Map<Integer, String> colIndexAndNameMap;
    private Map<Integer, Map<String, Object>> filteredRow = Maps.newHashMap();
    private int rowCount;

    public Map<Integer, Map<String, Object>> getFilteredRow() {
        return this.filteredRow;
    }

    public XlsRowCountHandler(RunningTimeParams params, Map<String, String> mergeCellsIndex, Map<Integer, String> colIndexAndNameMap) {
        this.params = params;
        this.mergeCellsIndex = mergeCellsIndex;
        this.colIndexAndNameMap = colIndexAndNameMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endRow(int thisRow) throws HSSFUserException {
        boolean isNotExistUnionColumnToRow = true;
        EntityExtractContext entityExtractContext = this.params.getRuntimeEntity().getEntityExtractContext();
        if (entityExtractContext != null && CollectionUtils.isNotEmpty(entityExtractContext.getColumnToRowProperties())) {
            isNotExistUnionColumnToRow = false;
        }
        if (this.params.getRuntimeFilter() == null && thisRow != 0 && isNotExistUnionColumnToRow && CollectionUtils.isEmpty(this.params.getRuntimeEntity().getOrinalEntity().getColumnToRowProperties())) {
            ++this.rowCount;
        } else {
            List<Map<String, Object>> filterRowList = null;
            try {
                if (null != this.params.getRuntimeEntity() && thisRow != 0 && CollectionUtils.isNotEmpty(filterRowList = this.params.getFileSourceDomain().filterRow(thisRow, this.row, this.params.getRuntimeFilter(), this.params.getRuntimeEntity(), this))) {
                    this.rowCount += filterRowList.size();
                }
            }
            finally {
                this.row.clear();
                ThreadCache.getRow().clear();
            }
        }
    }

    public int getRowCount() {
        return this.rowCount;
    }

    @Override
    public void cell(int thisRow, int thisColumn, String comment) {
        if (thisColumn > -1 && thisRow != 0) {
            boolean isExistColToRowAndFilter = false;
            if (this.params.getRuntimeEntity().getUnPushdownableFilter() != null && (CollectionUtils.isNotEmpty(this.params.getRuntimeEntity().getOrinalEntity().getColumnToRowProperties()) || this.params.getRuntimeEntity().getEntityExtractContext() != null && CollectionUtils.isNotEmpty(this.params.getRuntimeEntity().getEntityExtractContext().getColumnToRowProperties()))) {
                isExistColToRowAndFilter = true;
            }
            if (null != this.params.getRuntimeFilter() || isExistColToRowAndFilter) {
                this.row.put(this.colIndexAndNameMap.get(thisColumn), comment);
                String value = this.mergeCellsIndex.get(thisRow + "-" + thisColumn);
                if (StringUtils.isNotBlank((CharSequence)value)) {
                    String[] arr = value.split("-");
                    int maxR = Integer.parseInt(arr[0]);
                    int maxC = Integer.parseInt(arr[1]);
                    for (int r = thisRow; r <= maxR; ++r) {
                        for (int c = thisColumn; c <= maxC; ++c) {
                            if (thisRow != r || thisColumn != c) {
                                Map<Object, Object> row = Maps.newHashMap();
                                if (this.cacheRows.containsKey(r)) {
                                    row = this.cacheRows.get(r);
                                }
                                row.put(this.colIndexAndNameMap.get(c), comment);
                                this.cacheRows.put(r, row);
                                continue;
                            }
                            this.row.put(this.colIndexAndNameMap.get(c), comment);
                        }
                    }
                }
            }
        }
    }
}

