/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.source.file.parser;

import com.kingdee.bos.qing.data.domain.source.file.handler.AbortableFormatTrackingHSSFListener;
import com.kingdee.bos.qing.data.domain.source.file.handler.AbortableMissingRecordAwareHSSFListener;
import com.kingdee.bos.qing.data.domain.source.file.handler.XlsListener;
import com.kingdee.bos.qing.data.domain.source.file.handler.XlsSheetContentsHandler;
import com.kingdee.bos.qing.data.exception.AbstractSourceException;
import com.kingdee.bos.qing.data.exception.file.FileSourceEncipheredException;
import com.kingdee.bos.qing.data.exception.file.FileSourceFileAccessException;
import com.kingdee.bos.qing.data.exception.file.FileSourceFileNotFoundException;
import com.kingdee.bos.qing.data.exception.file.FileSourceFileParseException;
import com.kingdee.bos.qing.data.exception.file.hssf.DataSourceExceptionHSSFUserException;
import com.kingdee.bos.qing.data.exception.file.hssf.ExcelReadEndException;
import com.kingdee.bos.qing.datasource.exception.DataSourcePersistenceException;
import com.kingdee.bos.qing.filesystem.manager.FileFactory;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileVisitor;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingPersistentFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingTempFileType;
import com.kingdee.bos.qing.filesystem.stream.QingInputStream;
import com.kingdee.bos.qing.util.CloseUtil;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.hssf.eventusermodel.AbortableHSSFListener;
import org.apache.poi.hssf.eventusermodel.HSSFEventFactory;
import org.apache.poi.hssf.eventusermodel.HSSFListener;
import org.apache.poi.hssf.eventusermodel.HSSFRequest;
import org.apache.poi.hssf.eventusermodel.HSSFUserException;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class Excel03Parser {
    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void parse(String path, HSSFRequest request) throws AbstractSourceException {
        POIFSFileSystem fs = null;
        HSSFEventFactory factory = new HSSFEventFactory();
        QingInputStream sis = null;
        IQingFileVisitor file = FileFactory.newFileVisitor((AbstractQingFileType)QingPersistentFileType.DATAMODELING_DS, (String)path);
        if (!file.exists()) {
            file = FileFactory.newFileVisitor((AbstractQingFileType)QingTempFileType.UPLOAD, (String)path);
        }
        try {
            sis = file.getInputStream();
        }
        catch (FileNotFoundException e) {
            CloseUtil.close((Closeable[])new Closeable[]{sis});
            throw new FileSourceFileNotFoundException(e);
        }
        catch (IOException e) {
            CloseUtil.close((Closeable[])new Closeable[]{sis});
            throw new FileSourceFileAccessException(e);
        }
        try {
            fs = new POIFSFileSystem((InputStream)sis);
            factory.processWorkbookEvents(request, fs);
        }
        catch (IOException ex) {
            try {
                throw new FileSourceFileParseException(ex);
                catch (EncryptedDocumentException e) {
                    throw new FileSourceEncipheredException("File source has been Enciphered.");
                }
            }
            catch (Throwable throwable) {
                CloseUtil.close((Closeable[])new Closeable[]{sis});
                throw throwable;
            }
        }
        CloseUtil.close((Closeable[])new Closeable[]{sis});
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void parse(XlsSheetContentsHandler handler, InputStream fileInputStream, String tableName) throws AbstractSourceException, DataSourcePersistenceException {
        try {
            HSSFEventFactory factory = new HSSFEventFactory();
            HSSFRequest request = new HSSFRequest();
            XlsListener listener = new XlsListener(handler, tableName);
            if (listener instanceof AbortableHSSFListener) {
                XlsListener al = listener;
                AbortableMissingRecordAwareHSSFListener abortableListener = new AbortableMissingRecordAwareHSSFListener(al);
                AbortableFormatTrackingHSSFListener formatListener = new AbortableFormatTrackingHSSFListener(abortableListener);
                listener.setFormatListener(formatListener);
                request.addListenerForAllRecords((HSSFListener)formatListener);
                factory.abortableProcessWorkbookEvents(request, new POIFSFileSystem(fileInputStream));
            } else {
                request.addListenerForAllRecords((HSSFListener)listener);
                factory.processWorkbookEvents(request, new POIFSFileSystem(fileInputStream));
            }
        }
        catch (ExcelReadEndException factory) {
            CloseUtil.close((Closeable[])new Closeable[]{fileInputStream});
            return;
        }
        catch (DataSourceExceptionHSSFUserException e) {
            try {
                throw e.getCause();
                catch (HSSFUserException e2) {
                    throw new FileSourceFileParseException(e2);
                }
                catch (EncryptedDocumentException e3) {
                    throw new FileSourceEncipheredException(tableName + "'s source has been Enciphered.");
                }
                catch (IOException e4) {
                    throw new FileSourceFileParseException(e4);
                }
            }
            catch (Throwable throwable) {
                CloseUtil.close((Closeable[])new Closeable[]{fileInputStream});
                throw throwable;
            }
        }
        CloseUtil.close((Closeable[])new Closeable[]{fileInputStream});
    }
}

