/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.visitor;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.data.domain.visitor.AbstractEntityDataSourceVisitor;
import com.kingdee.bos.qing.data.model.designtime.AbstractEntity;
import com.kingdee.bos.qing.data.model.designtime.AbstractSource;
import com.kingdee.bos.qing.data.model.designtime.CompareType;
import com.kingdee.bos.qing.data.model.designtime.FilterItem;
import com.kingdee.bos.qing.data.model.designtime.Parild;
import com.kingdee.bos.qing.data.model.designtime.Property;
import com.kingdee.bos.qing.data.model.designtime.ValueMode;
import com.kingdee.bos.qing.data.util.ParildNameKeySelector;
import com.kingdee.bos.qing.datasource.exception.AbstractDataSourceException;
import com.kingdee.bos.qing.datasource.meta.DSFieldKey;
import com.kingdee.bos.qing.datasource.meta.DSMetaProperty;
import com.kingdee.bos.qing.datasource.meta.MetaInfo;
import com.kingdee.bos.qing.datasource.model.filter.AbstractUnderDSFilter;
import com.kingdee.bos.qing.datasource.model.filter.IPushdownFilter;
import com.kingdee.bos.qing.datasource.model.filter.UnderDSContinuousFilter;
import com.kingdee.bos.qing.datasource.model.filter.UnderDSDiscreteFilter;
import com.kingdee.bos.qing.datasource.spec.AbstractDataIterator;
import com.kingdee.bos.qing.util.JsonUtil;
import com.kingdee.bos.qing.util.MapUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractEntityDirectModelDataIterator
extends AbstractDataIterator {
    protected AbstractEntityDataSourceVisitor abstractEntityDataSourceVisitor;
    protected QingContext qingContext;
    protected AbstractSource source;
    protected AbstractEntity entity;
    protected Set<String> whitePropertySet;
    protected String ownerId;
    protected MetaInfo metaInfo;
    protected List<Integer> interestingFieldIndexs = new ArrayList<Integer>();
    protected List<String> allFullFieldNames = new ArrayList<String>();
    protected Set<DSFieldKey> pushDownSelectedDSFieldKeys;
    protected Set<AbstractUnderDSFilter> unPushDownDSFilters;
    protected Map<String, Property> outputDMPropertyMap;
    protected boolean hasData = true;

    public AbstractEntityDirectModelDataIterator(AbstractEntityDataSourceVisitor abstractEntityDataSourceVisitor, QingContext qingContext, AbstractSource source, AbstractEntity entity, Set<String> whitePropertySet, String ownerId, MetaInfo metaInfo) {
        super(metaInfo);
        this.abstractEntityDataSourceVisitor = abstractEntityDataSourceVisitor;
        this.qingContext = qingContext;
        this.source = source;
        this.entity = entity;
        this.whitePropertySet = whitePropertySet;
        this.ownerId = ownerId;
    }

    protected final void initImpl(Set<DSFieldKey> selectFields, Set<IPushdownFilter> dsFilters) throws AbstractDataSourceException, InterruptedException {
        Map<String, Property> allDMPropertyMap = this.abstractEntityDataSourceVisitor.getDMEntityPropertyNameMap();
        Map<String, DSMetaProperty> allDSMetaPropertyMap = this.abstractEntityDataSourceVisitor.getDSMetaEntityPropertyNameMap();
        List<Parild> parilds = this.entity.getParilds();
        Map parildMap = MapUtils.collectionToMap(parilds, (MapUtils.IMapKeySelector)new ParildNameKeySelector());
        HashMap<String, Property> referenceDMPropertyMap = new HashMap<String, Property>();
        AbstractEntityDirectModelDataIterator.collectReferenceDMProperty(referenceDMPropertyMap, selectFields, dsFilters, allDSMetaPropertyMap, allDMPropertyMap);
        AbstractEntityDirectModelDataIterator.collectReferenceDMPropertyFromParild(referenceDMPropertyMap, parildMap, allDMPropertyMap);
        this.unPushDownDSFilters = this.collectUnPushDownDSFilters(dsFilters);
        List<FilterItem> filterItems = AbstractEntityDirectModelDataIterator.changeDSFilterToFilterItem(dsFilters, allDMPropertyMap);
        this.outputDMPropertyMap = new HashMap<String, Property>();
        AbstractEntityDirectModelDataIterator.collectOutputDMPropertyFromDSFieldKeys(this.outputDMPropertyMap, selectFields, allDMPropertyMap, allDSMetaPropertyMap);
        AbstractEntityDirectModelDataIterator.collectOutputDMPropertyFromUnPushDownDSFilter(this.outputDMPropertyMap, this.unPushDownDSFilters, allDMPropertyMap, allDSMetaPropertyMap);
        AbstractEntityDirectModelDataIterator.collectReferenceDMPropertyFromParild(this.outputDMPropertyMap, parildMap, allDMPropertyMap);
        this.innerInit(referenceDMPropertyMap, filterItems);
    }

    private static void collectReferenceDMPropertyFromParild(Map<String, Property> referenceDMPropertyMap, Map<String, Parild> parildMap, Map<String, Property> allDMPropertyMap) {
        Set<Map.Entry<String, Property>> referenceDMPropertyNameSet = referenceDMPropertyMap.entrySet();
        HashMap<String, Property> additionReferenceDMPropertyMap = new HashMap<String, Property>(referenceDMPropertyNameSet.size());
        for (Map.Entry<String, Property> referenceDMPropertyEntry : referenceDMPropertyNameSet) {
            Property referenceDMProperty = referenceDMPropertyEntry.getValue();
            String dmPropertyName = referenceDMProperty.getName();
            String groupName = referenceDMProperty.getGroup();
            if (groupName == null) continue;
            Parild parild = parildMap.get(groupName);
            String idField = parild.getIdField();
            String pidField = parild.getParentIdField();
            String displayField = parild.getDefaultDisplayField();
            if (!dmPropertyName.equals(idField) && !dmPropertyName.equals(pidField) && !dmPropertyName.equals(displayField)) continue;
            additionReferenceDMPropertyMap.put(idField, allDMPropertyMap.get(idField));
            additionReferenceDMPropertyMap.put(pidField, allDMPropertyMap.get(pidField));
            additionReferenceDMPropertyMap.put(displayField, allDMPropertyMap.get(displayField));
        }
        if (!additionReferenceDMPropertyMap.isEmpty()) {
            referenceDMPropertyMap.putAll(additionReferenceDMPropertyMap);
        }
    }

    private static void collectOutputDMPropertyFromUnPushDownDSFilter(Map<String, Property> outputDMPropertyMap, Set<AbstractUnderDSFilter> unPushDownDSFilters, Map<String, Property> allDMPropertyMap, Map<String, DSMetaProperty> allDSMetaPropertyMap) {
        if (unPushDownDSFilters != null && !unPushDownDSFilters.isEmpty()) {
            for (AbstractUnderDSFilter unPushDownDSFilter : unPushDownDSFilters) {
                DSFieldKey dsFieldKey = unPushDownDSFilter.getField();
                String dsDSPropertyName = dsFieldKey.getPropertyName();
                DSMetaProperty dsMetaProperty = allDSMetaPropertyMap.get(dsDSPropertyName);
                String dmPropertyName = dsMetaProperty.getName();
                AbstractEntityDirectModelDataIterator.collectOutputDMPropertyFromDMProperty(outputDMPropertyMap, dmPropertyName, allDMPropertyMap);
            }
        }
    }

    private static Set<DSFieldKey> collectOutputDMPropertyFromDSFieldKeys(Map<String, Property> outputDMPropertyMap, Set<DSFieldKey> dsFieldKeys, Map<String, Property> allDMPropertyMap, Map<String, DSMetaProperty> allDSMetaPropertyMap) {
        HashSet<DSFieldKey> pushDownSelectedDSFieldKeys = new HashSet<DSFieldKey>();
        if (dsFieldKeys != null && !dsFieldKeys.isEmpty()) {
            for (DSFieldKey dsFieldKey : dsFieldKeys) {
                String dsDSPropertyName = dsFieldKey.getPropertyName();
                DSMetaProperty dsMetaProperty = allDSMetaPropertyMap.get(dsDSPropertyName);
                if (dsMetaProperty == null) continue;
                String dmPropertyName = dsMetaProperty.getName();
                AbstractEntityDirectModelDataIterator.collectOutputDMPropertyFromDMProperty(outputDMPropertyMap, dmPropertyName, allDMPropertyMap);
            }
        }
        return pushDownSelectedDSFieldKeys;
    }

    private static void collectOutputDMPropertyFromDMProperty(Map<String, Property> outputDMPropertyMap, String dmPropertyName, Map<String, Property> allDMPropertyMap) {
        Property dmProperty = allDMPropertyMap.get(dmPropertyName);
        outputDMPropertyMap.put(dmPropertyName, dmProperty);
        if (dmProperty.isCalculation()) {
            Set<String> originalDMPropertyNameSet = dmProperty.getDependences();
            for (String originalDMPropertyName : originalDMPropertyNameSet) {
                AbstractEntityDirectModelDataIterator.collectOutputDMPropertyFromDMProperty(outputDMPropertyMap, originalDMPropertyName, allDMPropertyMap);
            }
        }
    }

    private static void collectReferenceDMProperty(Map<String, Property> referenceDMPropertyMap, Set<DSFieldKey> fields, Set<IPushdownFilter> dsFilters, Map<String, DSMetaProperty> allDSMetaPropertyMap, Map<String, Property> allDMPropertyMap) throws AbstractDataSourceException {
        HashSet<DSFieldKey> referenceDSFieldKey = new HashSet<DSFieldKey>();
        referenceDSFieldKey.addAll(fields);
        if (dsFilters != null && !dsFilters.isEmpty()) {
            for (IPushdownFilter underDSFilter : dsFilters) {
                referenceDSFieldKey.addAll(underDSFilter.getAssociatedFields());
            }
        }
        for (DSFieldKey fieldKey : referenceDSFieldKey) {
            String dsDSPropertyName = fieldKey.getPropertyName();
            DSMetaProperty dsMetaProperty = allDSMetaPropertyMap.get(dsDSPropertyName);
            if (dsMetaProperty == null) continue;
            String dmPropertyName = dsMetaProperty.getName();
            AbstractEntityDirectModelDataIterator.collectReferenceDMPropertyFromDMProperty(referenceDMPropertyMap, dmPropertyName, allDMPropertyMap);
        }
    }

    private static void collectReferenceDMPropertyFromDMProperty(Map<String, Property> referenceDMPropertyMap, String dmPropertyName, Map<String, Property> allDMPropertyMap) {
        Property dmProperty = allDMPropertyMap.get(dmPropertyName);
        referenceDMPropertyMap.put(dmPropertyName, dmProperty);
        if (dmProperty.isCalculation()) {
            Set<String> originalDMPropertyNameSet = dmProperty.getDependences();
            for (String originalDMPropertyName : originalDMPropertyNameSet) {
                AbstractEntityDirectModelDataIterator.collectReferenceDMPropertyFromDMProperty(referenceDMPropertyMap, originalDMPropertyName, allDMPropertyMap);
            }
        }
    }

    private Set<AbstractUnderDSFilter> collectUnPushDownDSFilters(Set<IPushdownFilter> dsFilters) {
        HashSet<AbstractUnderDSFilter> unPushDownDSFilters = new HashSet<AbstractUnderDSFilter>();
        if (dsFilters != null && !dsFilters.isEmpty()) {
            Iterator<IPushdownFilter> dsFilterIterator = dsFilters.iterator();
            block3: while (dsFilterIterator.hasNext()) {
                IPushdownFilter abstractUnderDSFilter = dsFilterIterator.next();
                if (!(abstractUnderDSFilter instanceof UnderDSDiscreteFilter)) continue;
                UnderDSDiscreteFilter underDSDiscreteFilter = (UnderDSDiscreteFilter)abstractUnderDSFilter;
                int fiscalYearStart = underDSDiscreteFilter.getFiscalYearStart();
                if (fiscalYearStart > 0) {
                    unPushDownDSFilters.add((AbstractUnderDSFilter)underDSDiscreteFilter);
                    dsFilterIterator.remove();
                    continue;
                }
                UnderDSDiscreteFilter.PartValue partValue = underDSDiscreteFilter.getPartValue();
                if (partValue == null) continue;
                switch (partValue) {
                    case DATE_EXACT: {
                        continue block3;
                    }
                }
                unPushDownDSFilters.add((AbstractUnderDSFilter)underDSDiscreteFilter);
                dsFilterIterator.remove();
            }
        }
        return unPushDownDSFilters;
    }

    private static List<FilterItem> changeDSFilterToFilterItem(Set<IPushdownFilter> dsFilters, Map<String, Property> dmPropertyMap) {
        List<FilterItem> newFilterItems = new ArrayList<FilterItem>();
        if (dsFilters == null || dsFilters.isEmpty()) {
            return newFilterItems;
        }
        for (IPushdownFilter dsFilter : dsFilters) {
            if (!(dsFilter instanceof AbstractUnderDSFilter)) continue;
            List<FilterItem> newSubFilterItems = new ArrayList<FilterItem>();
            DSFieldKey dsFilterFieldKey = ((AbstractUnderDSFilter)dsFilter).getField();
            Property dmProperty = dmPropertyMap.get(dsFilterFieldKey.getPropertyName());
            String dmPropertyName = dmProperty.getName();
            if (dsFilter instanceof UnderDSDiscreteFilter) {
                UnderDSDiscreteFilter discreteFilter = (UnderDSDiscreteFilter)dsFilter;
                List selectedValues = discreteFilter.getSelected();
                FilterItem filterItem = new FilterItem();
                filterItem.setProperty(dmPropertyName);
                filterItem.setValueMode(ValueMode.Const);
                filterItem.setCompareType(CompareType.APPOINTED);
                if (discreteFilter.isExclude()) {
                    filterItem.setCompareOp(FilterItem.CompareOp.NOT_IN);
                } else {
                    filterItem.setCompareOp(FilterItem.CompareOp.IN);
                }
                boolean hasNullValue = false;
                HashSet<String> selectedFilterItemValues = new HashSet<String>();
                for (String selectedValue : selectedValues) {
                    if ("".equals(selectedValue)) {
                        hasNullValue = true;
                        continue;
                    }
                    selectedFilterItemValues.add(selectedValue);
                }
                filterItem.setValue(JsonUtil.encodeToString(selectedFilterItemValues));
                newSubFilterItems.add(filterItem);
                if (hasNullValue) {
                    FilterItem nullValueFilterItem = new FilterItem();
                    nullValueFilterItem.setProperty(dmPropertyName);
                    nullValueFilterItem.setCompareType(CompareType.APPOINTED);
                    nullValueFilterItem.setValueMode(ValueMode.Const);
                    if (discreteFilter.isExclude()) {
                        filterItem.setLogicOp(FilterItem.LogicOp.AND);
                        nullValueFilterItem.setCompareOp(FilterItem.CompareOp.NOT_NULL);
                    } else {
                        filterItem.setLogicOp(FilterItem.LogicOp.OR);
                        nullValueFilterItem.setCompareOp(FilterItem.CompareOp.NULL);
                    }
                    newSubFilterItems.add(nullValueFilterItem);
                }
            } else if (dsFilter instanceof UnderDSContinuousFilter) {
                FilterItem filterItem;
                Object floor;
                UnderDSContinuousFilter continuousFilter = (UnderDSContinuousFilter)dsFilter;
                ArrayList<FilterItem> newSubFilterItems2 = new ArrayList<FilterItem>();
                Object ceiling = continuousFilter.getCeiling();
                if (ceiling != null) {
                    String value = null;
                    if (ceiling instanceof Calendar) {
                        Calendar calendar = (Calendar)ceiling;
                        value = calendar.getTimeInMillis() + "";
                    } else {
                        value = ceiling.toString();
                    }
                    FilterItem filterItem2 = new FilterItem();
                    filterItem2.setProperty(dmPropertyName);
                    filterItem2.setCompareType(CompareType.APPOINTED);
                    filterItem2.setValueMode(ValueMode.Const);
                    filterItem2.setCompareOp(FilterItem.CompareOp.LESS_EQUAL);
                    filterItem2.setValue(value);
                    newSubFilterItems2.add(filterItem2);
                }
                if ((floor = continuousFilter.getFloor()) != null) {
                    String value = null;
                    if (floor instanceof Calendar) {
                        Calendar calendar = (Calendar)floor;
                        value = calendar.getTimeInMillis() + "";
                    } else {
                        value = floor.toString();
                    }
                    filterItem = new FilterItem();
                    filterItem.setProperty(dmPropertyName);
                    filterItem.setCompareType(CompareType.APPOINTED);
                    filterItem.setValueMode(ValueMode.Const);
                    filterItem.setCompareOp(FilterItem.CompareOp.GREATER_EQUAL);
                    filterItem.setValue(value);
                    if (!newSubFilterItems2.isEmpty()) {
                        FilterItem lastFilterItem = (FilterItem)newSubFilterItems2.get(newSubFilterItems2.size() - 1);
                        lastFilterItem.setLogicOp(FilterItem.LogicOp.AND);
                    }
                    newSubFilterItems2.add(filterItem);
                }
                ArrayList<FilterItem> newSubFilterItems3 = new ArrayList<FilterItem>();
                if (continuousFilter.isContainNull()) {
                    filterItem = new FilterItem();
                    filterItem.setProperty(dmPropertyName);
                    filterItem.setCompareType(CompareType.APPOINTED);
                    filterItem.setValueMode(ValueMode.Const);
                    filterItem.setCompareOp(FilterItem.CompareOp.NULL);
                    newSubFilterItems3.add(filterItem);
                }
                newSubFilterItems = FilterItem.appendFilterItem(newSubFilterItems2, newSubFilterItems3, FilterItem.LogicOp.OR);
            }
            newFilterItems = FilterItem.appendFilterItem(newFilterItems, newSubFilterItems, FilterItem.LogicOp.AND);
        }
        return newFilterItems;
    }

    protected abstract void innerInit(Map<String, Property> var1, List<FilterItem> var2) throws AbstractDataSourceException, InterruptedException;
}

