/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.model.designtime;

import com.kingdee.bos.qing.data.exception.ModelParseException;
import com.kingdee.bos.qing.data.model.designtime.AbstractEntity;
import com.kingdee.bos.qing.data.model.designtime.AbstractSource;
import com.kingdee.bos.qing.data.model.designtime.BizUnionInnerEntityRelations;
import com.kingdee.bos.qing.data.model.designtime.FilterItem;
import com.kingdee.bos.qing.data.model.designtime.Relation;
import com.kingdee.bos.qing.data.model.designtime.ValueMode;
import com.kingdee.bos.qing.data.model.designtime.source.AbstractBizMetaSource;
import com.kingdee.bos.qing.data.model.designtime.source.DBSource;
import com.kingdee.bos.qing.data.util.SourceFactory;
import com.kingdee.bos.qing.filesystem.manager.FileFactory;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileVisitor;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.filesystem.stream.QingInputStream;
import com.kingdee.bos.qing.macro.domain.DesignTimeMacroRegister;
import com.kingdee.bos.qing.macro.domain.ICollectBizMetaSourceRefMacro;
import com.kingdee.bos.qing.macro.domain.IMacroRefable;
import com.kingdee.bos.qing.macro.util.MacroFormatHelper;
import com.kingdee.bos.qing.schedule.exception.ScheduleModelParseException;
import com.kingdee.bos.qing.schedule.model.Schedule;
import com.kingdee.bos.qing.util.CloseUtil;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.XmlUtil;
import java.io.Closeable;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import org.jdom2.Content;
import org.jdom2.Element;

public class Box
implements IMacroRefable {
    private static final String VERSION = "20170616";
    private Boolean tooMordern;
    private List<AbstractSource> sources;
    private List<AbstractEntity> entities;
    private List<Relation> relations;
    private List<BizUnionInnerEntityRelations> bizUnionInnerEntityRelations;
    private Schedule schedule;

    public List<AbstractSource> getSources() {
        return this.sources;
    }

    public void setSources(List<AbstractSource> sources) {
        this.sources = sources;
    }

    public List<AbstractEntity> getEntities() {
        return this.entities;
    }

    public void setEntities(List<AbstractEntity> entities) {
        this.entities = entities;
    }

    public List<Relation> getRelations() {
        return this.relations;
    }

    public void setRelations(List<Relation> relations) {
        this.relations = relations;
    }

    public Schedule getSchedule() {
        return this.schedule;
    }

    public void setSchedule(Schedule schedule) {
        this.schedule = schedule;
    }

    public void setBizUnionInnerEntityRelations(List<BizUnionInnerEntityRelations> bizUnionInnerEntityRelations) {
        this.bizUnionInnerEntityRelations = bizUnionInnerEntityRelations;
    }

    public Element toXml() {
        Element nodeSources = new Element("Sources");
        if (this.sources != null) {
            for (AbstractSource abstractSource : this.sources) {
                Element element = abstractSource.toXml();
                nodeSources.addContent((Content)element);
            }
        }
        Element nodeEntities = new Element("Entities");
        if (this.entities != null) {
            for (AbstractEntity abstractEntity : this.entities) {
                Element element = abstractEntity.toXml();
                if (null == element) continue;
                nodeEntities.addContent((Content)element);
            }
        }
        Element element = new Element("Relations");
        if (this.relations != null) {
            for (Relation relation : this.relations) {
                element.addContent((Content)relation.toXml());
            }
        }
        Element element2 = new Element("UnionEntityInnerRelations");
        if (this.bizUnionInnerEntityRelations != null) {
            for (BizUnionInnerEntityRelations innerRelations : this.bizUnionInnerEntityRelations) {
                element2.addContent((Content)innerRelations.toXml());
            }
        }
        Element element3 = new Element("ExtractSchedule");
        if (this.schedule != null) {
            this.schedule.toXml(element3);
        }
        Element xml = new Element("Data");
        xml.setAttribute("version", VERSION);
        xml.addContent((Content)nodeSources);
        xml.addContent((Content)element3);
        xml.addContent((Content)nodeEntities);
        xml.addContent((Content)element);
        xml.addContent((Content)element2);
        return xml;
    }

    public List<BizUnionInnerEntityRelations> getBizUnionInnerEntityRelations() {
        return this.bizUnionInnerEntityRelations;
    }

    public void fromFile(AbstractQingFileType qingFileType, String fileName, boolean isRemoveUnknownSourceNames) throws ModelParseException {
        Element contentElement = null;
        IQingFileVisitor fileVisitor = FileFactory.newFileVisitor((AbstractQingFileType)qingFileType, (String)fileName);
        QingInputStream inputStream = null;
        try {
            inputStream = fileVisitor.getInputStream();
            contentElement = XmlUtil.loadRootElement((InputStream)inputStream);
        }
        catch (Exception e) {
            try {
                throw new ModelParseException((Throwable)e);
            }
            catch (Throwable throwable) {
                CloseUtil.close((Closeable[])new Closeable[]{inputStream});
                throw throwable;
            }
        }
        CloseUtil.close((Closeable[])new Closeable[]{inputStream});
        this.fromXml(contentElement, isRemoveUnknownSourceNames);
    }

    public void fromXml(Element xml, boolean isRemoveUnknownSourceNames) throws ModelParseException {
        String modelVersion = xml.getAttributeValue("version");
        this.checkVersion(modelVersion);
        try {
            this.sources = new ArrayList<AbstractSource>();
            Element nodeSources = xml.getChild("Sources");
            Iterator itSources = nodeSources.getChildren().iterator();
            HashSet<String> unknownSourceNames = new HashSet<String>();
            while (itSources.hasNext()) {
                Element nodeSource = (Element)itSources.next();
                AbstractSource source = SourceFactory.instanceFromXml((Element)nodeSource);
                if (source != null) {
                    source.fromXml(nodeSource);
                    this.sources.add(source);
                    continue;
                }
                if (!isRemoveUnknownSourceNames) continue;
                unknownSourceNames.add(AbstractSource.getSourceName((Element)nodeSource));
            }
            this.entities = new ArrayList<AbstractEntity>();
            Element nodeEntities = xml.getChild("Entities");
            Iterator itEntities = nodeEntities.getChildren().iterator();
            HashSet<String> ignorEntityNames = new HashSet<String>();
            while (itEntities.hasNext()) {
                Element nodeEntity = (Element)itEntities.next();
                AbstractEntity entity = AbstractEntity.create(nodeEntity);
                entity.fromXml(nodeEntity, unknownSourceNames);
                if (!entity.isIgnore(unknownSourceNames)) {
                    this.entities.add(entity);
                    continue;
                }
                ignorEntityNames.add(entity.getName());
            }
            this.relations = new ArrayList<Relation>();
            Element nodeRelations = xml.getChild("Relations");
            for (Element nodeRelation : nodeRelations.getChildren()) {
                Relation relation = new Relation();
                relation.fromXml(nodeRelation);
                if (ignorEntityNames.contains(relation.getFromEntity()) || ignorEntityNames.contains(relation.getToEntity())) continue;
                this.relations.add(relation);
            }
            this.bizUnionInnerEntityRelations = new ArrayList<BizUnionInnerEntityRelations>();
            Element unionRelations = xml.getChild("UnionEntityInnerRelations");
            if (null != unionRelations) {
                for (Element innerRelationsElement : unionRelations.getChildren()) {
                    BizUnionInnerEntityRelations innerRelations = new BizUnionInnerEntityRelations();
                    innerRelations.fromXml(innerRelationsElement);
                    this.bizUnionInnerEntityRelations.add(innerRelations);
                }
            }
            this.schedule = Box.loadExtractSchedule(xml);
        }
        catch (ModelParseException ex) {
            if (Boolean.TRUE.equals(this.tooMordern)) {
                throw new ModelParseException("Maybe the persistent model:" + modelVersion + " is too mordern to parse. Runtime env:" + VERSION, (Throwable)ex);
            }
            throw ex;
        }
        catch (ScheduleModelParseException ex) {
            if (Boolean.TRUE.equals(this.tooMordern)) {
                throw new ModelParseException("Maybe the persistent model:" + modelVersion + " is too mordern to parse. Runtime env:" + VERSION, (Throwable)ex);
            }
            throw new ModelParseException("ScheduleModel parse fail", (Throwable)ex);
        }
    }

    private void checkVersion(String version) throws ModelParseException {
        int modelVersion;
        int runtimeVersion = Integer.parseInt(VERSION);
        try {
            modelVersion = Integer.parseInt(version);
        }
        catch (NumberFormatException ex) {
            throw new ModelParseException("Invalid version: " + version);
        }
        if (modelVersion > runtimeVersion) {
            this.tooMordern = Boolean.TRUE;
        }
    }

    public static Schedule loadExtractSchedule(Element xml) throws ScheduleModelParseException {
        Element nodeSchedule = xml.getChild("ExtractSchedule");
        Schedule schedule = new Schedule();
        schedule.fromXml(nodeSchedule);
        return schedule;
    }

    public AbstractSource getSource(String sourceName) {
        for (AbstractSource source : this.sources) {
            if (!source.getName().equals(sourceName)) continue;
            return source;
        }
        return null;
    }

    public Box copy() {
        Box box = new Box();
        Element element = this.toXml();
        try {
            box.fromXml(element, false);
        }
        catch (ModelParseException e) {
            LogUtil.error((String)e.getMessage(), (Throwable)e);
        }
        return box;
    }

    public List<String> collectMacroUid() {
        ArrayList<String> uidsInBox = new ArrayList<String>(10);
        for (AbstractSource source : this.sources) {
            if (source instanceof DBSource) {
                List userSQLs = ((DBSource)source).getUserSqls();
                if (userSQLs == null) continue;
                for (DBSource.UserSQL userSQL : userSQLs) {
                    String sql = userSQL.getContent();
                    uidsInBox.addAll(this.getUidInBoxFromUserSQL(sql));
                }
                continue;
            }
            if (!(source instanceof AbstractBizMetaSource)) continue;
            ICollectBizMetaSourceRefMacro collector = DesignTimeMacroRegister.getBizMetaSourceMacroRefCollector();
            List collectedIds = collector.collectMacroUId((AbstractBizMetaSource)source);
            uidsInBox.addAll(collectedIds);
        }
        for (AbstractEntity entity : this.entities) {
            List<FilterItem> filterItems = entity.getFilters();
            for (FilterItem filterItem : filterItems) {
                ValueMode valueMode = filterItem.getValueMode();
                if (valueMode != ValueMode.MacroVar) continue;
                uidsInBox.add(filterItem.getValue());
            }
        }
        return uidsInBox;
    }

    private List<String> getUidInBoxFromUserSQL(String sql) {
        Matcher matcher = MacroFormatHelper.matcher((String)sql);
        ArrayList<String> list = new ArrayList<String>(10);
        while (matcher.find()) {
            list.add(matcher.group());
        }
        return list;
    }
}

