/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.model.runtime;

import com.kingdee.bos.qing.common.grammar.expr.IExpr;
import com.kingdee.bos.qing.data.model.designtime.Property;
import com.kingdee.bos.qing.datasource.meta.DataType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RuntimeProperty {
    private Property property;
    private String entityName;
    private DataType inputDataType;
    private DataType outputDataType;
    private List<RuntimeProperty> dependences;
    private boolean childPropHideInAnalysis = true;
    private boolean isWhiteProperty = false;
    private Map<String, Object> runtimeValues = new HashMap<String, Object>();

    public RuntimeProperty(Property property) {
        this.property = property;
    }

    public void addRuntimeValue(String key, Object value) {
        this.runtimeValues.put(key, value);
    }

    public <T> T getRuntimeValue(String key, Class<T> tClass) {
        Object value = this.runtimeValues.get(key);
        if (null == value) {
            return null;
        }
        return tClass.cast(value);
    }

    public String getEntityName() {
        return this.entityName;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    public boolean isInvalid4Union() {
        return this.property.isInvalid4Union();
    }

    public Property getProperty() {
        return this.property;
    }

    public String getName() {
        return this.property.getName();
    }

    public String getGroup() {
        return this.property.getGroup();
    }

    public String getAssociateName() {
        return this.property.getAssociateName();
    }

    public String getAlias() {
        return this.property.getAlias();
    }

    public DataType getInputDataType() {
        return this.inputDataType;
    }

    public void setInputDataType(DataType inputDataType) {
        this.inputDataType = inputDataType;
    }

    public DataType getOutputDataType() {
        return this.outputDataType;
    }

    public void setOutputDataType(DataType outputDataType) {
        this.outputDataType = outputDataType;
    }

    public boolean isCalculation() {
        return this.property.isCalculation();
    }

    public boolean isInvalid4Parent() {
        return this.property.isInvalidForParent();
    }

    public boolean isDataModelSupported() {
        return this.property.isDataModelSupported();
    }

    public boolean isSelectProperty() {
        return this.property.isSelectProperty();
    }

    public Map<String, String> getEnumValue() {
        return this.property.getEnumValue();
    }

    public boolean isValidCalculation() {
        return this.property.isValidCalculation();
    }

    public IExpr getExpr() {
        return this.property.getParsedFormula();
    }

    public void setDependences(List<RuntimeProperty> dependences) {
        this.dependences = dependences;
    }

    public boolean isNotExisted() {
        return this.property.isNotExisted();
    }

    public List<RuntimeProperty> getDependences() {
        return this.dependences;
    }

    public boolean hasChild() {
        return this.property.isHasChild();
    }

    public String getParentProp() {
        if (null != this.property.getParent()) {
            return this.property.getParent().getName();
        }
        return null;
    }

    public Object getMetaField() {
        return this.property.getMetaField();
    }

    public boolean isSupportOrm() {
        return this.property.isSupportOrm() && !this.property.isNotExisted() && !this.property.isInvalid4Union();
    }

    public boolean isPkProperty() {
        return this.property.isPkProperty();
    }

    public boolean isParentPkProperty() {
        return this.property.isParentPkProperty();
    }

    public boolean isOutputSupported() {
        return this.property.isOutputProperty();
    }

    public boolean isChildPropHideInAnalysis() {
        return this.childPropHideInAnalysis;
    }

    public void setChildPropHideInAnalysis(boolean childPropHideInAnalysis) {
        this.childPropHideInAnalysis = childPropHideInAnalysis;
    }

    public boolean isWhiteProperty() {
        return this.isWhiteProperty;
    }

    public void setWhiteProperty(boolean isWhiteProperty) {
        this.isWhiteProperty = isWhiteProperty;
    }
}

