/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.model.runtime.compare.valueconvert;

import com.kingdee.bos.qing.data.model.designtime.FilterItem;
import com.kingdee.bos.qing.data.model.designtime.Property;
import com.kingdee.bos.qing.data.model.runtime.compare.valueconvert.ComparePrimaryDataValueHandlerDelegate;
import com.kingdee.bos.qing.data.util.valueconvert.IValueHandler;
import com.kingdee.bos.qing.data.util.valueconvert.ValueHandlerAdapter;
import com.kingdee.bos.qing.datasource.meta.DataType;
import java.sql.Date;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;

public class KylinDataValueHandlerDelegate
extends ComparePrimaryDataValueHandlerDelegate {
    private Property filterProperty;
    protected Map<String, IValueHandler> handlerMap;

    public KylinDataValueHandlerDelegate(DataType dataType, FilterItem.CompareOp op, Property filterProperty) {
        super(dataType, op);
        this.filterProperty = filterProperty;
        this.initKylinDataValueHandlerMap();
    }

    protected final void initKylinDataValueHandlerMap() {
        this.handlerMap = new HashMap<String, IValueHandler>();
        this.handlerMap.put("java.lang.Short", (IValueHandler)new IntegerValueHandler());
        this.handlerMap.put("java.lang.Integer", (IValueHandler)new IntegerValueHandler());
        this.handlerMap.put("java.lang.Long", (IValueHandler)new LongValueHandler());
        this.handlerMap.put("java.sql.Time", (IValueHandler)new DateTimeValueHandler());
        this.handlerMap.put("java.sql.Timestamp", (IValueHandler)new DateTimeValueHandler());
        this.handlerMap.put("java.util.Date", (IValueHandler)new DateValueHandler());
        this.handlerMap.put("java.sql.Date", (IValueHandler)new DateValueHandler());
    }

    public Object toRuntimeValue(Object originalValue) {
        try {
            String className = (String)this.filterProperty.getExtensionProps().get("COLUMN_CLASS_NAME");
            IValueHandler valueHandler = this.handlerMap.get(className);
            if (null != valueHandler) {
                return valueHandler.toRuntimeValue(originalValue);
            }
            return super.toRuntimeValue(originalValue);
        }
        catch (Exception e) {
            return super.toRuntimeValue(originalValue);
        }
    }

    public Object toDbFilterValue(Object runtimeValue) {
        try {
            String className = (String)this.filterProperty.getExtensionProps().get("COLUMN_CLASS_NAME");
            IValueHandler valueHandler = this.handlerMap.get(className);
            if (null != valueHandler) {
                return valueHandler.toDbFilterValue(runtimeValue);
            }
            return super.toDbFilterValue(runtimeValue);
        }
        catch (Exception e) {
            return super.toDbFilterValue(runtimeValue);
        }
    }

    public static class DateValueHandler
    extends ValueHandlerAdapter {
        public Object toRuntimeValue(Object originalValue) {
            String strValue = String.valueOf(originalValue);
            Long millis = Long.valueOf(strValue);
            return new Date(millis);
        }

        public Object toCloudEntityFilterValue(Object runtimeValue) {
            return runtimeValue;
        }
    }

    public static class DateTimeValueHandler
    extends ValueHandlerAdapter {
        public Object toRuntimeValue(Object originalValue) {
            String strValue = String.valueOf(originalValue);
            Long millis = Long.valueOf(strValue);
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(millis);
            return calendar;
        }

        public Object toCloudEntityFilterValue(Object runtimeValue) {
            return runtimeValue;
        }
    }

    public static class LongValueHandler
    extends ValueHandlerAdapter {
        public Object toRuntimeValue(Object originalValue) {
            return Long.parseLong(String.valueOf(originalValue));
        }
    }

    public static class IntegerValueHandler
    extends ValueHandlerAdapter {
        public Object toRuntimeValue(Object originalValue) {
            return Integer.parseInt(String.valueOf(originalValue));
        }
    }
}

