/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.model.runtime.mdd;

import com.kingdee.bos.qing.data.model.designtime.DesigningDataType;

public enum Datatype {
    INTEGER(3, "DBTYPE_I4", "A four-byte, signed integer: INTEGER", DesigningDataType.INT),
    DOUBLE(5, "DBTYPE_R8", "A double-precision floating-point value: Double", DesigningDataType.NUMBER),
    CURRENCY(6, "DBTYPE_CY", "A currency value: LARGE_INTEGER, Currency is a fixed-point number with four digits to the right of the decimal point. It is stored in an eight-byte signed integer, scaled by 10,000.", DesigningDataType.NUMBER),
    BOOLEAN(11, "DBTYPE_BOOL", "A Boolean value stored in the same way as in Automation: VARIANT_BOOL; 0 means false and ~0 (bitwise, the value is not 0; that is, all bits are set to 1) means true.", DesigningDataType.BOOLEAN),
    VARIANT(12, "DBTYPE_VARIANT", "An Automation VARIANT", DesigningDataType.STRING),
    UNSIGNED_SHORT(18, "DBTYPE_UI2", "A two-byte, unsigned integer", DesigningDataType.INT),
    UNSIGNED_INTEGER(19, "DBTYPE_UI4", "A four-byte, unsigned integer", DesigningDataType.INT),
    LARGE_INTEGER(20, "DBTYPE_I8", "An eight-byte, signed integer: LARGE_INTEGER", DesigningDataType.INT),
    STRING(130, "DBTYPE_WSTR", "A null-terminated Unicode character string: wchar_t[length]; If DBTYPE_WSTR is used by itself, the number of bytes allocated for the string, including the null-termination character, is specified by cbMaxLen in the DBBINDING structure. If DBTYPE_WSTR is combined with DBTYPE_BYREF, the number of bytes allocated for the string, including the null-termination character, is at least the length of the string plus two. In either case, the actual length of the string is determined from the bound length value. The maximum length of the string is the number of allocated bytes divided by sizeof(wchar_t) and truncated to the nearest integer.", DesigningDataType.STRING),
    ACCP(1000, "ACCP", "SAP BW Character", DesigningDataType.STRING),
    CHAR(1001, "CHAR", "SAP BW CHAR", DesigningDataType.STRING),
    CUKY(1002, "CUKY", "SAP BW CHAR", DesigningDataType.STRING),
    CURR(1003, "CURR", "SAP BW Currency - Packed decimal, Integer", DesigningDataType.NUMBER),
    DATS(1004, "DATS", "SAP BW Date", DesigningDataType.DATETIME),
    DEC(1005, "DEC", "SAP BW Decimal", DesigningDataType.NUMBER),
    FLTP(1006, "FLTP", "SAP BW Floating Point", DesigningDataType.NUMBER),
    INT1(1007, "INT1", "SAP BW Byte", DesigningDataType.INT),
    INT2(1008, "INT2", "SAP BW Small integer", DesigningDataType.INT),
    INT4(1009, "INT4", "SAP BW Integer", DesigningDataType.INT),
    LCHR(1010, "LCHR", "SAP BW Text", DesigningDataType.STRING),
    NUMC(1011, "NUMC", "SAP BW Numeric", DesigningDataType.NUMBER),
    PREC(1012, "PREC", "SAP BW Tiny Int", DesigningDataType.INT),
    QUAN(1013, "QUAN", "SAP BW QUAN Integer", DesigningDataType.INT),
    SSTR(1014, "SSTR", "SAP BW String", DesigningDataType.STRING),
    STRG(1015, "STRG", "SAP BW Long String", DesigningDataType.STRING),
    TIMS(1016, "TIMS", "SAP BW Time", DesigningDataType.DATETIME),
    VARC(1017, "VARC", "SAP BW Varchar", DesigningDataType.STRING),
    UNIT(1018, "UNIT", "SAP BW Long String for Units", DesigningDataType.STRING);

    private final int ordinal;
    private String dbTypeIndicator;
    private String description;
    private DesigningDataType designingDataType;

    private Datatype(int xmlaOrdinal, String dbTypeIndicator, String description, DesigningDataType designingDataType) {
        this.ordinal = xmlaOrdinal;
        this.dbTypeIndicator = dbTypeIndicator;
        this.description = description;
        this.designingDataType = designingDataType;
    }

    public String xmlaName() {
        return this.dbTypeIndicator;
    }

    public String getDescription() {
        return this.description;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public DesigningDataType getDesigningDataType() {
        return this.designingDataType;
    }
}

