/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.model.runtime.mdd;

import com.kingdee.bos.qing.data.model.designtime.AbstractDMViewItem;
import com.kingdee.bos.qing.data.model.designtime.Entity;
import com.kingdee.bos.qing.data.model.designtime.EntitySubView;
import com.kingdee.bos.qing.data.model.runtime.mdd.IHierarchy;
import com.kingdee.bos.qing.util.NameUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class Dimension {
    private final String name;
    private final String displayName;
    private final Type type;
    private final String defaultHierarchyUniqueName;
    private final int ordinal;
    private List<IHierarchy> hierarchies = new ArrayList<IHierarchy>();

    public Dimension(String name, String displayName, Type type, String defaultHierarchyUniqueName, int ordinal) {
        this.name = name;
        this.displayName = displayName;
        this.type = type;
        this.defaultHierarchyUniqueName = defaultHierarchyUniqueName;
        this.ordinal = ordinal;
    }

    public boolean hasHierarchy(String hierarchyName) {
        for (IHierarchy hierarchy : this.hierarchies) {
            if (!hierarchyName.equals(hierarchy.getName())) continue;
            return true;
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDefaultHierarchyUniqueName() {
        return this.defaultHierarchyUniqueName;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public Type getType() {
        return this.type;
    }

    public List<IHierarchy> getHierarchies() {
        return Collections.unmodifiableList(this.hierarchies);
    }

    public void addHierarchy(IHierarchy hierarchy) {
        this.hierarchies.add(hierarchy);
    }

    public void addAllHierarchy(List<IHierarchy> hierarchies) {
        this.hierarchies.addAll(hierarchies);
    }

    public void toDM(Entity entity) {
        if (!this.hierarchies.isEmpty()) {
            EntitySubView entitySubView = null;
            if (this.hierarchies.size() > 1) {
                entitySubView = new EntitySubView();
                entitySubView.setName(NameUtil.getPureName((String)this.name, new HashMap()));
                entitySubView.setAlias(this.displayName);
                entitySubView.setViewItems(new ArrayList<AbstractDMViewItem>());
                if (entity.getSubViews() == null) {
                    entity.setSubViews(new ArrayList<EntitySubView>());
                }
                entity.getSubViews().add(entitySubView);
            }
            for (IHierarchy hierarchy : this.hierarchies) {
                hierarchy.toDM(entity, entitySubView);
            }
        }
    }

    public static enum Type {
        UNKNOWN(0),
        TIME(1),
        MEASURE(2),
        OTHER(3),
        QUANTITATIVE(5),
        ACCOUNTS(6),
        CUSTOMERS(7),
        PRODUCTS(8),
        SCENARIO(9),
        UTILITY(10),
        CURRENCY(11),
        RATES(12),
        CHANNEL(13),
        PROMOTION(14),
        ORGANIZATION(15),
        BILL_OF_MATERIALS(16),
        GEOGRAPHY(17);

        private final int xmlaOrdinal;

        private Type(int xmlaOrdinal) {
            this.xmlaOrdinal = xmlaOrdinal;
        }

        public String xmlaName() {
            return "MD_DIMTYPE_" + this.name();
        }

        public String getDescription() {
            return "";
        }

        public int xmlaOrdinal() {
            return this.xmlaOrdinal;
        }
    }
}

