/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.model.runtime.mdd;

import com.kingdee.bos.qing.data.model.designtime.AbstractDMViewItem;
import com.kingdee.bos.qing.data.model.designtime.DMGroupItemView;
import com.kingdee.bos.qing.data.model.designtime.DesigningDataType;
import com.kingdee.bos.qing.data.model.designtime.Entity;
import com.kingdee.bos.qing.data.model.designtime.EntitySubView;
import com.kingdee.bos.qing.data.model.designtime.Parild;
import com.kingdee.bos.qing.data.model.designtime.Property;
import com.kingdee.bos.qing.data.model.runtime.mdd.IHierarchy;
import com.kingdee.bos.qing.util.NameUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public class PCDHierarchy
implements IHierarchy {
    private final String name;
    private final String displayName;
    private final boolean isNecessary;
    private final PCDProperty idProperty;
    private final PCDProperty parentIdProperty;
    private final PCDProperty displayProperty;

    public PCDHierarchy(String name, String displayName, PCDProperty idProperty, PCDProperty parentIdProperty, PCDProperty displayProperty, boolean isNecessary) {
        this.name = name;
        this.displayName = displayName;
        this.idProperty = idProperty;
        this.parentIdProperty = parentIdProperty;
        this.displayProperty = displayProperty;
        this.isNecessary = isNecessary;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    public PCDProperty getIdProperty() {
        return this.idProperty;
    }

    public PCDProperty getParentIdProperty() {
        return this.parentIdProperty;
    }

    public PCDProperty getDisplayProperty() {
        return this.displayProperty;
    }

    public boolean isNecessary() {
        return this.isNecessary;
    }

    @Override
    public void toDM(Entity entity, EntitySubView entitySubView) {
        String pcdName = NameUtil.getPureName((String)this.name, new HashMap());
        HashSet<String> fieldKeys = new HashSet<String>();
        Property pcdIdProperty = this.idProperty.toDM();
        pcdIdProperty.setGroup(pcdName);
        entity.getProperties().add(pcdIdProperty);
        fieldKeys.add(pcdIdProperty.getName());
        Property pcdPIdProperty = this.parentIdProperty.toDM();
        pcdPIdProperty.setGroup(pcdName);
        entity.getProperties().add(pcdPIdProperty);
        fieldKeys.add(pcdPIdProperty.getName());
        Property pcdNameProperty = this.displayProperty.toDM();
        pcdNameProperty.setGroup(pcdName);
        if (!fieldKeys.contains(pcdNameProperty.getName())) {
            entity.getProperties().add(pcdNameProperty);
            fieldKeys.add(pcdNameProperty.getName());
        }
        Parild parild = new Parild();
        parild.setNecessary(this.isNecessary ? Parild.Necessary.Indispensable : Parild.Necessary.RootRepresented);
        parild.setName(pcdName);
        parild.setAssociateName(this.name);
        parild.setAlias(this.displayName);
        parild.setIdField(pcdIdProperty.getName());
        parild.setParentIdField(pcdPIdProperty.getName());
        parild.setDefaultDisplayField(pcdNameProperty.getName());
        parild.setSortAccordingField(pcdNameProperty.getName());
        if (entity.getParilds() == null) {
            entity.setParilds(new ArrayList<Parild>());
        }
        entity.getParilds().add(parild);
        if (entitySubView != null) {
            for (String fieldKey : fieldKeys) {
                entitySubView.getViewItems().add(new DMGroupItemView(fieldKey));
            }
        } else {
            if (entity.getViewItems() == null) {
                entity.setViewItems(new ArrayList<AbstractDMViewItem>());
            }
            for (String fieldKey : fieldKeys) {
                entity.getViewItems().add(new DMGroupItemView(fieldKey));
            }
        }
    }

    public static class PCDProperty {
        private String name;
        private String displayName;

        public PCDProperty(String name, String displayName) {
            this.name = name;
            this.displayName = displayName;
        }

        public String getName() {
            return this.name;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public Property toDM() {
            Property property = new Property();
            property.setName(NameUtil.getPureName((String)this.name, new HashMap()));
            property.setAssociateName(this.name);
            property.setAlias(this.displayName);
            property.setDataType(DesigningDataType.STRING);
            property.setAppointedDataType(DesigningDataType.STRING);
            return property;
        }
    }
}

