/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.model.runtime.process;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.data.model.designtime.AbstractEntity;
import com.kingdee.bos.qing.data.model.designtime.AbstractSource;
import com.kingdee.bos.qing.data.model.designtime.Box;
import com.kingdee.bos.qing.data.model.designtime.EntityType;
import com.kingdee.bos.qing.data.model.runtime.process.BoxFixScene;
import com.kingdee.bos.qing.data.model.runtime.process.EntityFixProcessable;
import com.kingdee.bos.qing.data.model.runtime.process.FixEntityProcess;
import com.kingdee.bos.qing.data.model.runtime.process.FixUnionEntityProcess;
import com.kingdee.bos.qing.data.model.vo.DesigntimeDataObject;
import java.util.HashMap;
import java.util.Map;

public class FixAbstractEntityProcess {
    private Map<EntityType, EntityFixProcessable> entityFixerMap = new HashMap<EntityType, EntityFixProcessable>();

    public FixAbstractEntityProcess(QingContext qingContext, Box box, BoxFixScene scene) {
        this.entityFixerMap.put(EntityType.SINGLE, new FixEntityProcess(qingContext, box, scene));
        this.entityFixerMap.put(EntityType.COMMON_UNION, new FixUnionEntityProcess(qingContext, box, scene));
    }

    public boolean process(AbstractEntity entity, Map<String, AbstractSource> sourcesMap, Map<String, AbstractEntity> entitysMap) {
        return this.process(entity, sourcesMap, new HashMap<String, DesigntimeDataObject>(), entitysMap, new HashMap<String, Boolean>());
    }

    public boolean process(AbstractEntity abstractEntity, Map<String, AbstractSource> sourcesMap, Map<String, DesigntimeDataObject> designtimeDataObjectMap, Map<String, AbstractEntity> entitysMap, Map<String, Boolean> hasFixEntity) {
        if (abstractEntity == null) {
            return true;
        }
        String entityName = abstractEntity.getName();
        Boolean fixEntity = hasFixEntity.get(entityName);
        if (fixEntity != null) {
            return fixEntity;
        }
        EntityFixProcessable entityFixer = this.entityFixerMap.get((Object)abstractEntity.getEntityType());
        boolean isDeleteEntity = entityFixer.process(this, abstractEntity, sourcesMap, designtimeDataObjectMap, entitysMap, hasFixEntity);
        hasFixEntity.put(entityName, isDeleteEntity);
        return isDeleteEntity;
    }
}

