/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.model.runtime.process;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.data.domain.source.AbstractDataSourceDomain;
import com.kingdee.bos.qing.data.domain.source.SourceDomainFactory;
import com.kingdee.bos.qing.data.exception.AbstractMacroException;
import com.kingdee.bos.qing.data.exception.UnSupportDataSourceException;
import com.kingdee.bos.qing.data.exception.db.DBKSQLExcuseException;
import com.kingdee.bos.qing.data.exception.db.DBKSQLNotSupportException;
import com.kingdee.bos.qing.data.exception.db.DBSPExecuteException;
import com.kingdee.bos.qing.data.exception.db.DBSPNotFoundResultSetException;
import com.kingdee.bos.qing.data.exception.db.DBSPNotSupportException;
import com.kingdee.bos.qing.data.exception.db.DBSQLExcuseException;
import com.kingdee.bos.qing.data.exception.macro.MacroDBUnsetException;
import com.kingdee.bos.qing.data.exception.macro.MacroNotFoundException;
import com.kingdee.bos.qing.data.model.designtime.AbstractSource;
import com.kingdee.bos.qing.data.model.designtime.Entity;
import com.kingdee.bos.qing.data.model.designtime.EntityErrorInfo;
import com.kingdee.bos.qing.data.model.designtime.EntityErrorState;
import com.kingdee.bos.qing.data.model.designtime.UnionEntity;
import com.kingdee.bos.qing.data.model.runtime.process.BoxFixScene;
import com.kingdee.bos.qing.data.model.runtime.process.EntityFixContext;
import com.kingdee.bos.qing.data.model.runtime.process.FixedEntityGroup;
import com.kingdee.bos.qing.data.model.runtime.process.SubUnionEntityContext;
import com.kingdee.bos.qing.data.model.vo.DesigntimeDataObject;
import com.kingdee.bos.qing.data.util.DesignTimeDataObjectUtil;
import com.kingdee.bos.qing.util.LogUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UnionEntityFixContext {
    private List<UnionEntity> unionEntities;
    private Map<String, SubUnionEntityContext> subUnionEntityContextMap = new HashMap<String, SubUnionEntityContext>();
    private Map<String, UnionEntity> unionEntityMap = new HashMap<String, UnionEntity>();
    private List<FixedEntityGroup> fixedEntityGroups = new ArrayList<FixedEntityGroup>();
    private BoxFixScene fixScene;
    private AbstractDataSourceDomain dataSourceDomain;

    public UnionEntityFixContext(List<UnionEntity> unionEntityGroup, BoxFixScene boxFixScene) {
        this.unionEntities = unionEntityGroup;
        this.fixScene = boxFixScene;
    }

    public BoxFixScene getFixScene() {
        return this.fixScene;
    }

    public List<UnionEntity> getUnionEntities() {
        return this.unionEntities;
    }

    public UnionEntity getUnionEntity(String unionEntityName) {
        return this.unionEntityMap.get(unionEntityName);
    }

    public SubUnionEntityContext getSubContext(String unionEntityName) {
        return this.subUnionEntityContextMap.get(unionEntityName);
    }

    public EntityFixContext getBizEntityFixContext(String bizEntityName) {
        for (SubUnionEntityContext subUnionEntityContext : this.subUnionEntityContextMap.values()) {
            if (!subUnionEntityContext.containsEntity(bizEntityName)) continue;
            return subUnionEntityContext.getEntityFixContext(bizEntityName);
        }
        return null;
    }

    public void prepare(QingContext qingContext, Map<String, DesigntimeDataObject> designtimeDataObjectMap, AbstractSource source) {
        this.initSourceDomain(source);
        for (UnionEntity unionEntity : this.unionEntities) {
            SubUnionEntityContext subUnionEntityContext = new SubUnionEntityContext(unionEntity);
            subUnionEntityContext.prepare();
            this.subUnionEntityContextMap.put(unionEntity.getName(), subUnionEntityContext);
            this.unionEntityMap.put(unionEntity.getName(), unionEntity);
        }
        this.fixedEntityGroups = this.convertBizUnionToEntityGroup();
        this.prepareEntityMetaIfNotExist(qingContext, designtimeDataObjectMap, source);
    }

    public List<FixedEntityGroup> getFixedEntityGroups() {
        return this.fixedEntityGroups;
    }

    public AbstractDataSourceDomain getDataSourceDomain() {
        return this.dataSourceDomain;
    }

    private void initSourceDomain(AbstractSource source) {
        if (this.dataSourceDomain == null) {
            this.dataSourceDomain = null;
            try {
                this.dataSourceDomain = SourceDomainFactory.getSourceDomain(source);
            }
            catch (UnSupportDataSourceException e) {
                LogUtil.error((String)("not supported data source: " + source.getType()), (Throwable)e);
                return;
            }
        }
    }

    private void prepareEntityMetaIfNotExist(QingContext qingContext, Map<String, DesigntimeDataObject> designtimeDataObjectMap, AbstractSource source) {
        for (FixedEntityGroup entityGroup : this.fixedEntityGroups) {
            Entity rootEntity = entityGroup.getRootEntity();
            String key = source.getName() + rootEntity.getAssociateName();
            DesigntimeDataObject designtimeDataObject = designtimeDataObjectMap.get(key);
            if (null != designtimeDataObject) {
                entityGroup.setLiveEntityMeta(designtimeDataObject);
                continue;
            }
            try {
                designtimeDataObject = DesignTimeDataObjectUtil.loadAndCache(qingContext, rootEntity.getAssociateName(), source, this.dataSourceDomain, this.fixScene);
                if (null == designtimeDataObject) continue;
                designtimeDataObjectMap.put(key, designtimeDataObject);
                entityGroup.setLiveEntityMeta(designtimeDataObject);
            }
            catch (AbstractMacroException e) {
                this.setEntityMacroErrorState(qingContext, e, rootEntity);
            }
            catch (DBKSQLNotSupportException e) {
                rootEntity.setErrorInfo(new EntityErrorInfo(EntityErrorState.KSQL_NOT_SUPPORT));
            }
            catch (DBSPNotSupportException e) {
                rootEntity.setErrorInfo(new EntityErrorInfo(EntityErrorState.STORED_PROCEDURE_NOT_SUPPORT));
            }
            catch (DBSQLExcuseException e) {
                rootEntity.setErrorInfo(new EntityErrorInfo(EntityErrorState.SQL_EXECUTE_EXCEPTION));
            }
            catch (DBSPExecuteException e) {
                rootEntity.setErrorInfo(new EntityErrorInfo(EntityErrorState.SP_EXECUTE_EXCEPTION));
            }
            catch (DBKSQLExcuseException e) {
                rootEntity.setErrorInfo(new EntityErrorInfo(EntityErrorState.KSQL_EXECUTE_EXCEPTION));
            }
            catch (DBSPNotFoundResultSetException e) {
                rootEntity.setErrorInfo(new EntityErrorInfo(EntityErrorState.SP_EXECUTE_EXCEPTION));
            }
        }
    }

    private void setEntityMacroErrorState(QingContext qingContext, AbstractMacroException e, Entity dmEntity) {
        if (e instanceof MacroDBUnsetException) {
            EntityErrorInfo dbUnsetErrInfo = new EntityErrorInfo(EntityErrorState.MACROERROR_DBUNSET);
            String dbUnsetDesc = EntityErrorState.MACROERROR_DBUNSET.getI18n(qingContext);
            dbUnsetErrInfo.setErrorDesc(dbUnsetDesc.replace("#1", e.getMessage()));
            dbUnsetErrInfo.addCustomInfo("MacroName", e.getMessage());
            dmEntity.setErrorInfo(dbUnsetErrInfo);
        } else if (e instanceof MacroNotFoundException) {
            EntityErrorInfo macroNotFoundErrInfo = new EntityErrorInfo(EntityErrorState.MACROERROR_NOTFOUND);
            String notFoundDesc = EntityErrorState.MACROERROR_NOTFOUND.getI18n(qingContext);
            macroNotFoundErrInfo.setErrorDesc(notFoundDesc.replace("#1", e.getMessage()));
            macroNotFoundErrInfo.addCustomInfo("MacroId", e.getMessage());
            dmEntity.setErrorInfo(macroNotFoundErrInfo);
        }
    }

    private List<FixedEntityGroup> convertBizUnionToEntityGroup() {
        ArrayList<FixedEntityGroup> groupList = new ArrayList<FixedEntityGroup>(10);
        UnionEntity root = this.unionEntities.get(0);
        int mergeSize = root.getChildren().size();
        for (int location = 0; location < mergeSize; ++location) {
            FixedEntityGroup entityGroup = new FixedEntityGroup();
            ArrayList<Entity> entities = new ArrayList<Entity>();
            for (int i = 0; i < this.unionEntities.size(); ++i) {
                Entity entity = this.findEntityByLocation(this.unionEntities.get(i), location);
                if (null == entity) continue;
                entities.add(entity);
            }
            entityGroup.setEntities(entities);
            groupList.add(entityGroup);
        }
        return groupList;
    }

    private Entity findEntityByLocation(UnionEntity unionEntity, int location) {
        List<Entity> currentUnionEntities = unionEntity.getChildren();
        for (Entity entity : currentUnionEntities) {
            if (entity.getUnionLocation() != location) continue;
            return entity;
        }
        return null;
    }
}

