/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.service;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.data.domain.unionsource.EntityExtractContext;
import com.kingdee.bos.qing.data.domain.unionsource.impl.SimpleEntityDataService;
import com.kingdee.bos.qing.data.domain.unionsource.impl.UnionEntityDataService;
import com.kingdee.bos.qing.data.exception.AbstractSourceException;
import com.kingdee.bos.qing.data.model.designtime.AbstractEntity;
import com.kingdee.bos.qing.data.model.designtime.Entity;
import com.kingdee.bos.qing.data.model.designtime.UnionEntity;
import com.kingdee.bos.qing.data.model.vo.Entites;
import com.kingdee.bos.qing.data.model.vo.PreviewDataModel;
import com.kingdee.bos.qing.data.model.vo.Sources;
import com.kingdee.bos.qing.data.service.IEntityDataService;
import com.kingdee.bos.qing.datasource.exception.DataSourcePersistenceException;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileVisitor;
import java.util.Map;

public class EntityDataServiceFactory {
    public static IEntityDataService newDataService(AbstractEntity entity) {
        if (entity instanceof Entity) {
            return new SimpleEntityDataService((Entity)entity);
        }
        if (entity instanceof UnionEntity) {
            return new UnionEntityDataService((UnionEntity)entity);
        }
        return new UnkownEntityDataService();
    }

    private static class UnkownEntityDataService
    implements IEntityDataService {
        private UnkownEntityDataService() {
        }

        @Override
        public String extractEntityData(EntityExtractContext context) throws AbstractSourceException, DataSourcePersistenceException, AbstractQingIntegratedException, InterruptedException {
            return null;
        }

        @Override
        public PreviewDataModel getPreviewData(QingContext qingContext, int previewRows, Entites entities, Sources sources, Map<Entity, IQingFileVisitor> qingFileVisitorMap) throws AbstractSourceException, AbstractQingIntegratedException {
            return null;
        }

        @Override
        public long getDataCount(QingContext qingContext, Entites entities, Sources sources, Map<Entity, IQingFileVisitor> qingFileVisitorMap) throws AbstractSourceException, AbstractQingIntegratedException {
            return 0L;
        }
    }
}

