/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.util;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.framework.server.task.ServerRequestInvokeContext;
import com.kingdee.bos.qing.data.domain.source.AbstractDataSourceDomain;
import com.kingdee.bos.qing.data.exception.AbstractMacroException;
import com.kingdee.bos.qing.data.exception.AbstractSourceException;
import com.kingdee.bos.qing.data.exception.db.DBKSQLExcuseException;
import com.kingdee.bos.qing.data.exception.db.DBKSQLNotSupportException;
import com.kingdee.bos.qing.data.exception.db.DBSPExecuteException;
import com.kingdee.bos.qing.data.exception.db.DBSPNotFoundResultSetException;
import com.kingdee.bos.qing.data.exception.db.DBSPNotSupportException;
import com.kingdee.bos.qing.data.exception.db.DBSQLExcuseException;
import com.kingdee.bos.qing.data.model.designtime.AbstractSource;
import com.kingdee.bos.qing.data.model.designtime.DesignObjectGlobalJvmCache;
import com.kingdee.bos.qing.data.model.designtime.SourceType;
import com.kingdee.bos.qing.data.model.runtime.process.BoxFixScene;
import com.kingdee.bos.qing.data.model.vo.DesigntimeDataObject;
import com.kingdee.bos.qing.util.LogUtil;

public class DesignTimeDataObjectUtil {
    public static DesigntimeDataObject loadAndCache(QingContext qingContext, String topEntityAssociateName, AbstractSource source, AbstractDataSourceDomain sourceDomain, BoxFixScene fixScene) throws AbstractMacroException, DBKSQLNotSupportException, DBSPNotSupportException, DBSQLExcuseException, DBKSQLExcuseException, DBSPExecuteException, DBSPNotFoundResultSetException {
        DesigntimeDataObject designtimeDataObject = null;
        try {
            String clientId = ServerRequestInvokeContext.staticGetClientID();
            if (null != clientId && sourceDomain.isDesignDataObjCachable() && (fixScene == BoxFixScene.preview && source.getType() != SourceType.BizMeta || fixScene == BoxFixScene.datamodeling)) {
                designtimeDataObject = DesignObjectGlobalJvmCache.getDesignDataObj(clientId, topEntityAssociateName);
                if (null == designtimeDataObject) {
                    designtimeDataObject = sourceDomain.getDesigntimeDataObject(qingContext, source, topEntityAssociateName);
                    DesignObjectGlobalJvmCache.cacheDesignDataObj(clientId, topEntityAssociateName, designtimeDataObject);
                }
            } else {
                designtimeDataObject = sourceDomain.getDesigntimeDataObject(qingContext, source, topEntityAssociateName);
            }
        }
        catch (AbstractMacroException e) {
            throw e;
        }
        catch (DBKSQLNotSupportException e) {
            throw e;
        }
        catch (DBSPNotSupportException e) {
            throw e;
        }
        catch (DBSPNotFoundResultSetException e) {
            throw e;
        }
        catch (DBSQLExcuseException e) {
            throw e;
        }
        catch (DBKSQLExcuseException e) {
            throw e;
        }
        catch (DBSPExecuteException e) {
            throw e;
        }
        catch (AbstractSourceException e) {
            LogUtil.error((String)"\u6570\u636e\u8868\u574f\u4e86", (Throwable)e);
        }
        catch (AbstractQingIntegratedException e) {
            LogUtil.error((String)"\u6570\u636e\u8868\u574f\u4e86", (Throwable)e);
        }
        return designtimeDataObject;
    }
}

