/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.bill.preparedata.handler;

import com.kingdee.bos.qing.bill.data.QueryDataProvider;
import com.kingdee.bos.qing.bill.preparedata.BillPrepareDataContext;
import com.kingdee.bos.qing.common.cache.AbstractDataSource;
import com.kingdee.bos.qing.common.cache.FormDataSource;
import com.kingdee.bos.qing.common.cache.ISessionCacheable;
import com.kingdee.bos.qing.common.cache.LinkageFormInfo;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.context.QingIntegratedContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.exception.AbstractQingException;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.exception.IntegratedRuntimeException;
import com.kingdee.bos.qing.common.lock.ILock;
import com.kingdee.bos.qing.common.lock.LockFactory;
import com.kingdee.bos.qing.common.session.IQingSession;
import com.kingdee.bos.qing.common.session.QingSessionUtil;
import com.kingdee.bos.qing.data.model.designtime.AbstractEntity;
import com.kingdee.bos.qing.datasource.exception.DataSourcePersistenceException;
import com.kingdee.bos.qing.datasource.meta.MetaInfo;
import com.kingdee.bos.qing.datasource.spec.qs.QSDataSourceWriter;
import com.kingdee.bos.qing.filesystem.manager.FileFactory;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFile;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileVisitor;
import com.kingdee.bos.qing.filesystem.manager.api.IWriteCall;
import com.kingdee.bos.qing.filesystem.manager.localimpl.LocalPersistentQingFile;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingPersistentFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingTempFileType;
import com.kingdee.bos.qing.macro.MacroUtil;
import com.kingdee.bos.qing.macro.exception.MacroException;
import com.kingdee.bos.qing.preparedata.cache.ProgressModel;
import com.kingdee.bos.qing.preparedata.exception.BillFormException;
import com.kingdee.bos.qing.preparedata.exception.PrepareDataException;
import com.kingdee.bos.qing.preparedata.exception.PublishedPrepareDataException;
import com.kingdee.bos.qing.preparedata.handler.AbstractPrepareDataHandler;
import com.kingdee.bos.qing.preparedata.handler.BillFormProgressProcessor;
import com.kingdee.bos.qing.preparedata.handler.budget.BudgetDataProvider;
import com.kingdee.bos.qing.preparedata.handler.controller.ControllerDataProvider;
import com.kingdee.bos.qing.preparedata.handler.controller.model.QingMeta;
import com.kingdee.bos.qing.preparedata.handler.publish.IPublishDataPrepareHandler;
import com.kingdee.bos.qing.preparedata.handler.publish.PublishPrepareDataContext;
import com.kingdee.bos.qing.preparedata.model.BudgetDataSource;
import com.kingdee.bos.qing.preparedata.model.ControllerDataSource;
import com.kingdee.bos.qing.preparedata.model.Pager;
import com.kingdee.bos.qing.preparedata.preparedatacontext.IPrepareDataContext;
import com.kingdee.bos.qing.preparedata.task.ExtractDataLock;
import com.kingdee.bos.qing.preparedata.util.QueryUtil;
import com.kingdee.bos.qing.publish.dao.BillManagerDao;
import com.kingdee.bos.qing.publish.model.BillModel;
import com.kingdee.bos.qing.publish.model.PublishPO;
import com.kingdee.bos.qing.util.CloseUtil;
import com.kingdee.bos.qing.util.IOUtil;
import com.kingdee.bos.qing.util.LinkageFormInfoHelper;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.web.etl.model.AbstractExtractParameters;
import com.kingdee.bos.qing.web.etl.model.BudgetPageParameters;
import com.kingdee.bos.qing.web.etl.model.ControllerPageParameters;
import com.kingdee.bos.qing.web.etl.model.QueryPageParameters;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;

public class BillFormPrepareDataHandler
extends AbstractPrepareDataHandler
implements IPublishDataPrepareHandler {
    private QingContext qingContext;
    private IDBExcuter dbExcuter;
    private BillManagerDao billManagerDao;
    private ProgressModel progressModel;
    private BillFormProgressProcessor.IBillFormPrepareDataCallBack callBackFunction;

    public BillFormPrepareDataHandler(IPrepareDataContext prepareContext) {
        super(prepareContext);
        this.progressModel = prepareContext.getProgressModel();
        this.qingContext = prepareContext.getQingContext();
        this.dbExcuter = prepareContext.getDBExecuter();
        if (prepareContext instanceof BillPrepareDataContext) {
            this.callBackFunction = ((BillPrepareDataContext)prepareContext).getBillPrepareDataCallBackImpl();
        } else if (prepareContext instanceof PublishPrepareDataContext) {
            BillPrepareDataContext billPrepareDataContext = new BillPrepareDataContext();
            this.callBackFunction = billPrepareDataContext.getBillPrepareDataCallBackImpl();
            billPrepareDataContext.setDbExcuter(prepareContext.getDBExecuter());
            billPrepareDataContext.setQingContext(prepareContext.getQingContext());
            billPrepareDataContext.setTx(prepareContext.getTransManagement());
            billPrepareDataContext.setScheduleEngine(prepareContext.getScheduleEngine());
            billPrepareDataContext.setDealProgresss(prepareContext.isDealProgresss());
            billPrepareDataContext.setProgressModel(prepareContext.getProgressModel());
            billPrepareDataContext.setStartBySchedule(prepareContext.isStartBySchedule());
            billPrepareDataContext.setTag(prepareContext.getTag());
            this.prepareContext = billPrepareDataContext;
            PublishPrepareDataContext publishPrepareDataContext = (PublishPrepareDataContext)prepareContext;
            publishPrepareDataContext.setGeneralPrepareDataContext((IPrepareDataContext)billPrepareDataContext);
        }
    }

    private BillManagerDao getBillManagerDao() {
        if (this.billManagerDao == null) {
            this.billManagerDao = new BillManagerDao(this.dbExcuter);
        }
        return this.billManagerDao;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createQueryDataSource(String tag, QSDataSourceWriter dataSourceWriter, IQingFile dataFile, QueryPageParameters queryPageParameters, String originalCreatorId) throws PrepareDataException, DataSourcePersistenceException, InterruptedException, MacroException {
        FormDataSource dataSource = new FormDataSource(tag, (AbstractQingFileType)QingTempFileType.TEMP_QS, dataFile.getName());
        dataSource.setExtractDataTime(System.currentTimeMillis());
        dataSource.setOriginalCreatorId(originalCreatorId);
        String macroFilterItems = queryPageParameters.getMacroFilterItems();
        if (macroFilterItems != null) {
            String currentOrg = queryPageParameters.getCurrnetorg();
            queryPageParameters.setFilterItems(MacroUtil.parseMacroFilter(currentOrg, macroFilterItems));
        }
        QueryDataProvider dataProvider = QueryDataProvider.newInstance(this.qingContext, queryPageParameters);
        String uipk = queryPageParameters.getUipk();
        LinkageFormInfoHelper linkageFormInfoHelper = new LinkageFormInfoHelper();
        AbstractEntity entity = linkageFormInfoHelper.getEntityByUipk(uipk);
        LinkageFormInfo linkageFormInfo = null;
        String dataSourceType = queryPageParameters.getData().get("dataSourceType");
        linkageFormInfo = dataSourceType == null || !dataSourceType.equals("EntityType") ? LinkageFormInfoHelper.collectLinkageFormInfo(entity, LinkageFormInfoHelper.LinkageTypeEnum.EMBED) : LinkageFormInfoHelper.collectLinkageFormInfo(entity, LinkageFormInfoHelper.LinkageTypeEnum.EMBED_EXT);
        if (null != linkageFormInfo) {
            dataSource.addLinkageFormInfo(entity.getName(), linkageFormInfo);
        }
        try {
            BillFormProgressProcessor billFormProgressProcessor = this.callBackFunction.start();
            MetaInfo metaInfo = dataProvider.getMeta();
            dataSourceWriter.start(metaInfo);
            Pager pager = null;
            do {
                pager = dataProvider.nextPage();
                List<Object[]> datas = pager.getData();
                for (Object[] data : datas) {
                    dataSourceWriter.writeData(data);
                    billFormProgressProcessor.dealOneRow();
                }
            } while (pager.hasNextPage());
            billFormProgressProcessor.dealtAllRows();
        }
        finally {
            dataProvider.dispose();
        }
        dataSourceWriter.finishWriteData();
        IQingSession qingSession = QingSessionUtil.getQingSessionImpl();
        qingSession.setCache((ISessionCacheable)dataSource);
    }

    private void createBudgetDataSource(String tag, IQingFile dataFile, BudgetPageParameters pageParameters, String originalCreatorId) throws BillFormException {
        QingIntegratedContext qingIntegratedContext = (QingIntegratedContext)this.qingContext;
        BudgetDataProvider dataProvider = new BudgetDataProvider(tag, qingIntegratedContext.getBosContext(), pageParameters);
        QingMeta qingMeta = dataProvider.getQingMeta();
        List<String> fileList = dataProvider.getFileList();
        Map<String, List<String>> filter = dataProvider.getFilter();
        if (fileList.size() == 0) {
            LogUtil.debug((String)"fileList is null.");
            throw new BillFormException("fileList is null.");
        }
        ArrayList<String> tempFilelist = new ArrayList<String>();
        for (String fileName : fileList) {
            LocalPersistentQingFile qingFile = new LocalPersistentQingFile(QingPersistentFileType.BUDGET, fileName);
            if (!qingFile.exists()) {
                throw new BillFormException("File not exist. FileName is " + qingFile.getName());
            }
            String newTempFileName = this.copyBudgetFile(fileName);
            tempFilelist.add(newTempFileName);
        }
        BudgetDataSource dataSource = new BudgetDataSource(tag, (AbstractQingFileType)QingTempFileType.TEMP_QS);
        dataSource.setFilter(filter);
        dataSource.setFiles(tempFilelist);
        dataSource.setQingMeta(qingMeta);
        dataSource.setExtractDataTime(new Date().getTime());
        dataSource.setOriginalCreatorId(originalCreatorId);
        IQingSession qingSession = QingSessionUtil.getQingSessionImpl();
        qingSession.setCache((ISessionCacheable)dataSource);
    }

    private String copyBudgetFile(final String fileName) throws BillFormException {
        IQingFile qingTempFile = FileFactory.newTempFile((QingTempFileType)QingTempFileType.TEMP_QS);
        try {
            qingTempFile.write(new IWriteCall(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void call(OutputStream outputStream) throws IOException {
                    BufferedInputStream inputStream = null;
                    try {
                        IQingFileVisitor subQingFile = FileFactory.newFileVisitor((AbstractQingFileType)QingPersistentFileType.BUDGET, (String)fileName);
                        inputStream = new BufferedInputStream((InputStream)subQingFile.getInputStream());
                        IOUtil.copy((InputStream)inputStream, (OutputStream)outputStream);
                    }
                    catch (Throwable throwable) {
                        CloseUtil.close((Closeable[])new Closeable[]{inputStream});
                        throw throwable;
                    }
                    CloseUtil.close((Closeable[])new Closeable[]{inputStream});
                }
            }, true);
        }
        catch (IOException e) {
            throw new BillFormException("Copy file error.");
        }
        return qingTempFile.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createControllerDataSource(String tag, QSDataSourceWriter dataSourceWriter, IQingFile dataFile, ControllerPageParameters pageParameters, String originalCreatorId) throws BillFormException, DataSourcePersistenceException, InterruptedException {
        ControllerDataSource dataSource = new ControllerDataSource(tag, (AbstractQingFileType)QingTempFileType.TEMP_QS, dataFile.getName(), pageParameters.getBizTag());
        QingIntegratedContext qingIntegratedContext = (QingIntegratedContext)this.qingContext;
        ControllerDataProvider dataProvider = new ControllerDataProvider(tag, qingIntegratedContext.getBosContext(), pageParameters);
        try {
            MetaInfo metaInfo = dataProvider.getMeta();
            dataSourceWriter.start(metaInfo);
            Pager pager = null;
            int dataSize = 0;
            do {
                pager = dataProvider.nextPage();
                List<Object[]> datas = pager.getData();
                dataSize += datas.size();
                for (Object[] data : datas) {
                    dataSourceWriter.writeData(data);
                }
            } while (pager.hasNextPage());
            LogUtil.info((String)("ControllerDataProvider all data size = " + dataSize + "; bizTag = " + pageParameters.getBizTag()));
        }
        finally {
            dataProvider.dispose();
        }
        dataSource.setQingMeta(dataProvider.getQingMeta());
        dataSource.setExtractDataTime(new Date().getTime());
        dataSource.setOriginalCreatorId(originalCreatorId);
        dataSourceWriter.finishWriteData();
        IQingSession qingSession = QingSessionUtil.getQingSessionImpl();
        qingSession.setCache((ISessionCacheable)dataSource);
    }

    private Object parsePageParameters(byte[] content) throws Exception {
        Object pageParameters;
        Exception exception = null;
        try {
            pageParameters = QueryUtil.ByteArray2Object(content);
            if (pageParameters != null) {
                return pageParameters;
            }
        }
        catch (ClassNotFoundException e) {
            exception = e;
        }
        catch (IOException e) {
            exception = e;
        }
        try {
            pageParameters = QueryUtil.ByteArray2Object(Base64.decodeBase64((String)new String(content, "utf-8")));
            if (pageParameters != null) {
                return pageParameters;
            }
        }
        catch (ClassNotFoundException e) {
            exception = e;
        }
        catch (IOException e) {
            exception = e;
        }
        throw exception;
    }

    public void createDataSource() {
        String originalCreatorId = null;
        IPrepareDataContext prepareDataContext = this.getPrepareContext();
        if (prepareDataContext instanceof BillPrepareDataContext) {
            BillPrepareDataContext billPrepareDataContext = (BillPrepareDataContext)prepareDataContext;
            originalCreatorId = billPrepareDataContext.getCreatorId();
        }
        String tag = prepareDataContext.getTag();
        String filterParameter = QingSessionUtil.get((String)("qing_filter_" + tag));
        byte[] pageParameterBytes = Base64.decodeBase64((String)filterParameter);
        this.createDataSource(tag, pageParameterBytes, originalCreatorId);
    }

    private void createDataSource(String originalCreatorId) {
        String tag = this.getPrepareContext().getTag();
        String filterParameter = QingSessionUtil.get((String)("qing_filter_" + tag));
        byte[] pageParameterBytes = Base64.decodeBase64((String)filterParameter);
        this.createDataSource(tag, pageParameterBytes, originalCreatorId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createDataSource(String tag, byte[] pageParameterBytes, String originalCreatorId) {
        Object pageParameters = null;
        try {
            pageParameters = this.parsePageParameters(pageParameterBytes);
        }
        catch (Exception e) {
            this.callBackFunction.finishAll((AbstractQingException)new BillFormException(e.getMessage(), e));
            return;
        }
        IQingFile dataFile = FileFactory.newTempFile((QingTempFileType)QingTempFileType.TEMP_QS);
        QSDataSourceWriter dataSourceWriter = null;
        PrepareDataException exception = null;
        try {
            if (pageParameters instanceof QueryPageParameters) {
                dataSourceWriter = new QSDataSourceWriter(dataFile);
                this.createQueryDataSource(tag, dataSourceWriter, dataFile, (QueryPageParameters)pageParameters, originalCreatorId);
            } else if (pageParameters instanceof ControllerPageParameters) {
                dataSourceWriter = new QSDataSourceWriter(dataFile);
                this.createControllerDataSource(tag, dataSourceWriter, dataFile, (ControllerPageParameters)pageParameters, originalCreatorId);
            } else if (pageParameters instanceof BudgetPageParameters) {
                this.createBudgetDataSource(tag, dataFile, (BudgetPageParameters)pageParameters, originalCreatorId);
            }
        }
        catch (PrepareDataException e) {
            exception = e;
        }
        catch (DataSourcePersistenceException e) {
            exception = new BillFormException(e.getMessage(), e);
        }
        catch (Throwable e) {
            exception = new BillFormException(e.getMessage(), e);
        }
        finally {
            if (dataSourceWriter != null) {
                dataSourceWriter.close((Exception)((Object)exception));
            }
            this.callBackFunction.finishAll((AbstractQingException)exception);
        }
    }

    public void createPublishDataSource(String tag, PublishPO publishPO) {
        BillModel billModel;
        String publishId = publishPO.getId();
        try {
            billModel = this.getBillManagerDao().findBillByPublishId(publishId);
        }
        catch (SQLException e) {
            this.callBackFunction.finishAll((AbstractQingException)new PublishedPrepareDataException((Throwable)e));
            return;
        }
        catch (AbstractQingIntegratedException e) {
            this.callBackFunction.finishAll((AbstractQingException)new PublishedPrepareDataException((Throwable)e));
            return;
        }
        String qsFileName = billModel.getQsFileName();
        if (publishPO.isCarryData() || qsFileName != null && !"".equals(qsFileName.trim())) {
            FormDataSource dataSource = new FormDataSource();
            dataSource.setTag(tag);
            dataSource.setOriginalCreatorId(publishPO.getCreatorId());
            dataSource.setLastVisitTime(System.currentTimeMillis());
            dataSource.setExtractDataTime(billModel.getExtractDataTime().getTime());
            dataSource.setStoreFileType((AbstractQingFileType)QingPersistentFileType.EMBEDDED_PUB_QS);
            dataSource.setFileName(billModel.getQsFileName());
            QingSessionUtil.setCache((ISessionCacheable)dataSource);
            this.callBackFunction.finishAll(null);
        } else {
            byte[] filterContent;
            try {
                filterContent = this.getBillManagerDao().loadFilterContent(publishId);
            }
            catch (SQLException e) {
                this.callBackFunction.finishAll((AbstractQingException)new PublishedPrepareDataException((Throwable)e));
                return;
            }
            catch (AbstractQingIntegratedException e) {
                this.callBackFunction.finishAll((AbstractQingException)new PublishedPrepareDataException((Throwable)e));
                return;
            }
            this.extractDataFromPublishedBill(tag, publishPO.getTagId(), billModel.getCtrKey(), filterContent, publishPO.getId(), publishPO.getCreatorId());
        }
    }

    private boolean tryToGetDataSourceFromTemp(String tag, String shareDatasourceCacheKey, AbstractExtractParameters extractParameters) {
        AbstractDataSource shareDatasourceCache = null;
        if (extractParameters instanceof QueryPageParameters) {
            shareDatasourceCache = (AbstractDataSource)QingSessionUtil.getCache((String)AbstractDataSource.getCacheKey((String)tag), FormDataSource.class);
        } else if (extractParameters instanceof ControllerPageParameters) {
            shareDatasourceCache = (AbstractDataSource)QingSessionUtil.getCache((String)AbstractDataSource.getCacheKey((String)tag), ControllerDataSource.class);
        } else if (extractParameters instanceof BudgetPageParameters) {
            shareDatasourceCache = (AbstractDataSource)QingSessionUtil.getCache((String)AbstractDataSource.getCacheKey((String)tag), BudgetDataSource.class);
        }
        if (shareDatasourceCache != null && this.progressModel.getTimeStamp() - shareDatasourceCache.getLastVisitTime() <= 3000L) {
            shareDatasourceCache.setTag(tag);
            QingSessionUtil.setCache((ISessionCacheable)shareDatasourceCache);
            this.callBackFunction.finishAll(null);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractDataFromPublishedBill(String tag, String bizTag, String ctrKey, byte[] filterContent, String publishId, String originalCreatorId) {
        String lockKey = publishId + this.qingContext.getUserId();
        String shareProgressKey = lockKey + ".progress";
        String shareDatasourceKey = lockKey + ".datasource";
        String shareProgressCacheKey = ProgressModel.getCacheKey((String)shareProgressKey);
        String shareDatasourceCacheKey = FormDataSource.getCacheKey((String)shareDatasourceKey);
        ILock lock = LockFactory.createLock((String)lockKey);
        try {
            ExtractDataLock.lock((ILock)lock, (ProgressModel)this.progressModel, (String)shareProgressCacheKey, (String)shareDatasourceKey);
            Object pageParameters = this.parsePageParameters(filterContent);
            AbstractExtractParameters extractParameters = null;
            if (pageParameters instanceof QueryPageParameters) {
                extractParameters = (QueryPageParameters)pageParameters;
            } else if (pageParameters instanceof ControllerPageParameters) {
                extractParameters = (ControllerPageParameters)pageParameters;
            } else if (pageParameters instanceof BudgetPageParameters) {
                extractParameters = (BudgetPageParameters)pageParameters;
            }
            boolean success = this.tryToGetDataSourceFromTemp(tag, shareDatasourceCacheKey, extractParameters);
            if (success) {
                return;
            }
            this.progressModel.setShareTag(shareProgressKey);
            String filterParameter = Base64.encodeBase64String((byte[])QueryUtil.Object2ByteArray(extractParameters));
            QingSessionUtil.set((String)("qing_filter_" + tag), (String)filterParameter);
            this.createDataSource(originalCreatorId);
            AbstractDataSource dataSourceCache = null;
            if (pageParameters instanceof QueryPageParameters) {
                dataSourceCache = (AbstractDataSource)QingSessionUtil.getCache((String)AbstractDataSource.getCacheKey((String)tag), FormDataSource.class);
            } else if (pageParameters instanceof ControllerPageParameters) {
                dataSourceCache = (AbstractDataSource)QingSessionUtil.getCache((String)AbstractDataSource.getCacheKey((String)tag), ControllerDataSource.class);
            } else if (pageParameters instanceof BudgetPageParameters) {
                dataSourceCache = (AbstractDataSource)QingSessionUtil.getCache((String)AbstractDataSource.getCacheKey((String)tag), BudgetDataSource.class);
            }
            if (dataSourceCache != null) {
                dataSourceCache.setOriginalCreatorId(originalCreatorId);
                dataSourceCache.setLastVisitTime(System.currentTimeMillis());
                dataSourceCache.setTag(shareDatasourceKey);
                QingSessionUtil.setCache((ISessionCacheable)dataSourceCache);
            }
        }
        catch (Exception e) {
            this.callBackFunction.finishAll((AbstractQingException)new IntegratedRuntimeException((Throwable)e));
        }
        finally {
            lock.unlock();
        }
    }

    public void createPublishDataSource(PublishPO publishPO, boolean isEditScene) throws PrepareDataException {
        this.createPublishDataSource(this.progressModel.getTag(), publishPO);
    }
}

