/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.dao.impl;

import com.kingdee.bos.qing.common.dao.impl.StringReader;
import java.io.Reader;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;

public abstract class ParameterSetter {
    private static final Map<Class<?>, ParameterSetter> setterCache = new HashMap();
    private static final ObjectSetter objectSetter = new ObjectSetter();
    private static final Class<?> array_cls = Object[].class;

    protected abstract void doSet(PreparedStatement var1, Object var2, int var3) throws SQLException;

    public static void set(PreparedStatement stmt, Object value, int index) throws SQLException {
        ParameterSetter.getSetter(value == null ? Object.class : value.getClass()).doSet(stmt, value, index);
    }

    private static ParameterSetter getSetter(Class<?> p) {
        ParameterSetter ps;
        if (p.isArray() || Iterable.class.isAssignableFrom(p)) {
            p = array_cls;
        }
        if ((ps = setterCache.get(p)) == null) {
            for (Class<?> pcls = p.getSuperclass(); pcls != null; pcls = pcls.getSuperclass()) {
                ps = setterCache.get(pcls);
                if (ps == null) continue;
                setterCache.put(pcls, ps);
                setterCache.put(p, ps);
                break;
            }
            if (ps == null) {
                ps = objectSetter;
                setterCache.put(p.getClass(), ps);
            }
        }
        return ps;
    }

    static {
        BytesSetter bytesSetter = new BytesSetter();
        setterCache.put(Byte.class, bytesSetter);
        setterCache.put(Byte.TYPE, bytesSetter);
        DateSetter dateSetter = new DateSetter();
        setterCache.put(java.util.Date.class, dateSetter);
        setterCache.put(Date.class, dateSetter);
        setterCache.put(Timestamp.class, new TimestampSetter());
        BooleanSetter booleanSetter = new BooleanSetter();
        setterCache.put(Boolean.class, booleanSetter);
        setterCache.put(Boolean.TYPE, booleanSetter);
        DoubleSetter doubleSetter = new DoubleSetter();
        setterCache.put(Double.class, doubleSetter);
        setterCache.put(Double.TYPE, doubleSetter);
        FloatSetter floatSetter = new FloatSetter();
        setterCache.put(Float.class, floatSetter);
        setterCache.put(Float.TYPE, floatSetter);
        LongSetter longSetter = new LongSetter();
        IntSetter intSetter = new IntSetter();
        StringSetter stringSetter = new StringSetter();
        setterCache.put(Short.class, intSetter);
        setterCache.put(Short.TYPE, intSetter);
        setterCache.put(Object.class, objectSetter);
        setterCache.put(Integer.class, objectSetter);
        setterCache.put(Integer.TYPE, objectSetter);
        setterCache.put(Long.class, objectSetter);
        setterCache.put(Long.TYPE, objectSetter);
        setterCache.put(Character.TYPE, stringSetter);
        setterCache.put(Character.class, stringSetter);
        setterCache.put(String.class, stringSetter);
        StringReaderSetter readerSetter = new StringReaderSetter();
        setterCache.put(StringReader.class, readerSetter);
        setterCache.put(BigDecimal.class, new BigDecimalSetter());
        setterCache.put(BigInteger.class, longSetter);
        setterCache.put(BigInteger.class, longSetter);
        setterCache.put(array_cls, new ArraySetter());
    }

    static class ArraySetter
    extends ParameterSetter {
        ArraySetter() {
        }

        @Override
        protected void doSet(PreparedStatement stmt, Object value, int index) throws SQLException {
            int c;
            if (value == null) {
                stmt.setObject(index, null);
                return;
            }
            Class<?> type = null;
            Object[] params = null;
            if (value.getClass().isArray()) {
                type = value.getClass().getComponentType();
                c = Array.getLength(value);
                params = new Object[c];
                for (int i = 0; i < c; ++i) {
                    params[i] = Array.get(value, i);
                }
            } else if (value instanceof Iterable) {
                c = 0;
                LinkedList list = new LinkedList();
                Object[] iter = ((Iterable)value).iterator();
                while (iter.hasNext()) {
                    list.add(iter.next());
                    ++c;
                }
                params = new Object[c];
                list.toArray(params);
            } else {
                params = new Object[]{value};
            }
            if (type == Byte.TYPE) {
                stmt.setBytes(index, (byte[])value);
                return;
            }
            String dbType = stmt.getConnection().getMetaData().getDatabaseProductName().toLowerCase(Locale.ENGLISH);
            if (dbType.equals("mysql")) {
                StringBuilder sb = new StringBuilder(params.length * 19);
                for (Object p : params) {
                    sb.append(p);
                    sb.append(",");
                }
                if (sb.length() > 0) {
                    sb.setLength(sb.length() - 1);
                }
                stmt.setObject(index, sb.toString());
            } else {
                if (type == null || type == Object.class) {
                    for (Object v : params) {
                        if (v == null) continue;
                        type = v.getClass();
                        break;
                    }
                }
                String typeName = "VARCHAR";
                if (type != null) {
                    if (Number.class.isAssignableFrom(type) || type == Integer.TYPE || type == Long.TYPE) {
                        typeName = "Integer";
                    } else if (java.util.Date.class.isAssignableFrom(type)) {
                        typeName = "Timestamp";
                    }
                }
                java.sql.Array array = stmt.getConnection().createArrayOf(typeName, params);
                stmt.setArray(index, array);
            }
        }
    }

    static class ObjectSetter
    extends ParameterSetter {
        ObjectSetter() {
        }

        @Override
        protected void doSet(PreparedStatement stmt, Object value, int index) throws SQLException {
            stmt.setObject(index, value);
        }
    }

    static class BytesSetter
    extends ParameterSetter {
        BytesSetter() {
        }

        @Override
        protected void doSet(PreparedStatement stmt, Object value, int index) throws SQLException {
            stmt.setBytes(index, (byte[])value);
        }
    }

    static class TimestampSetter
    extends ParameterSetter {
        TimestampSetter() {
        }

        @Override
        protected void doSet(PreparedStatement stmt, Object value, int index) throws SQLException {
            stmt.setTimestamp(index, (Timestamp)value);
        }
    }

    static class DateSetter
    extends ParameterSetter {
        DateSetter() {
        }

        @Override
        protected void doSet(PreparedStatement stmt, Object value, int index) throws SQLException {
            stmt.setTimestamp(index, new Timestamp(((java.util.Date)value).getTime()));
        }
    }

    static class FloatSetter
    extends ParameterSetter {
        FloatSetter() {
        }

        @Override
        protected void doSet(PreparedStatement stmt, Object value, int index) throws SQLException {
            stmt.setFloat(index, ((Float)value).floatValue());
        }
    }

    static class DoubleSetter
    extends ParameterSetter {
        DoubleSetter() {
        }

        @Override
        protected void doSet(PreparedStatement stmt, Object value, int index) throws SQLException {
            stmt.setDouble(index, (Double)value);
        }
    }

    static class BigDecimalSetter
    extends ParameterSetter {
        BigDecimalSetter() {
        }

        @Override
        protected void doSet(PreparedStatement stmt, Object value, int index) throws SQLException {
            stmt.setBigDecimal(index, (BigDecimal)value);
        }
    }

    static class LongSetter
    extends ParameterSetter {
        LongSetter() {
        }

        @Override
        protected void doSet(PreparedStatement stmt, Object value, int index) throws SQLException {
            stmt.setLong(index, (Long)value);
        }
    }

    static class StringSetter
    extends ParameterSetter {
        StringSetter() {
        }

        @Override
        protected void doSet(PreparedStatement stmt, Object value, int index) throws SQLException {
            stmt.setString(index, value == null ? null : String.valueOf(value));
        }
    }

    static class StringReaderSetter
    extends ParameterSetter {
        StringReaderSetter() {
        }

        @Override
        protected void doSet(PreparedStatement stmt, Object value, int index) throws SQLException {
            StringReader reader = (StringReader)value;
            stmt.setCharacterStream(index, (Reader)reader, reader.getLength());
        }
    }

    static class IntSetter
    extends ParameterSetter {
        IntSetter() {
        }

        @Override
        protected void doSet(PreparedStatement stmt, Object value, int index) throws SQLException {
            stmt.setInt(index, (Integer)value);
        }
    }

    static class BooleanSetter
    extends ParameterSetter {
        BooleanSetter() {
        }

        @Override
        protected void doSet(PreparedStatement stmt, Object value, int index) throws SQLException {
            String s = (Boolean)value != false ? "1" : "0";
            stmt.setString(index, s);
        }
    }
}

