/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.systemvar;

import com.kingdee.bos.Context;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.context.QingIntegratedContext;
import com.kingdee.bos.qing.common.systemvar.SystemVarValue;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import java.util.Arrays;
import java.util.List;

public class DepartmentSystemVarValue
extends SystemVarValue {
    private volatile List<String> userDptIds;

    public DepartmentSystemVarValue(Object userInfo) {
        super(userInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValue(QingContext qingContext) {
        if (null != this.userDptIds) {
            return this.userDptIds;
        }
        DepartmentSystemVarValue departmentSystemVarValue = this;
        synchronized (departmentSystemVarValue) {
            if (null != this.userDptIds) {
                return this.userDptIds;
            }
            this.userDptIds = this.getCurrentDepartment(qingContext);
            return this.userDptIds;
        }
    }

    public String getStringValue(QingContext qingContext) {
        if (null == this.userDptIds) {
            this.userDptIds = (List)this.getValue(qingContext);
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.userDptIds != null) {
            boolean isFirst = true;
            for (String value : this.userDptIds) {
                if (isFirst) {
                    stringBuffer.append(value);
                    isFirst = false;
                    continue;
                }
                stringBuffer.append("','").append(value);
            }
        }
        return stringBuffer.length() > 0 ? stringBuffer.toString() : null;
    }

    private List<String> getCurrentDepartment(QingContext qingContext) {
        try {
            IPerson iPerson = null;
            UserInfo user = (UserInfo)super.getValue(qingContext);
            if (qingContext == null) {
                iPerson = PersonFactory.getRemoteInstance();
            } else {
                QingIntegratedContext qingIntegratedContext = (QingIntegratedContext)qingContext;
                Context ctx = qingIntegratedContext.getBosContext();
                iPerson = PersonFactory.getLocalInstance((Context)ctx);
            }
            AdminOrgUnitInfo primaryAdminOrgUnit = iPerson.getPrimaryAdminOrgUnit(user.getPerson().getId());
            return primaryAdminOrgUnit != null ? Arrays.asList(primaryAdminOrgUnit.getId().toString()) : null;
        }
        catch (Exception e) {
            LogUtil.error((String)"get getOrgsUserJoin classs instance error", (Throwable)e);
            return null;
        }
    }
}

