/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.systemvar;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.context.QingIntegratedContext;
import com.kingdee.bos.qing.common.systemvar.SystemVarValue;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.eas.base.permission.IOrgRange;
import com.kingdee.eas.base.permission.OrgRangeCollection;
import com.kingdee.eas.base.permission.OrgRangeFactory;
import com.kingdee.eas.base.permission.OrgRangeInfo;
import com.kingdee.eas.base.permission.OrgRangeType;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import java.util.ArrayList;
import java.util.List;

public class OrgRangeSystemVarValue
extends SystemVarValue {
    private static final long serialVersionUID = -2686764374857865090L;
    private volatile List<String> orgIdList = null;
    private OrgRangeType orgRangeType = null;

    public OrgRangeSystemVarValue(Object value, OrgRangeType orgRangeType) {
        super(value);
        this.orgRangeType = orgRangeType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValue(QingContext qingContext) {
        if (null != this.orgIdList) {
            return this.orgIdList;
        }
        OrgRangeSystemVarValue orgRangeSystemVarValue = this;
        synchronized (orgRangeSystemVarValue) {
            if (null != this.orgIdList) {
                return this.orgIdList;
            }
            ArrayList<String> tmpOrgIdList = new ArrayList<String>();
            UserInfo user = (UserInfo)super.getValue(qingContext);
            ObjectUuidPK userPK = new ObjectUuidPK(user.getId());
            try {
                Object[] orgInfos;
                IOrgRange orgRange = null;
                if (qingContext == null) {
                    orgRange = OrgRangeFactory.getRemoteInstance();
                } else {
                    QingIntegratedContext qingIntegratedContext = (QingIntegratedContext)qingContext;
                    Context ctx = qingIntegratedContext.getBosContext();
                    orgRange = OrgRangeFactory.getLocalInstance((Context)ctx);
                }
                OrgRangeCollection rangeCollection = orgRange.findFullOrgCol((IObjectPK)userPK, this.orgRangeType);
                for (Object orgObj : orgInfos = rangeCollection.toArray()) {
                    OrgRangeInfo org = (OrgRangeInfo)orgObj;
                    FullOrgUnitInfo orgFullInfo = org.getOrg();
                    if (null == orgFullInfo) continue;
                    tmpOrgIdList.add(orgFullInfo.getString("id"));
                }
                LogUtil.info((String)("current org range id list:" + tmpOrgIdList));
                this.orgIdList = tmpOrgIdList;
                return this.orgIdList;
            }
            catch (Exception e) {
                LogUtil.error((String)"get orgrange classs instance error", (Throwable)e);
                return null;
            }
        }
    }

    public String getStringValue(QingContext qingContext) {
        if (null == this.orgIdList) {
            this.orgIdList = (List)this.getValue(qingContext);
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.orgIdList != null) {
            boolean isFirst = true;
            for (String value : this.orgIdList) {
                if (isFirst) {
                    stringBuffer.append(value);
                    isFirst = false;
                    continue;
                }
                stringBuffer.append("','").append(value);
            }
        }
        return stringBuffer.length() > 0 ? stringBuffer.toString() : null;
    }
}

