/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.dashboard.extReport.dao;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ResultHandler;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.dashboard.extReport.model.ExtReportInfo;
import com.kingdee.bos.qing.dashboard.extReport.util.DsbExtReportUtil;
import com.kingdee.eas.common.client.SysContext;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class DsbExtReportDao {
    private IDBExcuter dbExcuter;
    private static final String CLIENT_TYPE = "client";
    private static final String PORTAL_TYPE = "portal";
    private static final String PORTLET_TYPE = "portlet";
    private static final String APPCENTER_TYPE = "appCenter";

    public DsbExtReportDao(IDBExcuter dbExcuter) {
        this.dbExcuter = dbExcuter;
    }

    public List<ExtReportInfo> getReportModulList(final Context context, String orgId, String userId) throws SQLException, AbstractQingIntegratedException {
        String strLocal = SysContext.getSysContext().getLocale().toString();
        String sql = "SELECT distinct d.FID, d.FNAME_" + strLocal + " as FREPORTNAME, d.FSYSTEMID,  o.FDISPLAYNAME_" + strLocal + " as FDISPLAYNAME from T_BAS_DefineReport d  left join t_org_baseunit o on d.forgid = o.fid where d.ftemplettype = -1 and d.FCloudRptVersion is null and d.FOrgID = ? order by FREPORTNAME";
        return (List)this.dbExcuter.query(sql, new Object[]{orgId}, (ResultHandler)new ResultHandler<List<ExtReportInfo>>(){

            public List<ExtReportInfo> handle(ResultSet rs) throws SQLException {
                ArrayList<ExtReportInfo> infoList = new ArrayList<ExtReportInfo>();
                while (rs.next()) {
                    ExtReportInfo info = new ExtReportInfo();
                    info.setReportName(rs.getString("FREPORTNAME"));
                    String systemId = rs.getString("FSYSTEMID");
                    info.setOrgFullName(rs.getString("FDISPLAYNAME"));
                    info.setSystemId(systemId);
                    String systemPath = DsbExtReportUtil.getSystemPath(context, systemId);
                    info.setSystemPath(systemPath);
                    infoList.add(info);
                }
                return infoList;
            }
        });
    }

    public List<ExtReportInfo> getAuthorizedReportList(final Context context, String orgId, String userId) throws SQLException, AbstractQingIntegratedException {
        String strLocal = SysContext.getSysContext().getLocale().toString();
        String sql = "SELECT distinct d.FID ,d.FNAME_" + strLocal + " as FREPORTNAME,d.FDEPLOYPATH ,d.FSYSTEMID, m.FNAME_" + strLocal + " as FMENUNAME,d.feaswebappcenterid,d.fbipath,d.fportletname ,d.feaswebappcenterpath, d.flastupdatetime , o.FDISPLAYNAME_" + strLocal + " as FDISPLAYNAME FROM T_BAS_DefineReport d LEFT JOIN T_PM_MAINMENUITEM m on  d.FMENUID = M.FID  left join t_org_baseunit o on d.forgid = o.fid where d.ftemplettype = -1 and (d.FDEPLOYPATH is not null or d.feaswebappcenterpath is not null or d.fbipath is not null or d.fportletname is not null) and d.FID in ( select p.FReportID from T_EXT_Permission p INNER JOIN T_BAS_DefineReport r on p.FReportID=r.fid where p.FUserID = ? and p.FOrgID = ? and SUBSTRING(p.fpermission,1,1) = '1' union select p.FReportID from T_EXT_Permission p INNER JOIN T_BAS_DefineReport r on p.FReportID=r.fid where p.FUserID = ? and p.FOrgID is null and SUBSTRING(p.fpermission,1,1) = '1' union select p.FReportID from T_EXT_Permission p INNER JOIN T_BAS_DefineReport r on p.FReportID=r.fid INNER JOIN t_pm_userroleorg uro ON p.froleid = uro.froleid where uro.FUserID = ? and uro.FOrgID = ? and SUBSTRING(p.fpermission,1,1) = '1' ) order by d.flastupdatetime desc";
        return (List)this.dbExcuter.query(sql, new Object[]{userId, orgId, userId, userId, orgId}, (ResultHandler)new ResultHandler<List<ExtReportInfo>>(){

            public List<ExtReportInfo> handle(ResultSet rs) throws SQLException {
                ArrayList<ExtReportInfo> infoList = new ArrayList<ExtReportInfo>();
                while (rs.next()) {
                    String menuName = rs.getString("FMENUNAME");
                    String biPath = rs.getString("fbipath");
                    String portletName = rs.getString("fportletname");
                    String easwebappcenterId = rs.getString("feaswebappcenterid");
                    String systemId = rs.getString("FSYSTEMID");
                    ExtReportInfo info = new ExtReportInfo();
                    info.setReportName(rs.getString("FREPORTNAME"));
                    info.setSystemId(systemId);
                    info.setOrgFullName(rs.getString("FDISPLAYNAME"));
                    String systemPath = DsbExtReportUtil.getSystemPath(context, systemId);
                    info.setSystemPath(systemPath);
                    if (!StringUtil.isEmptyString((String)menuName)) {
                        info.setMenuName(menuName);
                        info.setReportType(DsbExtReportDao.CLIENT_TYPE);
                        info.setDeployPath(DsbExtReportDao.getPathWithoutName(rs.getString("FDEPLOYPATH")));
                        infoList.add(info);
                    }
                    if (!StringUtil.isEmptyString((String)biPath)) {
                        info.setMenuName(DsbExtReportDao.getNameFromPath(biPath));
                        info.setReportType(DsbExtReportDao.PORTAL_TYPE);
                        info.setDeployPath(DsbExtReportDao.getPathWithoutName(biPath));
                        infoList.add(info);
                    }
                    if (!StringUtil.isEmptyString((String)portletName)) {
                        info.setMenuName(portletName);
                        info.setReportType(DsbExtReportDao.PORTLET_TYPE);
                        info.setDeployPath(DsbExtReportDao.getDeployName(portletName));
                        infoList.add(info);
                    }
                    if (StringUtil.isEmptyString((String)easwebappcenterId)) continue;
                    info.setMenuName(DsbExtReportDao.getNameFromPath(rs.getString("feaswebappcenterpath")));
                    info.setReportType(DsbExtReportDao.APPCENTER_TYPE);
                    info.setDeployPath(DsbExtReportDao.getPathWithoutName(rs.getString("feaswebappcenterpath")));
                    infoList.add(info);
                }
                return infoList;
            }
        });
    }

    private static String getNameFromPath(String str) {
        int last;
        if (str.length() > 0 && (last = str.lastIndexOf("/")) != -1) {
            str = str.substring(last + 1);
        }
        return str;
    }

    private static String getPathWithoutName(String str) {
        if (str.length() > 0) {
            int n = str.indexOf("@@");
            int last = str.lastIndexOf("/");
            int start = 0;
            int end = 0;
            if (n != -1) {
                start = n + 2;
            }
            end = last > n ? last : str.length();
            str = str.substring(start, end);
        }
        return str;
    }

    private static String getDeployName(String str) {
        int n;
        if (str.length() > 0 && (n = str.indexOf("@@")) != -1) {
            str = str.substring(n + 2);
        }
        return str;
    }
}

